#ifndef OPT_SYS_H
#define OPT_SYS_H

/*** Qt ***/
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlineedit.h>

#include <qdialog.h>

/*** KDE ***/
#include <kapp.h>  // wg. i18n
#include <ksimpleconfig.h>
#include <krestrictedline.h>
#include <kfiledialog.h>
#include <ktabctl.h>

/*** C++ ***/
#include <fstream.h>

/*** KisoCD ***/
#include "tools.h"
#include "types.h"
#include "version.h"


/*** system ***/
#include <asm/shmparam.h>

class opt_sys : public QDialog  {
   Q_OBJECT
private:
    KSimpleConfig*    globalConf;
    T_FileOptions*    fileOpts;
    bool              validDevices;

public: 
	opt_sys(QWidget        *parent, 
		const char     *name,
		KSimpleConfig  *globConf,
		T_FileOptions  *sysOpts,
		bool           cdrecordAllowed);
	~opt_sys();

protected: 
	QGroupBox *QGroupBox_1;
	QComboBox *QComboBox_1;
	QGroupBox *QGroupBox_2;
	QLineEdit *il_device;
	QPushButton *QPushButton_1;
	QGroupBox *QGroupBox_3;
	QComboBox *QComboBox_2;
	QLabel *QLabel_2;
	QSpinBox *QSpinBox_1;
	QLabel *QLabel_3;
	QGroupBox *QGroupBox_4;
	QComboBox *QComboBox_3;
	QLabel *QLabel_4;
	QPushButton *QPushButton_2;
	QGroupBox *QGroupBox_5;
	QLineEdit *QLineEdit_1;
	QLineEdit *il_imagepath;
	QPushButton *buttonApply;
	QPushButton *buttonCancel;
	QPushButton *buttonOK;
	/*** ???? ***/
	QCheckBox *cb_eject;
	QCheckBox *cb_shutdown;
	QComboBox *combo_blankSpeed;
	QLabel    *label_blankSpeed;
	/*** allgemein ***/
	KTabCtl*       tabCtl;
	QWidget*       tabP1;
	QWidget*       tabP2;

protected slots:
   void applySettings();
   void ok_clicked(); 
   void imagefileBrowseClicked();
   void writeDeviceSFileBrowseClicked();
private: 
   void scanScsiBus(bool); 
   int getNrSpeeds();
   string getSpeed(int);
   int getNr(int speed);
};

#endif










