#include "opt_sys.h"

#define deviceError_noDevice "no device available!"
#define deviceError_notRoot  "error executing cdrecord -scanbus, maybe I'm not root?"
#define deviceError_writerActive "Unable to scan devices while writer is active!"

opt_sys::opt_sys(QWidget*       parent, 
		 const char*    name,
		 KSimpleConfig* globConf,
		 T_FileOptions* sysOpts,
		 bool           cdrecordAllowed)
  : QDialog(parent,name,true)
{
  string tempStr;
  
  // optionen
  globalConf = globConf;
  fileOpts   = sysOpts;

  // fenster
  this->setGeometry(0,0,540,460);
  this->setMinimumSize(540,460);
  this->setMaximumSize(540,460);

  // tabs
  tabCtl = new KTabCtl(this, "tabPages");
  tabCtl->setGeometry(1, 1, 530, 380);
  tabP1 = new QWidget(tabCtl, "tabP1");
  tabCtl->addTab(tabP1, i18n("devices, directories, ..."));
  tabP2 = new QWidget(tabCtl, "tabP2");
  tabCtl->addTab(tabP2, i18n("more options"));

  // writing device
  QGroupBox_1= new QGroupBox(tabP1,"NoName");
  QGroupBox_1->setGeometry(20,20,490,60);
  QGroupBox_1->setTitle(i18n("writing device"));

  QComboBox_1= new QComboBox(tabP1,"NoName");
  QComboBox_1->setGeometry(30,40,470,30);

  // reading device
  QGroupBox_2= new QGroupBox(tabP1,"NoName");
  QGroupBox_2->setGeometry(20,90,490,60);
  QGroupBox_2->setTitle(i18n("writing device (name of its special file; only for multisession)"));

  il_device= new QLineEdit(tabP1,"NoName");
  il_device->setGeometry(30,110,320,30);
  il_device->setText(fileOpts->writeDeviceSFile.c_str());

  QPushButton_1= new QPushButton(tabP1,"NoName");
  QPushButton_1->setGeometry(400,110,100,30);
  QPushButton_1->setText(i18n("browse..."));

  // writing on-the-fly
  QGroupBox_3= new QGroupBox(tabP1,"NoName");
  QGroupBox_3->setGeometry(20,160,225,100);
  QGroupBox_3->setTitle(i18n("writing on-the-fly"));

  QComboBox_2= new QComboBox(tabP1,"NoName");
  QComboBox_2->setGeometry(30,180,60,30);
  QComboBox_2->setMinimumSize(0,0);

  for (int cnt=0; cnt < getNrSpeeds(); cnt++)
    QComboBox_2->insertItem(getSpeed(cnt).c_str());

  QComboBox_2->setCurrentItem(getNr(fileOpts->nWritingSpeedOTF));

  QLabel_2= new QLabel(tabP1,"NoName");
  QLabel_2->setGeometry(100,180,135,30);
  QLabel_2->setText(i18n("writing speed"));

  QSpinBox_1= new QSpinBox(tabP1,"NoName");
  QSpinBox_1->setGeometry(30,220,60,30);
  
  // hier nehme ich ein 1MB weniger, als die Konstante eigentlich angibt.
  // Hintergrund dazu findet sich in einer Mail in kisocdI-2000-03 (fifo-size)
  QSpinBox_1->setRange(4, (SHMMAX / (1024*1024))-1);
  QSpinBox_1->setValue(fileOpts->nFifoSize);

  QLabel_3= new QLabel(tabP1,"NoName");
  QLabel_3->setGeometry(100,220,110,30);
  QLabel_3->setText(i18n("buffer size (MB)"));

  // writing from imagefile
  QGroupBox_4= new QGroupBox(tabP1,"NoName");
  QGroupBox_4->setGeometry(255,160,255,100);
  QGroupBox_4->setTitle(i18n("writing from imagefile"));

  QComboBox_3= new QComboBox(tabP1,"NoName");
  QComboBox_3->setGeometry(265,180,60,30);
  QComboBox_3->setMinimumSize(0,0);

  for (int cnt=0; cnt < getNrSpeeds(); cnt++)
    QComboBox_3->insertItem(getSpeed(cnt).c_str());

  QComboBox_3->setCurrentItem(getNr(fileOpts->nWritingSpeedImg));

  QLabel_4= new QLabel(tabP1,"NoName");
  QLabel_4->setGeometry(335,180,135,30);
  QLabel_4->setText(i18n("writing speed"));

  QPushButton_2= new QPushButton(tabP1,"NoName");
  QPushButton_2->setGeometry(400,220,100,30);
  QPushButton_2->setText(i18n("browse..."));

  il_imagepath= new QLineEdit(tabP1,"NoName");
  il_imagepath->setGeometry(265,220,132,30);
  il_imagepath->setText(fileOpts->imageFilePath.c_str());

  // mountpoint
  QGroupBox_5= new QGroupBox(tabP1,"NoName");
  QGroupBox_5->setGeometry(20,270,490,60);
  QGroupBox_5->setTitle(i18n("where to mount images"));

  QLineEdit_1= new KRestrictedLine(tabP1,"NoName", 
				   "~#0123456789_-.abcdefghijklmnopqrstuvwxyz "
				   "ABCDEFGHIJKLMNOPQRSTUVWXYZ/");
  QLineEdit_1->setGeometry(30,290,470,30);
  QLineEdit_1->setText(fileOpts->mountPoint.c_str());

  // ???
  cb_eject = new QCheckBox(tabP2, "NoName");
  cb_eject->setGeometry(20, 20, 270, 30);
  cb_eject->setText(i18n("eject CD after process finished"));
  cb_eject->setChecked(fileOpts->fEject);

  cb_shutdown = new QCheckBox(tabP2, "NoName");
  cb_shutdown->setGeometry(20, 50, 270, 30);
  cb_shutdown->setText(i18n("shutdown the system after process finished"));
  cb_shutdown->setChecked(fileOpts->fShutdown);

  combo_blankSpeed =new QComboBox(tabP2,"NoName");
  combo_blankSpeed->setGeometry(20,80,60,30);
  combo_blankSpeed->setMinimumSize(0,0);

  for (int cnt=0; cnt < getNrSpeeds(); cnt++)
    combo_blankSpeed->insertItem(getSpeed(cnt).c_str());

  cout << "opt_sys done a\n";
  cout.flush();


  combo_blankSpeed->setCurrentItem(getNr(fileOpts->nBlankingSpeed));

  cout << "opt_sys done b\n";
  cout.flush();


  label_blankSpeed= new QLabel(tabP2,"NoName");
  label_blankSpeed->setGeometry(90,80,135,30);
  label_blankSpeed->setText(i18n("CDRW-blanking speed"));


  // buttons
  buttonOK = new QPushButton(this,"NoName");
  buttonOK->setGeometry(170,410,100,30);
  buttonOK->setText(i18n("OK"));
  buttonOK->setDefault(true);  

  buttonApply = new QPushButton(this,"NoName");
  buttonApply->setGeometry(290,410,100,30);
  buttonApply->setText(i18n("Apply"));

  buttonCancel= new QPushButton(this,"NoName");
  buttonCancel->setGeometry(410,410,100,30);
  buttonCancel->setText(i18n("Cancel"));

  // Signale und Slots verbinden:
  connect(QPushButton_1, SIGNAL(clicked()), SLOT(writeDeviceSFileBrowseClicked()) );
  connect(QPushButton_2, SIGNAL(clicked()), SLOT(imagefileBrowseClicked()) );
  connect(buttonCancel, SIGNAL(clicked()), SLOT(accept()));
  connect(buttonApply, SIGNAL(clicked()), SLOT(applySettings()));
  connect(buttonOK, SIGNAL(clicked()), SLOT(ok_clicked()));

  // Laden der globalen Konfig-Datei
  if (globalConf->readEntry("oSys_writeDevice", "noValue") != "noValue")
    QComboBox_1->setEnabled(false);
  if (globalConf->readEntry("oSys_writeDeviceSFile", "noValue") != "noValue")
    {
      QPushButton_1->setEnabled(false);
      il_device->setEnabled(false);
    }
  if (globalConf->readEntry("oSys_mntpnt", "noValue") != "noValue")
    QLineEdit_1->setEnabled(false);
  if (globalConf->readEntry("oSys_imagePath", "noValue") != "noValue")
    {
      QPushButton_2->setEnabled(false);
      il_imagepath->setEnabled(false);
    }
  if (globalConf->readNumEntry("oSys_fifoSize", 65000) != 65000)
    QSpinBox_1->setEnabled(false);
  if (globalConf->readNumEntry("oSys_speedOTF", 65000) != 65000)
    QComboBox_2->setEnabled(false);
  if (globalConf->readNumEntry("oSys_speedImg", 65000) != 65000)
    QComboBox_3->setEnabled(false);
  if (globalConf->readNumEntry("oSys_speedBlank", 65000) != 65000)
    combo_blankSpeed->setEnabled(false);

  if (globalConf->readEntry("oSys_eject", "noValue") != "noValue")
    cb_eject->setEnabled(false);
  if (globalConf->readEntry("oSys_shutdown", "noValue") != "noValue")
    cb_shutdown->setEnabled(false);

  // mit cdrecord nach cd-brennern suchen usw.
  scanScsiBus(cdrecordAllowed);

  cout << "opt_sys done\n";
  cout.flush();
}

int opt_sys::getNrSpeeds()
{
  string list;
  int    nr = 0;

  list = fileOpts->availSpeed;

  while (list.find(",") != string::npos)
    {
      list.replace(0, list.find(",")+1, "");      
      nr++;
    }
  return(nr); 
}

string opt_sys::getSpeed(int nr)
{
  string list;
  int    nr2;

  list = fileOpts->availSpeed;

  for (nr2=0; nr2 < nr; nr2++)
    list.replace(0, list.find(",")+1, "");

  return(list.substr(0, list.find(",")));
}

int opt_sys::getNr(int speed)
{
  string list;
  int    nr2 = 0;

  list = fileOpts->availSpeed;

  while (atoi(list.substr(0, list.find(",")).c_str()) != speed)
    {
      list.replace(0, list.find(",")+1, "");      
      nr2++;
      if (list.size() == 0)
	{
	  fehlermeldung(i18n("error with available-speeds-list!"));
	  return(0);
	}
    }
  return(nr2);
}

void opt_sys::ok_clicked()
{
  applySettings();
  emit(accept());
}

void opt_sys::imagefileBrowseClicked()
{
#ifdef slotLog
  cerr << "Slot: browseClicked\n";
  cerr.flush();
#endif

  infomeldung(i18n("If you want to create multisession or bootable CDs,\n"
		   "you mustn't use a directory from a vfat-partition!"));
  
  string altName;
  
  altName = il_imagepath->text();
  
  QString name= KFileDialog::getSaveFileName(holStartVerz(altName).c_str(), "*");

  if (!name.isEmpty())
    {
      altName = name;
      if (altName[altName.size()-1] != '/') il_imagepath->setText(name);  
      else fehlermeldung(i18n("You have to name a file, not a directory!"));
    }
}

void opt_sys::writeDeviceSFileBrowseClicked()
{
#ifdef slotLog
  cerr << "Slot: browseClicked\n";
  cerr.flush();
#endif
  
  string altName;
  
  altName = il_device->text();
  
  QString name= KFileDialog::getOpenFileName(holStartVerz(altName).c_str(), "*");

  if (!name.isEmpty())
    {
      altName = name;
      if (altName[altName.size()-1] != '/') il_device->setText(name);  
      else fehlermeldung(i18n("You have to name a file, not a directory!"));
    }
}

opt_sys::~opt_sys()
{
}

void opt_sys::applySettings()
{
  if (validDevices) fileOpts->writeDevice = QComboBox_1->currentText();

  fileOpts->imageFilePath  = il_imagepath->text();  
  fileOpts->nFifoSize      = QSpinBox_1->value();
  if (fileOpts->nFifoSize > 16)
    infomeldung(i18n("Note that linux for x86 usually only allows up to 16MB for shared\n"
		     "memory, but you opted for a larger buffer size. If you compiled KisoCD\n"
		     "on your system, it should limit the value to the allowed maximum; if\n"
		     "you did not, it may allow you to set an incorrect value which may\n"
		     "lead to problems when writing on-the-fly."));

  fileOpts->nWritingSpeedOTF = atoi(getSpeed((QComboBox_2->currentItem())).c_str());
  fileOpts->nWritingSpeedImg = atoi(getSpeed((QComboBox_3->currentItem())).c_str());
  fileOpts->nBlankingSpeed   = atoi(getSpeed((combo_blankSpeed->currentItem())).c_str());

  fileOpts->fEject    = cb_eject->isChecked();
  fileOpts->fShutdown = cb_shutdown->isChecked();
  
  // mountPoint in das richtige Format bringen:
  //  - "/" als erstes Zeichen
  //  - letztes Zeichen KEIN "/"
  fileOpts->mountPoint = QLineEdit_1->text();
  if (fileOpts->mountPoint[0] != '/') fileOpts->mountPoint = "/" + fileOpts->mountPoint;
  while (fileOpts->mountPoint[fileOpts->mountPoint.length()-1] == '/') 
    fileOpts->mountPoint.replace(fileOpts->mountPoint.length()-1, 1, "");

  fileOpts->writeDeviceSFile = il_device->text();
}

void opt_sys::scanScsiBus(bool cdrecordAllowed)
{
  string cdrecordPath;
  string tmpScriptPfad;

  validDevices = false;

  cdrecordPath = whereisExec("cdrecord");

  tmpScriptPfad = getNrFile("/tmp/", "kisocd");
    
  // geht nur, wenn man schon "root" ist.
  string scriptPfad = cdrecordPath;
  scriptPfad += " -scanbus > ";
  scriptPfad += tmpScriptPfad;

  if (cdrecordAllowed)
    {
      if (system(scriptPfad.c_str()) != 0) 
	{ 
	  QComboBox_1->insertItem(deviceError_notRoot);
	}
      else 
	{
	  // Datei auswerten, Daten in der Box zur Auswahl anbieten
	  ifstream        scanDat;
	  string          bus;
	  string          target;
	  string          descr;
	  char            Zeile[500];
	  string          Ausgabe;
	  string          newDevice;
	  
	  scanDat.open(tmpScriptPfad.c_str());   
	  while (!scanDat.eof()) 
	    {
	      scanDat.getline(Zeile, 498);
	      Ausgabe = Zeile;
	      if (Ausgabe.find("scsibus") == 0) 
		{
		  Ausgabe.replace(0, 7, "");
		  Ausgabe.replace(Ausgabe.find(":"), 1, "");
		  bus = Ausgabe;
		}
	      else 
		if ((Ausgabe.find("CD-ROM") != string::npos) ||
                    (Ausgabe.find("WORM") != string::npos))
		  {
		    while (!((Ausgabe[0] >= '0') && (Ausgabe[0] <= '9')))
		      Ausgabe.replace(0, 1, "");
		    descr = Ausgabe;
		    descr.replace(0, descr.find(") ")+2, "");
		    Ausgabe.replace(Ausgabe.find(")"), 99, "");
		    target = Ausgabe;
		    /*
		      man cdrecord:
		      
		      -scanbus
		      Scan  all SCSI devices on all SCSI busses and print
		      the inquiry strings. This option  may  be  used  to
		      find  SCSI  address of the CD-Recorder on a system.
		      The numbers printed out as labels are computed  by:
		      bus * 100 + target
		      
		      wr@verilin:/home/wr > cdrecord -scanbus
		      Cdrecord release 1.8a22 Copyright (C) 1995-1999 Jrg Schilling
		      scsibus1:
          		      100) 'QUANTUM ' 'FIREBALL_TM3200S' '300X' Disk
			      101) *
			      102) 'TANDBERG' ' TDC 3800            ' 'G03B' Removable Tape
			      103) *
			      104) 'TEAC      ' 'CD-R58S                ' '1.0G' Removable CD-ROM
			      105) *
			      106) *
			      107) *
		    */
		    // ab 1.8a26 hat sich das Format gendert:
		    /*
		      [root@sol stewart]# cdrecord -scanbus
		      Cdrecord release 1.8a29 Copyright (C) 1995-1999 Jrg Schilling
		      Using libscg version 'schily-0.1'
		      scsibus0:
              		      0,0,0     0) 'SAMSUNG ' 'CD-ROM SCR-3230 ' 'S104' Removable CD-ROM
			      0,1,0     1) 'HI-VAL  ' 'H2242           ' '2.06' Removable CD-ROM
			      0,2,0     2) *
			      0,3,0     3) *
			      0,4,0     4) *
			      0,5,0     5) *
			      0,6,0     6) *
			      0,7,0     7) *
			      [root@sol stewart]#       
		    */
		    if (target.find(",") != string::npos)
		      {
			// es ist cdrecord 1.8a26 oder jnger
			// Patch von Wolfgang Scherer, damit auch auf Tabs getestet wird; 
			// in 0.5.2 eingeflossen:
			/* [Wolfgang.Scherer@gmx.de]
			   Und zumindest ab v1.8a30 werden TABs als Trennzeichen verwendet.
			   Z.B. kommt es bei
			   
			   1,0,0\t100) 'NEC     ' 'CD-ROM DRIVE:282' '4.62' Removable CD-ROM
			   
			   zu einem SIG_ABORT, weil zu viel abgeschnitten wird!
			*/	  
			while (target[target.length()-1] != ' ' && target[target.length()-1] != '\t') 
                          target.replace(target.length()-1, 1, "");
			while (target[target.length()-1] == ' ' || target[target.length()-1] == '\t')
                          target.replace(target.length()-1, 1, "");
			
			cout << "bus, target, lun: " << target << "  " << descr << "\n";
			Ausgabe = target + " (" + descr + ")";		  
		      }
		    else 
		      {
			// es ist cdrecord 1.8a25 oder lter
			
			// "bus" abschneiden:
			if (target.length() > 2) target.replace(0, 1, ""); 
			
			// evtl. Zehner-Null abschneiden:
			if (target.length() > 1 && target[0] == '0') target.replace(0, 1, "");    
			
			cout << "bus, target: " << bus << ", " << target << "  " << descr << "\n";
			Ausgabe = bus + "," + target + ",0 (" + descr + ")";
		      }
		    QComboBox_1->insertItem(Ausgabe.c_str());
		    validDevices = true;
		  }
	    }
	  scanDat.close(); // Zeile erst in 0.4 hinzugefgt!
	  
	  // Jetzt noch die vorige Einstellung markieren.
	  bool fertig = false;
	  
	  for (int Cnt = QComboBox_1->count()-1; Cnt >= 0; Cnt--) 
	    {
	      Ausgabe = QComboBox_1->text(Cnt);
	      if (Ausgabe.compare(fileOpts->writeDevice) == 0) 
		{ 
		  QComboBox_1->setCurrentItem(Cnt);
		  fertig = true;
		}
	    }
	  if (!fertig && QComboBox_1->count() == 0) 
	    QComboBox_1->insertItem(deviceError_noDevice);      
	}
      unlink(tmpScriptPfad.c_str());
    }
  else
    {
	  QComboBox_1->insertItem(deviceError_writerActive);	  
    }  
}
#include "opt_sys.moc"














