#include "opt_cddoc.h"

opt_cddoc::opt_cddoc(QWidget*       parent,
		     const char*    name,
		     KSimpleConfig* globConf,
		     T_FileOptions* sysOpts)
  :QDialog( parent, name, TRUE, 110592 ) {

  globalConf = globConf;
  fileOpts   = sysOpts;
  /****************************** cdDoc *********************************************/
  labelLatex = new QLabel( this, "Label_1" );
  labelLatex->setGeometry( 20, 20, 50, 30 );
  labelLatex->setText( i18n("LaTeX") );
  labelLatex->setAlignment( 289 );
  labelLatex->setMargin( -1 );
  
  labelView = new QLabel( this, "Label_2" );
  labelView->setGeometry( 20, 60, 50, 30 );
  labelView->setText( i18n("view") );
  labelView->setAlignment( 289 );
  labelView->setMargin( -1 );
  
  labelPrint = new QLabel( this, "Label_3" );
  labelPrint->setGeometry( 20, 100, 50, 30 );
  labelPrint->setText( i18n("print") );
  labelPrint->setAlignment( 289 );
  labelPrint->setMargin( -1 );
  
  labelEdit = new QLabel( this, "Label_4" );
  labelEdit->setGeometry( 20, 140, 50, 30 );
  labelEdit->setText( i18n("editor") );
  labelEdit->setAlignment( 289 );
  labelEdit->setMargin( -1 );

  leLatex = new QLineEdit( this, "LineEdit_1" );
  leLatex->setGeometry( 70, 20, 150, 30 );
  leLatex->setText(fileOpts->latexCmd.c_str());
  leLatex->setMaxLength( 32767 );
  leLatex->setEchoMode( QLineEdit::Normal );
  leLatex->setFrame( TRUE );
  
  leView = new QLineEdit( this, "LineEdit_2" );
  leView->setGeometry( 70, 60, 150, 30 );
  leView->setText(fileOpts->viewCmd.c_str());
  leView->setMaxLength( 32767 );
  leView->setEchoMode( QLineEdit::Normal );
  leView->setFrame( TRUE );
  
  lePrint = new QLineEdit( this, "LineEdit_3" );
  lePrint->setGeometry( 70, 100, 150, 30 );
  lePrint->setText(fileOpts->printCmd.c_str());
  lePrint->setMaxLength( 32767 );
  lePrint->setEchoMode( QLineEdit::Normal );
  lePrint->setFrame( TRUE );
  
  leEdit = new QLineEdit( this, "LineEdit_4" );
  leEdit->setGeometry( 70, 140, 150, 30 );
  
  leEdit->setText(fileOpts->editorCmd.c_str());
  leEdit->setMaxLength( 32767 );
  leEdit->setFrame( TRUE );

  /******************************** allgemein **************************************/
  buttonOK = new QPushButton( this, "PushButton_2" );
  buttonOK->setGeometry( 10, 190, 110, 30 );
  buttonOK->setText( i18n("OK") );
  buttonOK->setDefault(true);
  connect(buttonOK, SIGNAL(clicked()), SLOT(ok_clicked()));

  buttonApply = new QPushButton( this, "PushButton_2" );
  buttonApply->setGeometry( 130, 190, 110, 30 );
  buttonApply->setText( i18n("Apply") );
  connect(buttonApply, SIGNAL(clicked()), SLOT(applySettings()));

  buttonCancel = new QPushButton( this, "PushButton_1" );
  buttonCancel->setGeometry( 250, 190, 110, 30 );
  buttonCancel->setText( i18n("Cancel") );
  connect(buttonCancel, SIGNAL(clicked()), SLOT(accept()));
     
  resize( 370, 240 );
  setMinimumSize( 370, 240 );
  setMaximumSize( 370, 240 );

  /* Die Einstellungen aufgrund der globalen Konfig-datei vornehmen */
  if (globalConf->readEntry("oCDDoc_latex", "noValue") != "noValue")
    leLatex->setEnabled(false);
  if (globalConf->readEntry("oCDDoc_view", "noValue") != "noValue")
    leView->setEnabled(false);
  if (globalConf->readEntry("oCDDoc_print", "noValue") != "noValue")
    lePrint->setEnabled(false);
  if (globalConf->readEntry("oCDDoc_editor", "noValue") != "noValue")
    leEdit->setEnabled(false);
}

void opt_cddoc::ok_clicked()
{
  applySettings();
  emit(accept());
}

void opt_cddoc::applySettings()
{
  fileOpts->latexCmd  = leLatex->text();
  fileOpts->viewCmd   = leView->text();
  fileOpts->printCmd  = lePrint->text();
  fileOpts->editorCmd = leEdit->text();

  // hinter jedem Befehl soll exakt kein Leerzeichen stehen!
  while (fileOpts->latexCmd[fileOpts->latexCmd.size()-1] == ' ') 
    fileOpts->latexCmd.replace(fileOpts->latexCmd.size()-1, 1, ""); 
  while (fileOpts->viewCmd[fileOpts->viewCmd.size()-1] == ' ') 
    fileOpts->viewCmd.replace(fileOpts->viewCmd.size()-1, 1, ""); 
  while (fileOpts->printCmd[fileOpts->printCmd.size()-1] == ' ') 
    fileOpts->printCmd.replace(fileOpts->printCmd.size()-1, 1, ""); 
  while (fileOpts->editorCmd[fileOpts->editorCmd.size()-1] == ' ') 
    fileOpts->editorCmd.replace(fileOpts->editorCmd.size()-1, 1, ""); 
}

opt_cddoc::~opt_cddoc()
{
  /****** cdDoc ****************/
  delete leView;
  delete lePrint;
  delete leLatex;
  delete leEdit;

  delete labelLatex;
  delete labelView;
  delete labelPrint;
  delete labelEdit;
  delete buttonCancel;
  delete buttonApply;
  delete buttonOK;
}


#include "opt_cddoc.moc"
















