#include "cdTree.h"

extern unsigned char cursArt;

int T_cdTree::getVerz(unsigned int index, string &SrcPath, string &DstPath)
{
  if (index >= VerzListe.size()) return(-1);
  SrcPath = VerzListe[index].SrcPath;
  DstPath = VerzListe[index].DstPath;
  return(0);
}

int T_cdTree::getVerzNum() 
{
  return(VerzListe.size());
}

int T_cdTree::Append(string SrcPath, string DstPath, bool FollowSymLink)
{
  // true, wenn es eine Datei ist:
  bool aFile = (SrcPath[SrcPath.size()-1] != '/') && (SrcPath != "dummydir");

  if (!aFile && SrcPath != "dummydir") 
    {
      // erster Teil: schauen, ob es das src-Dir im System gibt
      DIR* Verzeichnis;
      
      Verzeichnis = opendir(SrcPath.c_str());
      if (Verzeichnis == NULL) 
	{
	  SrcPath += i18n("\nThis directory does not seem to exist on your system!");
	  fehlermeldung(SrcPath.c_str());
	  return(-2);
	}
      closedir(Verzeichnis);
    }

  // zweiter Teil: wenn es in der Liste noch nicht vorhanden ist, anhngen!
  T_cdVerz tmp;

  tmp.SrcPath = SrcPath;
  tmp.DstPath = DstPath;
  for (unsigned int Cnt = 0; Cnt < VerzListe.size(); Cnt++) 
    {
      if (SrcPath == VerzListe[Cnt].SrcPath && SrcPath != "dummydir")
	{
	  string schonGetan = i18n("You have already included this file/directory\n"
				   "but I'll add it anyway...\n"
				   "The CDs size given in the status bar may now be quite wrong,\n"
				   "so dont forget to check the real one using \n"
				   "\"Single Step|Simulate image creation\"!\n\n"
				   "Where you included it before:\n");
	  schonGetan += VerzListe[Cnt].DstPath;
	  fehlermeldung(schonGetan.c_str());
	}
    }
  
  // Jetzt werden gleich Daten ber dieses Verzeichnis gesammelt:
  tmp.Inhalt = new T_Verzeichnis;

  // Wartecursor einschalten:
  QApplication::setOverrideCursor(waitCursor); 
  cursArt=1;

  if (!aFile) 
    {
      cerr << "Verz angehngt\n";
      if (tmp.Inhalt->Setzen(SrcPath, FollowSymLink) != 0) 
	{
	  delete tmp.Inhalt;
	  QApplication::restoreOverrideCursor(); 
	  // Fehlermeldung wird von ~->Setzen bernommen!
	  return(-4);
	}
    }
  else 
    {
      cerr << "Datei angehngt\n";
      if (tmp.Inhalt->SetzenD(SrcPath, DstPath, FollowSymLink) != 0) 
	{
	  delete tmp.Inhalt;
	  QApplication::restoreOverrideCursor(); 
	  SrcPath += i18n("\nThere is no such file on your system or it is\na symbolic link and you told me not to follow them!");
	  fehlermeldung(SrcPath.c_str());
	  return(-3);
	}
    }
  // und merken!
  VerzListe.push_back(tmp);  
  QApplication::restoreOverrideCursor(); 
  cerr << "angehngt: " << SrcPath << " -> " << DstPath << "\n";
  return(0);
}

int T_cdTree::Remove(unsigned int index)
{
  if (index >= VerzListe.size()) return(-1);
  cerr << "gelscht: " << VerzListe[index].SrcPath << " -> " << VerzListe[index].DstPath << "\n";
  delete VerzListe[index].Inhalt;
  VerzListe.erase(VerzListe.begin()+index);
  return(0);  
}

int T_cdTree::getCDVerzTree(QListView* ktl, bool Append)
{
  ofstream  outDat;
  string    outDatPath;

  // macht es berhaupt Sinn?
  if (VerzListe.size() == 0) 
    {
      ktl->clear();
      return(-1);
    }

  outDatPath = getPersConfigDir();
  outDatPath += "/dirs.lst";

  outDat.open(outDatPath.c_str());
  if (!outDat) return(-1);

  // Wartecursor einschalten:
  QApplication::setOverrideCursor(waitCursor); 

  // Gesamtgre ausrechnen:
  Gesamtgroesse = 0;
  for (unsigned int Cnt=0; Cnt < VerzListe.size(); Cnt++) 
    Gesamtgroesse += VerzListe[Cnt].Inhalt->GetSizeR();

  cout << "Gesamtgre gerechnet\n";
  cout.flush();
  if (!Append) 
    {
      // TreeList lschen und dann fllen!
      ktl->clear();
      cout << "TreeList gelscht\n";
      cout.flush();
    }
  

  for (unsigned int Cnt=0; Cnt < VerzListe.size(); Cnt++) 
    {
      cout << "Ausfhrung: " << VerzListe[Cnt].SrcPath << "   " 
	   << VerzListe[Cnt].DstPath;
      cout.flush();
      VerzListe[Cnt].Inhalt->fillTreeList(ktl,
					  VerzListe[Cnt].SrcPath, 
					  VerzListe[Cnt].DstPath,
					  Ausschluss,
					  outDat);
      cout << "..fertig\n";
      cout.flush();
      
    }      
  cout << "TreeList gefllt\n";
  cout.flush();

  ktl->triggerUpdate();

  //  ktl->setAutoUpdate(true);
  //  ktl->setExpandLevel(1); 
  ktl->repaint();
  QApplication::restoreOverrideCursor(); 
 
  close_ofs(outDat);

  return(0);
}

unsigned long T_cdTree::getCDSize()
{
  return(Gesamtgroesse);
}

void T_cdTree::calcSize()
{
  for (unsigned int Cnt = 0; Cnt < VerzListe.size(); Cnt++) {
    VerzListe[Cnt].Inhalt->calcSize(Ausschluss);
  }
}

void T_cdTree::Zeig(KStatusBar* statBar,
		    QListView* DatList, 
		    QListView* ktl, 
		    string pfad)
{
  unsigned long   size  = 0;
  unsigned long   sizeR = 0;
  string          tmp;
  
  DatList->clear();

  for (unsigned int Cnt = 0; Cnt < VerzListe.size(); Cnt++) {
    VerzListe[Cnt].Inhalt->zeigInhalt(&size, &sizeR, pfad, DatList, 
				      Ausschluss);
  }
  DatList->repaint();
  // die Gren anzeigen
  tmp = i18n("files");
  tmp += ":";		    
  DatList->setColumnText(0, getSizeText(tmp.c_str(), size));
  statBar->changeItem(getSizeText("", sizeR), 0);
}

int T_cdTree::erstellListe(string dateiPfad)
{
  ofstream           outDat;
  unsigned long int  linkCnt = 0;

  outDat.open(dateiPfad.c_str());

  outDat << "l()\n";
  outDat << "{\n";
  outDat << "  if ln -s \"$S\" \"$D\"\n";
  outDat << "    then\n";
  outDat << "      true\n";
  outDat << "    else\n";
  outDat << "     echo KisoCD: aborted, because there was an error when linking $S to $D\n";
  outDat << "     exit\n";
  outDat << "  fi\n";
  outDat << "}\n";
  outDat << "l_p()\n";
  outDat << "{\n";
  outDat << "  if ln -s \"$S\" \"$D\"\n";
  outDat << "    then\n";
  outDat << "      echo -n .\n";
  outDat << "    else\n";
  outDat << "     echo KisoCD: aborted, because there was an error when linking $S to $D\n";
  outDat << "     exit\n";
  outDat << "  fi\n";
  outDat << "}\n";
  outDat << "l_pn()\n";
  outDat << "{\n";
  outDat << "  if ln -s \"$S\" \"$D\"\n";
  outDat << "    then\n";
  outDat << "      echo .\n";
  outDat << "    else\n";
  outDat << "     echo KisoCD: aborted, because there was an error when linking $S to $D\n";
  outDat << "     exit\n";
  outDat << "  fi\n";
  outDat << "}\n\n";

  if (outDat) 
    for (unsigned int Cnt = 0; Cnt < VerzListe.size(); Cnt++) 
      VerzListe[Cnt].Inhalt->erstellListe(outDat, Ausschluss, linkCnt);    
  else return(-1);
  outDat << "echo \n";
  
  close_ofs(outDat);
  return(0);
}

int T_cdTree::getEx(unsigned int index, string &Muster)
{
  if (index >= Ausschluss.size()) return(-1);
  Muster = Ausschluss[index];
  return(0);
}

int T_cdTree::getExNum() 
{
  return(Ausschluss.size());
}

int T_cdTree::Exclude(string Muster)
{
  if (Muster[Muster.size()-1] == '/') {
    // erster Teil: schauen, ob es das Dir im System gibt
    DIR* Verzeichnis;
    
    Verzeichnis = opendir(Muster.c_str());
    if (Verzeichnis == NULL) {
      Muster += i18n("\nThis directory does not seem to exist on your system!");
      fehlermeldung(Muster.c_str());
      return(-2);
    }
    closedir(Verzeichnis);
  }
  Ausschluss.push_back(Muster);
  cerr << "angehngt: " << Muster << "\n";
  return(0);
}

int T_cdTree::removeEx(unsigned int index)
{
  if (index >= Ausschluss.size()) return(-1);
  cerr << "gelscht: " << Ausschluss[index] << "\n";
  Ausschluss.erase(Ausschluss.begin()+index);
  return(0);  
}

bool T_cdTree::existDestDir(string testName)
{
  cout << "Teste auf " << testName << "\n";
  for (unsigned int Cnt=0; Cnt < VerzListe.size(); Cnt++)     
    {
      if (VerzListe[Cnt].DstPath.find(testName) == 0) return(true);
    }
    
  return(false);
}

T_cdTree::~T_cdTree()
{
  for (unsigned int Cnt = 0; Cnt < VerzListe.size(); Cnt++) {
    delete VerzListe[Cnt].Inhalt;
  }
}













