#include <kapp.h>
#include "OptionsView.h"
#include <qlabel.h>
#include <qbuttongroup.h>

OptionsView::OptionsView(QWidget *parent, const char *name)
	: QWidget(parent,name)
{
	QButtonGroup	*group1 = new QButtonGroup(i18n("Archive files"),this);
	group1->setGeometry(10,10,365,130);

	ListView = new QListView(this);
	ListView->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	ListView->setLineWidth(2);
	ListView->addColumn(i18n("Pattern"));
	ListView->addColumn(i18n("Type"));
	ListView->setGeometry(20,35,120,90);
	ListView->setSorting(-1);
	ListView->setAllColumnsShowFocus(TRUE);

	QLabel	*lab1 = new QLabel(i18n("Pattern"),this);
	lab1->setGeometry(165,30,80,20);
	QLabel	*lab2 = new QLabel(i18n("Type"),this);
	lab2->setGeometry(165,80,80,20);

	Pattern = new QLineEdit(this);
	Pattern->setGeometry(165,50,80,25);
	ProtType = new QComboBox(this);
	ProtType->setGeometry(165,100,80,25);
	ProtType->insertItem("Tar");
	ProtType->insertItem("Zip");
	ProtType->insertItem("Rpm");

	QPushButton	*add = new QPushButton(i18n("Add"),this);
	add->setGeometry(270,40,80,30);
	connect(add,SIGNAL(clicked()),SLOT(addClicked()));
	QPushButton	*del = new QPushButton(i18n("Delete"),this);
	del->setGeometry(270,85,80,30);
	connect(del,SIGNAL(clicked()),SLOT(deleteClicked()));

	QButtonGroup	*group2 = new QButtonGroup(i18n("Mini images"),this);
	group2->setGeometry(10,150,365,80);
	group2->setExclusive(TRUE);

	QLabel	*lab3 = new QLabel(i18n("Saving policy :"),this);
	lab3->setGeometry(30,170,100,20);
	SavingPolicy = new QComboBox(this);
	SavingPolicy->setGeometry(130,170,200,20);
	SavingPolicy->insertItem(i18n("Never"));
	SavingPolicy->insertItem(i18n("Use existing .xvpics/"));
	SavingPolicy->insertItem(i18n("Create .xvpics/"));
	connect(SavingPolicy,SIGNAL(activated(int)),SLOT(saveChanged(int)));
	ImageSaveIfSize = new QCheckBox(i18n("if size is greater than"),this);
	ImageSaveIfSize->setGeometry(35,200,150,20);
	ImageSize = new QLineEdit(this);
	ImageSize->setGeometry(200,200,80,20);
	QLabel	*lab4 = new QLabel("Kb",this);
	lab4->setGeometry(290,200,40,25);

	resize(390,235);
	Modified = FALSE;
}

OptionsView::~OptionsView()
{}

void OptionsView::addClicked()
{
	QListViewItem	*item = new QListViewItem(ListView,Pattern->text(),ProtType->currentText());
	Modified = TRUE;
}

void OptionsView::deleteClicked()
{
	if (ListView->currentItem()) { delete ListView->currentItem(); Modified = TRUE;}
}

void OptionsView::setProtList(SubProtList *list)
{
	SubProtListIterator	it(*list);
	for (;it.current();++it) {
		int	code = it.current()->type-Protocol::Tar;
		QListViewItem	*item = new QListViewItem(ListView,it.current()->extension.pattern(),ProtType->text(code));
	}
}

void OptionsView::getProtList(SubProtList *list)
{
	list->clear();
	QListViewItem	*item = ListView->firstChild();
	int	code;
	while (item) {
		if (strcmp(item->text(1),"Tar") == 0) code = 0;
		else if (strcmp(item->text(1),"Zip") == 0) code = 1;
		else if (strcmp(item->text(1),"Rpm") == 0) code = 2;
		code += Protocol::Tar;
		list->append(new SubProtocol(code,item->text(0)));
		item = item->nextSibling();
	}
}

void OptionsView::saveChanged(int val)
{
	bool	enable = (val != 0);
	ImageSaveIfSize->setEnabled(enable);
	ImageSize->setEnabled(enable);
}