/***************************************************************************
                          keasycdview.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Feb  7 09:35:03 MET 1999
                                           
    copyright            : (C) 1999 by Marcel Borred                         
    email                : marcel.borreda@post.rwth-aachen.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <keasycdview.h>




//Globals
int bytes_data=0;
int bytes_audio=0;
int shellcount=0;
QString mkfiles="";
QString audiofileslist="";
QString mkmultiparam="";
QString imagname="";



bool shellexit=FALSE;
KEasyCDView::KEasyCDView(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
  ///////////////////////////////////////////////
  //TODO:  setup your Elements for the main view here
  // 
  // [your_main_widget] = new [Main_Widget];

//****************************tab pages
tabctl=new KTabCtl(this, "Pages");

Page=new QWidget(tabctl,"Page one");
tabctl->addTab(Page,"Data");
Page=new QWidget(tabctl,"Page two");
tabctl->addTab(Page,"Audio");
Page=new QWidget(tabctl,"Page three");
tabctl->addTab(Page,"Record");
Page=new QWidget(tabctl,"Page four");
tabctl->addTab(Page,"Setup");
Page=new QWidget(tabctl,"Page five");
tabctl->addTab(Page,"Volume");

tabctl->setGeometry(0,0,APPWIDTH,APPHEIGHT-BORDER);
//************************************************
//timers
t = new QTimer( this ); //progresstimer


//TreeListItems

//recording dialog
recdialog=new KDialog(this,"recdialog",TRUE,0);
//combobox
modegroup=new QGroupBox ("Trackmode",recdialog,"");
automode=new QCheckBox("Automode",modegroup, "");
lastsession=new QCheckBox("Get Session",modegroup, "");
okbutton=new QPushButton("OK",modegroup,"");
cancelbutton=new QPushButton("Cancel",modegroup,"");
progresstext=new QLabel("",recdialog,"",0);
trackmode=new KCombo(modegroup,"trackmode",0);
cdextra=new KCombo(modegroup,"cdextra",0);

QToolTip::add(trackmode, "Choose a Trackmode or select automode for ordinary data!");

trackmode->insertItem("Data Mode 1");
trackmode->insertItem("Data Mode 2");
trackmode->insertItem("XA Mode 1");
trackmode->insertItem("XA Mode 2");
trackmode->insertItem("CDI");

cdextra->insertItem("CD Extra");
cdextra->insertItem("Mixed Mode CD");
recdialog->setFixedSize(150,160);
modegroup->setGeometry(5,10,140,150);
automode->setGeometry(10,20,100,20);

trackmode->setGeometry(10,50,120,20);
cdextra->setGeometry(10,50,120,20);
lastsession->setGeometry(10,80,100,20);

okbutton->setGeometry(15,105,50,40);
cancelbutton->setGeometry(70,105,50,40);
recdialog->hide();

/*
QCheckBox *audio;      //  -audio          Subsequent tracks are CD-DA audio tracks
QCheckBox  *data;    //  -data           Subsequent tracks are CD-ROM data mode 1 (default)
QCheckBox  *mode2;    //  -mode2          Subsequent tracks are CD-ROM data mode 2
QCheckBox   *xa1;   //  -xa1            Subsequent tracks are CD-ROM XA mode 1
QCheckBox   *xa2;   //  -xa2            Subsequent tracks are CD-ROM XA mode 2
QCheckBox   *cdi;   //  -cdi            Subsequent tracks are CDI tracks
*/

//Pixmaps

Icon=new KIconLoader();

mdatapixmap=new QPixmap();
maudiopixmap=new QPixmap();
folder=new QPixmap();
clock=new QPixmap();
datapixmap=new QPixmap();
audiopixmap=new QPixmap();
pixreload=new QPixmap();
pix2disk=new QPixmap();
sound=new QPixmap();

*mdatapixmap=Icon->loadIcon("keasycddatatree.xpm");
*maudiopixmap=Icon->loadIcon("keasycdaudiotree.xpm");
*folder=Icon->loadMiniIcon("folder.xpm");
*datapixmap=Icon->loadMiniIcon("mini-keasycddata.xpm");
*audiopixmap=Icon->loadMiniIcon("mini-keasycdaudio.xpm");
*pixreload=Icon->loadMiniIcon("mini-keasycdturn.xpm");
*pix2disk=Icon->loadMiniIcon("mini-keasycdlower.xpm");
*clock=Icon->loadMiniIcon("clock.xpm");
*sound=Icon->loadMiniIcon("syssound.xpm");

//creat widgets in tab pages
//Record Page
recoptions=new QGroupBox("Recording Options",this,"");
dummy=new QCheckBox("Simulate Writing",this, "");
multi=new QCheckBox("Create Multisession",this, "");
debug=new QCheckBox("Debug Mode",this, "");
nofix=new QCheckBox("Do Not Fix",this, "");
load=new QCheckBox("Load (Kodak Disk Transporter)",this, "");
eject=new QCheckBox("Eject (For Phillips)",this, "");
preemp=new QCheckBox("Audio With 50/15 Preemphasis",this, "");
pad=new QCheckBox("Pad Data & Audio",this, "");
swap=new QCheckBox("Swap(little-endian/Intel)",this, "");
ignsize=new QCheckBox("Ignore Size Of Medium (Caution)",this, "");
cdrecverbosescsi=new QCheckBox("Verbose SCSI",this, "");
bootablecd=new QCheckBox("Bootable CD",this,"") ;

QToolTip::add(dummy, "Does not really write. Good for testing!");
QToolTip::add(multi, "Leaves the cd open for writing again");
QToolTip::add(debug, "Prints debug info in a terminal (Caution)!");
QToolTip::add(nofix, "CD only readable in recorder.\nSaves CD space.");
QToolTip::add(load, "Special mode for CD writers with Kodak Disk Transporter");
QToolTip::add(eject, "Ejects the CD after writing");
QToolTip::add(preemp, "Advanced audio option");
QToolTip::add(pad, "Advanced data/ audio option");
QToolTip::add(swap, "Advanced audio option");
QToolTip::add(ignsize, "Do not check if data fits on CD");
QToolTip::add(cdrecverbosescsi, "Prints info on SCSI system into a terminal (Caution)!");
QToolTip::add(bootablecd, "Makes the CD bootable.\nChoose a boot image and catalog name on the volume page");

recoptions->setGeometry(20,40,APPWIDTH/3+50,270);
dummy->setGeometry(30,60,APPWIDTH/3+10,20);
multi->setGeometry(30,80,APPWIDTH/3+10,20);
debug->setGeometry(30,100,APPWIDTH/3+10,20);
nofix->setGeometry(30,120,APPWIDTH/3+10,20);
load->setGeometry(30,140,APPWIDTH/3+10,20);
eject->setGeometry(30,160,APPWIDTH/3+10,20);
preemp->setGeometry(30,180,APPWIDTH/3+10,20);
pad->setGeometry(30,200,APPWIDTH/3+10,20);
swap->setGeometry(30,220,APPWIDTH/3+10,20);
ignsize->setGeometry(30,240,APPWIDTH/3+10,20);
cdrecverbosescsi->setGeometry(30,260,APPWIDTH/3+10,20);
bootablecd->setGeometry(30,280,APPWIDTH/3+10,20);

//packet writing group
packetoptions=new QGroupBox("Packet Writing",this,"");
packet=new QCheckBox("Packet Writing (Experimental)",this, "");
noclose=new QCheckBox("Do Not Close",this, "");
packetsize= new QLineEdit(this,"");
packetsizelabel=new QLabel("Packetsize",this,"",0);

packetoptions->setGeometry(20,320,APPWIDTH/3+50,100);
packet->setGeometry(30,340,APPWIDTH/3+10,20);
noclose->setGeometry(30,360,APPWIDTH/3+10,20);
packetsize->setGeometry(30,390,50,20);
packetsizelabel->setGeometry(90,390,100,20);


//rw group box with button blank and status blank
blankoption=new QButtonGroup("CD RW Blank",this,""); //option group:blank= (all, fast,track,unreserve,trtail,unclose,session)


blankall=new QRadioButton("All",blankoption,"");
blankfast=new QRadioButton("Fast",blankoption,"");
blanktrack=new QRadioButton("Track",blankoption,"");
blankunreserve=new QRadioButton("Unreserve",blankoption,"");
blanktrtail=new QRadioButton("Trtail",blankoption,"");
blankunclose=new QRadioButton("Unclose",blankoption,"");
blanksession=new QRadioButton("Session",blankoption,"");
blank=new QPushButton("Blank",blankoption,"");

QToolTip::add(blankall, " Blank the entire disk.\nThis may take a long time. ");
QToolTip::add(blankfast, "Minimally blank the disk.\nThis  results  in erasing the PMA,the TOC and the pregap.");
QToolTip::add(blanktrack, " Blank a track.");
QToolTip::add(blankunreserve, "Unreserve a reserved track.");
QToolTip::add(blanktrtail, "Blank the tail of a track.");
QToolTip::add(blankunclose, "Unclose last session.");
QToolTip::add(blanksession, "Blank the last session.");
blankoption->setGeometry((APPWIDTH/2)-20,40,(APPWIDTH/2-50)/2,230);

blankfast->      setGeometry(20,20,100,20);
blanktrack->     setGeometry(20,40,100,20);
blankunreserve-> setGeometry(20,60,100,20);
blanktrtail->    setGeometry(20,80,100,20);
blankunclose->   setGeometry(20,100,100,20);
blanksession->   setGeometry(20,120,100,20);
blankall->       setGeometry(20,140,100,20);
blank->          setGeometry(30,180,60,30);




buffergroup= new QGroupBox("Buffer",this,"");
buffergroup->setGeometry((APPWIDTH/2)+120,40,160,230);
showbuffer=new KProgress(0,100,0,KProgress::Vertical,this,"ShowBuffer") ;
showbuffer->setGeometry((APPWIDTH/2)+150,60,40,150);
full=new QLabel("Full",buffergroup,"",0);
empty=new QLabel("Empty",buffergroup,"",0);
bufferOK=new QLabel("OK",buffergroup,"",0);
bufferdanger=new QLabel("Danger",buffergroup,"",0);
full->setGeometry(80,20,60,20);
empty->setGeometry(80,150,60,20);
bufferdanger->setGeometry(80,110,60,20);
bufferOK->setGeometry(80,55,60,20);
cdrecshowbuffer=new QCheckBox("Show Buffer",buffergroup, "");
cdrecshowbuffer->setGeometry(20,200,100,20);
//showbuffer->setPalette(QPalette(QColor(255,0,0)));
//showbuffer->setBarColor(QColor(0,255,0));
//showbuffer->setBarPixmap(*folder);

QToolTip::add(showbuffer, "Shows how much the buffer is filled");
QToolTip::add(cdrecshowbuffer, "Dump the buffer contents into the terminal (CAUTION!).");

//record group
recgroup=new QGroupBox ("Record",this,"");
cdrecverbose=new KProgress(0,100,0,KProgress::Horizontal,this,"Progress") ;
progresslabel=new QLabel("Progress",this,"",0);
onthefly=new QCheckBox ("On The Fly",this,"");
record=new QPushButton ("Record!",this,"");
copy=new QPushButton ("Copy!",this,"");

QToolTip::add(onthefly, "Burns Data dropped into the data window directly to the CD-R.");
QToolTip::add(cdrecverbose, "Shows burning progress.");


recgroup->setGeometry((APPWIDTH/2)-20,270,300,150);
cdrecverbose->setGeometry((APPWIDTH/2),300,200,20);
progresslabel->setGeometry((APPWIDTH/2)+220,300,50,20);
onthefly->setGeometry((APPWIDTH/2),340,200,20);
record->setGeometry((APPWIDTH/2),380,70,30);
copy->setGeometry((APPWIDTH/2)+100,380,70,30);


//Setup Page
//allfiles=new QCheckBox(this, "All files");
//device group
groupdevice=new QGroupBox("Devices",this,"");
cdbcombo=new KCombo(groupdevice,"cdburner",0);
cdrcombo=new KCombo(groupdevice,"cdreader",0);
cdrspeed=new KCombo(groupdevice,"cdrspeed",0);
cdbspeed=new KCombo(groupdevice,"cdbspeed",0);

QToolTip::add(cdrcombo, "Select the CD reader you like to read from");
QToolTip::add(cdbcombo, "Select the CD writer you like to write to");


strcdbname=new QLabel("CD Writer",groupdevice,"cdburner",0);
strcdrname=new QLabel("CD Reader",groupdevice,"cdreader",0);

groupdevice->setGeometry(20,40,280,140);
strcdbname->setGeometry(10,20,APPWIDTH/4,20);
cdbcombo->setGeometry(10,40,APPWIDTH/3,20);
cdbspeed->setGeometry(APPWIDTH/3+15,40,50,20);
strcdrname->setGeometry(10,70,APPWIDTH/4,20);
cdrcombo->setGeometry(10,90,APPWIDTH/3,20);
cdrspeed->setGeometry(APPWIDTH/3+15,90,50,20);

imagegroup=new QGroupBox("Image Files",this,"");
cddata2image=new QPushButton("CDData2->Image",this,"");
data2image=new QPushButton("Data2->Image",this,"");
imgpath=new QLabel("Image Name",this,"",0);


imagepath=new QLineEdit (this,"");
bimagepath=new KButton  (this,"");
imagepath->setEnabled(FALSE);

QToolTip::add(imagepath, "Image filename and path.");

imagegroup->setGeometry(20,180,250,150);
imgpath->setGeometry(30,200,100,20);
imagepath->setGeometry(30,220,200,20);
bimagepath->setGeometry(230,220,20,20);
cddata2image->setGeometry(30,270,110,40);
data2image->setGeometry(155,270,105,40);
bimagepath->setPixmap(*folder);

cdrspeed->insertItem("1x");
cdrspeed->insertItem("2x");
cdrspeed->insertItem("4x");
cdrspeed->insertItem("6x");
cdrspeed->insertItem("8x");
cdrspeed->insertItem("10x");
cdrspeed->insertItem("12x");
cdrspeed->insertItem("24x");
cdrspeed->insertItem("36x");
cdbspeed->insertItem("1x");
cdbspeed->insertItem("2x");
cdbspeed->insertItem("4x");
//cdbspeed->insertItem("6x");
//cdbspeed->insertItem("8x");
QToolTip::add(cdrspeed, "Select the CD reader speed");
QToolTip::add(cdbspeed, "Select the CD writer speed");

//*************************************************
sysinfo=new KShellProcess("/bin/bash");
scsiInfo();

//Page _____________________Volume------------------------------------------
//CD Header
volumeid=new QLineEdit(this,""); // -V volumeid in master block
publisherid=new QLineEdit(this,"");  // -P Auhtorname in Volumeheader mail address and phone number
preparerid=new QLineEdit(this,"");  // -p preparer of CD (128 chars) mail address and phone number
appid=new QLineEdit(this,"");    // -A (max 128c) describes app on cd

QToolTip::add(volumeid, "Volumeid in master block (max 32 chars)");
QToolTip::add(publisherid, "Authorname (max 128 chars)");
QToolTip::add(preparerid, "Preparer of CD (max 128 chars)");
QToolTip::add(appid, "Describes App on CD (max 128 chars)");

volumeid->setGeometry(20,70,APPWIDTH/4,20);
publisherid->setGeometry(20,120,APPWIDTH/2,20);
preparerid->setGeometry(20,170,APPWIDTH/2,20);
appid->setGeometry(20,220,APPWIDTH/2,20);

volumeid->setMaxLength(32);
publisherid->setMaxLength(128);
preparerid->setMaxLength(128);
appid->setMaxLength(128);

strvolumeid=new QLabel("Volume ID",this,"volumeid",0);
strpublisherid=new QLabel("Author Name (e.g. mail address and phone number)",this,"publisher",0);
strpreparerid=new QLabel("Preparer of CD (e.g. mail address and phone number)",this,"preparer",0);
strappid=new QLabel("Application Description",this,"volumeid",0);

strvolumeid->setGeometry(20,50,APPWIDTH/4,20);
strpublisherid->setGeometry(20,100,APPWIDTH/2,20);
strpreparerid->setGeometry(20,150,APPWIDTH/2,20);
strappid->setGeometry(20,200,APPWIDTH/2,20);



//*************eltorito
filedialog=new KFileDialog("/");

groupeltorito=new QGroupBox("Bootable CD",this,"fsoptions");
groupeltorito->setGeometry(20,250,APPWIDTH/2,150);


eltorito=new QLineEdit(this,""); // -b  path and file  to boot image (size 1.2, 1.44 or 2.88)
bootcatalog=new QLineEdit(this,""); // -c path and file of boot catalog (will be created)
keltorito=new KButton(this,"");
kbootcatalog=new KButton(this,"");
leltorito=new QLabel("Choose Eltorito Image (1.2, 1.44 or 2.88MB",this, "elimage",0 );
lbootcatalog=new QLabel("Enter Filename For Boot Catalog",this, "bootc",0);

QToolTip::add(eltorito, "Choose a boot image.\nYou can create one with a lilo boot disk.\n(e.g. dd if=/dev/fd0 of=boot.image");
QToolTip::add(bootcatalog, "Choose a name and path for the boot catalog (will be created)");

leltorito->setGeometry(25,270,APPWIDTH/2-10,20);
eltorito->setGeometry(25,300,APPWIDTH/2-50,20);
keltorito->setGeometry(APPWIDTH/2-50+25,300,20,20);

lbootcatalog->setGeometry(25,340,APPWIDTH/2-10,20);
bootcatalog->setGeometry(25,370,APPWIDTH/2-50,20);
kbootcatalog->setGeometry(APPWIDTH/2-50+25,370,20,20);


kbootcatalog->setPixmap(*folder);
keltorito->setPixmap(*folder);
eltorito->setEnabled(FALSE);
bootcatalog->setEnabled(FALSE);

//-----------------------
//**************************fs options
groupfsoptions=new QGroupBox("Filesystem Options",this,"fsoptions");
groupfsoptions->setGeometry((APPWIDTH/2)+40,40,APPWIDTH/2-50,360);

fscombo=new KCombo(this,"fscombo",0);
fscombo->insertItem("RockRidge UNIX",0);
fscombo->insertItem("RockRidge & Win95 Joliet",1);
fscombo->insertItem("Windows NT",2);
fscombo->insertItem("MS-DOS 8+3",3);
fscombo->setGeometry((APPWIDTH/2)+50,60,APPWIDTH/3,20);

//RockRidge Extensions
susprr=new QCheckBox("RockRidge",this, ""); // -R generate SUSP and RR records to further describe files (RockRidge)
susprr2=new QCheckBox("RockRidge Intelligent",this, ""); // -r set more usefull values than -R e.g. files on cd
generatetbl=new QCheckBox("TRANS.TBL",this, ""); // -T generate TRANS.TBL files better readable on non RockRidge
generatesuspforcompressed=new QCheckBox("SUSP For Compressed",this, ""); // -z
//Joliet
joliet=new QCheckBox("Joliet Extensions",this, ""); // -J activate joliet
//Filesystem special
nodeepdirreloc=new QCheckBox("No Deep Dir RELOC",this, ""); // -D
followsymlinks=new QCheckBox("Follow Symlinks",this, ""); // -f not RockRidge
sunos414cdbugcomponets=new QCheckBox("No Split Symlink C",this, ""); // -no-split-symlink-components
sunos414cdbigfields=new QCheckBox("No Split Symlink F",this, ""); // -no-split-symlink-fields

//file conventions
allfiles=new QCheckBox("All Files",this, ""); // -a  include also ~ and # files
trailingperiod=new QCheckBox("Trailing Period",this, ""); // -d omit from files with no period caution!!
allow32cfilenames=new QCheckBox("Allow 32 Characters",this, ""); // -l allows files with 32 characters ->problems with dos
allowdot=new QCheckBox("Allow Dot Files",this, ""); // -L if not will be replaced with _ (for DOS)
omitversionnumbers=new QCheckBox("Omit Versionnumbers",this, ""); // -N caution on ISO filesystem omits version number

QToolTip::add(susprr2, "Sets more usefull values than solid RockRidge (read, write permissions etc.)");

//RockRidge Extensions  geometries
susprr->setGeometry((APPWIDTH/2)+50,100,APPWIDTH/3,12); // -R generate SUSP and RR records to further describe files (RockRidge)
susprr2->setGeometry((APPWIDTH/2)+50,120,APPWIDTH/3,12); // -r set more usefull values than -R e.g. files on cd
generatetbl->setGeometry((APPWIDTH/2)+50,140,APPWIDTH/3,12); // -T generate TRANS.TBL files better readable on non RockRidge
generatesuspforcompressed->setGeometry((APPWIDTH/2)+50,160,APPWIDTH/3,12); // -z
//Joliet
joliet->setGeometry((APPWIDTH/2)+50,180,APPWIDTH/3,12); // -J activate joliet
//Filesystem special
nodeepdirreloc->setGeometry((APPWIDTH/2)+50,200,APPWIDTH/3,12); // -D
followsymlinks->setGeometry((APPWIDTH/2)+50,220,APPWIDTH/3,12); // -f not RockRidge
sunos414cdbugcomponets->setGeometry((APPWIDTH/2)+50,240,APPWIDTH/3,12); // -no-split-symlink-components
sunos414cdbigfields->setGeometry((APPWIDTH/2)+50,260,APPWIDTH/3,12); // -no-split-symlink-fields

//file conventions
allfiles->setGeometry((APPWIDTH/2)+50,280,APPWIDTH/3,12); // -a  include also ~ and # files
trailingperiod->setGeometry((APPWIDTH/2)+50,300,APPWIDTH/3,12); // -d omit from files with no period caution!!
allow32cfilenames->setGeometry((APPWIDTH/2)+50,320,APPWIDTH/3,12); // -l allows files with 32 characters ->problems with dos
allowdot->setGeometry((APPWIDTH/2)+50,340,APPWIDTH/3,12); // -L if not will be replaced with _ (for DOS)
omitversionnumbers->setGeometry((APPWIDTH/2)+50,360,APPWIDTH/3,12); // -N caution on ISO filesystem omits version number

//app defaults
packetsize->setText("512");

if(susprr->isOn()==TRUE)
susprr->toggle();
if(susprr2->isOn()==FALSE)
susprr2->toggle();
if(generatetbl->isOn()==TRUE)
generatetbl->toggle();
if(generatesuspforcompressed->isOn()==TRUE)
generatesuspforcompressed->toggle();
if(joliet->isOn()==TRUE)
joliet->toggle();
if(nodeepdirreloc->isOn()==TRUE)
nodeepdirreloc->toggle();
if(followsymlinks->isOn()==TRUE)
followsymlinks->toggle();
if(sunos414cdbugcomponets->isOn()==TRUE)
sunos414cdbugcomponets->toggle();
if(sunos414cdbigfields->isOn()==TRUE)
sunos414cdbigfields->toggle();
if(allfiles->isOn()==FALSE)
allfiles->toggle();
if(trailingperiod->isOn()==TRUE)
trailingperiod->toggle();
if(allow32cfilenames->isOn()==FALSE)
allow32cfilenames->toggle();
if(allowdot->isOn()==FALSE)
allowdot->toggle();
if(omitversionnumbers->isOn()==TRUE)
omitversionnumbers->toggle();
//**************************************

//trees-------------------------------------------------
datatree=new KTreeList(this,"DataTree",0);
datatree->setGeometry(20,30,APPWIDTH-40,APPHEIGHT-BORDER-40);
datatree->insertItem("CD Data Contents",mdatapixmap,-1,TRUE);

QToolTip::add(datatree, "Drag data from kfm and drop into this window!");

audiotree=new KTreeList(this,"AudioTree",0);
audiotree->setGeometry(20,30,APPWIDTH-250,APPHEIGHT-BORDER-40);
audiotree->insertItem("CD Audio Contents",maudiopixmap,-1,TRUE);

QToolTip::add(audiotree, "Drop Stereo 16Bit 44.1kHz Audio Files from kfm\nyou like to add to your audio CD");

//cdda2wav interface
labeltracks=new QLabel("Audio Tracks",this, "labeltracks",0);
//playtime=new QLabel("Total time: ",this, "playtime",0);
echecklist=new ECheckList(this,"elist",0);
reload=new KButton( this, "reload" );
audio2disk=new KButton(this,"2disk");
cdparacheck=new QCheckBox("CDParanoia",this, "");


QToolTip::add(reload, "Shows Audio Tracks on CD in your CD reader.");
QToolTip::add(audio2disk, "Saves selected Tracks to disk.");
//QToolTip::add(echecklist, "Double click track to play!");
QToolTip::add(cdparacheck, "Use cdparanoia instead of cdda2wav");

//playtime->setGeometry(APPWIDTH-220,60,100,20);
labeltracks->setGeometry(APPWIDTH-200,40,100,20);
reload->setGeometry(APPWIDTH-80,40,20,20);
audio2disk->setGeometry(APPWIDTH-40,40,20,20);
echecklist->setGeometry(APPWIDTH-220,80,200,250);
cdparacheck->setGeometry(APPWIDTH-220,350,100,20);
audio2disk->setPixmap(*pix2disk);
reload->setPixmap(*pixreload);

//progress dialog
progressdialog=new KDialog (this, "Status", TRUE,  0);
imgprogress=new KProgress (0,30,0,KProgress::Vertical,progressdialog,"status");
cancelshell=new QPushButton (i18n("Cancel"), progressdialog, "");
status=new QLabel ("Please wait...", progressdialog,"", 0);

progressdialog->setFixedSize(250,140);
status->setGeometry(20,20,150,20);
imgprogress->setGeometry(20,60,200,20);
cancelshell->setGeometry(90,100,60,30);

progressdialog->hide();
//----------------------------------------------------
//drop zone
dzonedata=new KDNDDropZone(datatree,DndURL);
dzoneaudio=new KDNDDropZone(audiotree,DndURL);





//connect signals and slots___-------------------------------------------
connect(datatree,SIGNAL(selected(int)),SLOT(slotDataSelected(int)));
connect(audiotree,SIGNAL(selected(int)),SLOT(slotAudioSelected(int)));

connect(dzonedata,SIGNAL(dropAction(KDNDDropZone*)),SLOT(slotDropData(KDNDDropZone*)));
connect(dzoneaudio,SIGNAL(dropAction(KDNDDropZone*)),SLOT(slotDropAudio(KDNDDropZone*)));

connect(tabctl,SIGNAL(tabSelected(int)),SLOT(slotTabSelection(int)));

connect( t, SIGNAL(timeout()), SLOT(slottimeout()) );

connect(kbootcatalog,SIGNAL(clicked()),SLOT(slotBootCatalog()));
connect(keltorito,SIGNAL(clicked()),SLOT(slotEltorito()));
connect(bimagepath,SIGNAL(clicked()),SLOT(slotImagePath()));
connect(cddata2image,SIGNAL(clicked()),SLOT(slotCD2Image()));
connect(data2image,SIGNAL(clicked()),SLOT(slotData2Image()));
connect(record,SIGNAL(clicked()),SLOT(slotRecord()));
connect(automode,SIGNAL(toggled(bool)),SLOT(slotAutomode(bool)));

connect(okbutton,SIGNAL(clicked()),SLOT(slotOkButton()));
connect(cancelbutton,SIGNAL(clicked()),SLOT(slotCancelButton()));

connect(reload,SIGNAL(clicked()),SLOT(slotReload()));
connect(audio2disk,SIGNAL(clicked()),SLOT(slotAudio2Disk()));

connect(copy,SIGNAL(clicked()),SLOT(slotCopy()));
connect(blank,SIGNAL(clicked()),SLOT(slotBlank()));

connect(fscombo,SIGNAL(activated(int)),SLOT(slotFsCombo(int)));

connect(sysinfo,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotShell1(KProcess*,char*,int)));
connect(sysinfo,SIGNAL(receivedStderr(KProcess*,char*,int)), SLOT(slotShell2(KProcess*,char*,int)));
connect(sysinfo,SIGNAL(processExited(KProcess*)), SLOT(slotSysinfoExit(KProcess*)));
//
connect(volumeid,SIGNAL(textChanged(const char*)),SLOT(slotTextChangevid(const char*)));
connect(publisherid,SIGNAL(textChanged(const char*)),SLOT(slotTextChangepuid(const char*)));
connect(preparerid,SIGNAL(textChanged(const char*)),SLOT(slotTextChangepid(const char*)));
connect(appid,SIGNAL(textChanged(const char*)),SLOT(slotTextChangeaid(const char*)));


tabctl->show();

}

void KEasyCDView::slotSysinfoExit(KProcess*)
{
readOptions();
}
void KEasyCDView::slotCopy()
{

copy->setEnabled(FALSE);

KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");
QString cdrrom=cdbcombo->currentText();
connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
//needs check
*writeaudio << "cat ";
*writeaudio << getscdrname();
*writeaudio << " | ";
*writeaudio << "cdrecord dev=";
*writeaudio << getdevstring(cdrrom.left(cdrrom.find(")",0,FALSE)));
*writeaudio << " ";
*writeaudio << getcdrecordparams();
*writeaudio << " - ";

writeaudio->start(KProcess::NotifyOnExit,KProcess::All);

recdialog->setFixedSize(350,100);
progresstext->setGeometry(10,10,300,80);
progresstext->setText("Copying Data CD...");
progresstext->show();
modegroup->hide();
automode->hide();
lastsession->hide();
cdextra->hide();
trackmode->hide();
okbutton->hide();
cancelbutton->hide();
recdialog->show();
}

void KEasyCDView::slotBlank()
{
blank->setEnabled(FALSE);

KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");
QString cdrrom=cdbcombo->currentText();

connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBlankExit(KProcess*)));

//needs check
*writeaudio << "cdrecord dev=";
*writeaudio << getdevstring(cdrrom.left(cdrrom.find(")",0,FALSE)));
*writeaudio << " blank=";
*writeaudio << getblanktype();

writeaudio->start(KProcess::NotifyOnExit,KProcess::All);
status->setText("Blanking CD. Please wait...");
imgprogress->hide();
progressdialog->show();
}


QString KEasyCDView::getblanktype()
{
 if(blankall->isOn()==TRUE)
return "all";

 if(blankfast->isOn()==TRUE)
return "fast";

 if(blanktrack->isOn()==TRUE)
return "track";

 if(blankunreserve->isOn()==TRUE)
return "unreserve";

 if(blanktrtail->isOn()==TRUE)
return "trtail";

 if(blankunclose->isOn()==TRUE)
return "unclose";

 if(blanksession->isOn()==TRUE)
return "session";

 return "";
}


void KEasyCDView::slotBlankExit(KProcess* proc)
{
KMsgBox box;
progressdialog->hide();

box.message(this,"Info","Blanking Terminated");
blank->setEnabled(TRUE);
}
void KEasyCDView::slotTextChangevid(const char* text)
{
QString name=text;
name.replace(QRegExp(" "),"");
volumeid->setText(name);
}

void KEasyCDView::slotTextChangepuid(const char* text)
{
QString name=text;
name.replace(QRegExp(" "),"");
publisherid->setText(name);
}
void KEasyCDView::slotTextChangepid(const char* text)
{
QString name=text;
name.replace(QRegExp(" "),"");
preparerid->setText(name);
}

void KEasyCDView::slotTextChangeaid(const char* text)
{
QString name=text;
name.replace(QRegExp(" "),"");
appid->setText(name);
}



KEasyCDView::~KEasyCDView( )
{

delete progressdialog;
//delete imgprogress;
delete cancelshell;
delete status;

delete t;
delete tabctl;
delete progressbar;
delete recdialog;
delete automode;
delete lastsession;
delete okbutton;
delete cancelbutton;
/*delete progresstext;
delete trackmode;
delete cdextra;
delete modegroup;
*/
delete labeltracks;
delete reload;
delete audio2disk;
delete echecklist;

delete Icon;

delete mdatapixmap;
delete maudiopixmap;
delete folder;
delete datapixmap;
delete audiopixmap;


delete recoptions;
delete dummy;
delete multi;
delete debug;
delete nofix;
delete load;
delete eject;
delete preemp;
delete pad;
delete swap;
delete ignsize;
delete cdrecverbosescsi;
delete bootablecd;

delete packet;
delete noclose;
delete packetsize;
delete packetsizelabel;
delete packetoptions;

delete blankall;
delete blankfast;
delete blanktrack;
delete blankunreserve;
delete blanktrtail;
delete blankunclose;
delete blanksession;
delete blank;
delete blankoption;

delete showbuffer;
delete full;
delete empty;
delete bufferOK;
delete bufferdanger;
delete cdrecshowbuffer;
delete buffergroup;


delete cdrecverbose;
delete progresslabel;
delete onthefly;
delete record;
delete copy;
delete recgroup;


delete cdbcombo;
delete cdrcombo;
delete cdrspeed;
delete cdbspeed;
delete strcdbname;
delete strcdrname;

delete groupdevice;

delete cddata2image;
delete data2image;
delete imgpath;

delete imagepath;
delete bimagepath;
delete imagegroup;
delete sysinfo;

delete volumeid;
delete publisherid;
delete preparerid;
delete appid;
delete strvolumeid;
delete strpublisherid;
delete strpreparerid;
delete strappid;
delete filedialog;

delete eltorito;
delete bootcatalog;
delete keltorito;
delete kbootcatalog;
delete leltorito;
delete lbootcatalog;
delete groupeltorito;

delete fscombo;
delete susprr;
delete susprr2;
delete generatetbl;
delete generatesuspforcompressed;
delete joliet;
delete nodeepdirreloc;
delete followsymlinks;
delete sunos414cdbugcomponets;
delete sunos414cdbigfields;
delete allfiles;
delete trailingperiod;
delete allow32cfilenames;
delete allowdot;
delete omitversionnumbers;
delete datatree;
delete audiotree;
delete dzonedata;
delete dzoneaudio;
delete groupfsoptions;

}




void KEasyCDView::resizeEvent(QResizeEvent *evt)
{
    QWidget::resizeEvent(evt);

    // QRect r = this->geometry();
    // [your_main_widget]->resize(r.width(),r.height());

}

void KEasyCDView::slotEditCut()
{
}

void KEasyCDView::slotEditCopy()
{
}

void KEasyCDView::slotEditPaste()
{
}

//Which Page did the user select?

void KEasyCDView::slotTabSelection(int pagenumber)
{

switch(pagenumber)
{
case 0:
cdparacheck->hide();

labeltracks->hide();
reload->hide();
audio2disk->hide();
echecklist->hide();

groupdevice->hide();
imagegroup->hide();
imgpath->hide();
cddata2image->hide();
data2image->hide();

copy->hide();
recgroup->hide();
cdrecverbose->hide();
progresslabel->hide();
onthefly->hide();
record->hide();


buffergroup->hide();
imagepath->hide();
bimagepath->hide();


showbuffer->hide();
bootablecd->hide();
recoptions->         hide();
dummy->              hide();
multi->              hide();
debug->              hide();
nofix->              hide();
load->               hide();
eject->              hide();
preemp->             hide();
pad->                hide();
swap->               hide();
ignsize->            hide();
cdrecverbosescsi->   hide();
cdrecshowbuffer->    hide();
packetoptions->      hide();
packet->             hide();
noclose->            hide();
packetsize->         hide();
packetsizelabel->    hide();

blankoption->    hide();
blankfast->      hide();
blanktrack->     hide();
blankunreserve-> hide();
blanktrtail->    hide();
blankunclose->   hide();
blanksession->   hide();
blankall->       hide();
blank->          hide();

cdbcombo->hide();
cdrcombo->hide();
strcdbname->hide();
strcdrname->hide();
groupfsoptions->hide();
groupeltorito->hide();
eltorito->hide();
bootcatalog->hide();
keltorito->hide();
kbootcatalog->hide();
leltorito->hide();
lbootcatalog->hide();
fscombo->hide();
susprr->hide();
susprr2->hide();
generatetbl->hide();
generatesuspforcompressed->hide();
joliet->hide();
nodeepdirreloc->hide();
followsymlinks->hide();
sunos414cdbugcomponets->hide();
sunos414cdbigfields->hide();
allfiles->hide();
trailingperiod->hide();
allow32cfilenames->hide();
allowdot->hide();
omitversionnumbers->hide();


strvolumeid->hide();
strpublisherid->hide();
strpreparerid->hide();
strappid->hide();

volumeid->hide();
publisherid->hide();
preparerid->hide();
appid->hide();

datatree->show();
audiotree->hide();

break;
case 1:
cdparacheck->show();

labeltracks->show();
reload->show();
audio2disk->show();
echecklist->show();

groupdevice->hide();

imagegroup->hide();
imgpath->hide();
cddata2image->hide();
data2image->hide();

copy->hide();
recgroup->hide();
cdrecverbose->hide();
progresslabel->hide();
onthefly->hide();
record->hide();

buffergroup->hide();
imagepath->hide();
bimagepath->hide();

showbuffer->hide();
bootablecd->hide();
recoptions->         hide();
dummy->              hide();
multi->              hide();
debug->              hide();
nofix->              hide();
load->               hide();
eject->              hide();
preemp->             hide();
pad->                hide();
swap->               hide();
ignsize->            hide();
cdrecverbosescsi->   hide();
cdrecshowbuffer->    hide();
packetoptions->      hide();
packet->             hide();
noclose->            hide();
packetsize->         hide();
packetsizelabel->    hide();


blankoption->    hide();
blankfast->      hide();
blanktrack->     hide();
blankunreserve-> hide();
blanktrtail->    hide();
blankunclose->   hide();
blanksession->   hide();
blankall->       hide();
blank->          hide();


cdbcombo->hide();
cdrcombo->hide();
strcdbname->hide();
strcdrname->hide();
groupfsoptions->hide();
groupeltorito->hide();
eltorito->hide();
bootcatalog->hide();
keltorito->hide();
kbootcatalog->hide();
leltorito->hide();
lbootcatalog->hide();
fscombo->hide();
susprr->hide();
susprr2->hide();
generatetbl->hide();
generatesuspforcompressed->hide();
joliet->hide();
nodeepdirreloc->hide();
followsymlinks->hide();
sunos414cdbugcomponets->hide();
sunos414cdbigfields->hide();
allfiles->hide();
trailingperiod->hide();
allow32cfilenames->hide();
allowdot->hide();
omitversionnumbers->hide();

strvolumeid->hide();
strpublisherid->hide();
strpreparerid->hide();
strappid->hide();


volumeid->hide();
publisherid->hide();
preparerid->hide();
appid->hide();

datatree->hide();
audiotree->show();


break;
case 2:
cdparacheck->hide();

labeltracks->hide();
reload->hide();
audio2disk->hide();
echecklist->hide();

groupdevice->hide();

imagegroup->hide();
imgpath->hide();
cddata2image->hide();
data2image->hide();


copy->show();
recgroup->show();
cdrecverbose->show();
progresslabel->show();
onthefly->show();
record->show();

buffergroup->show();
imagepath->hide();
bimagepath->hide();

showbuffer->show();
bootablecd->show();
recoptions->         show();
dummy->              show();
multi->              show();
debug->              show();
nofix->              show();
load->               show();
eject->              show();
preemp->             show();
pad->                show();
swap->               show();
ignsize->            show();
cdrecverbosescsi->   show();
cdrecshowbuffer->    show();
packetoptions->      show();
packet->             show();
noclose->            show();
packetsize->         show();
packetsizelabel->    show();

blankoption->    show();
blankfast->      show();
blanktrack->     show();
blankunreserve-> show();
blanktrtail->    show();
blankunclose->   show();
blanksession->   show();
blankall->       show();
blank->          show();

cdbcombo->hide();
cdrcombo->hide();
strcdbname->hide();
strcdrname->hide();
groupfsoptions->hide();
groupeltorito->hide();
eltorito->hide();
bootcatalog->hide();
keltorito->hide();
kbootcatalog->hide();
leltorito->hide();
lbootcatalog->hide();
fscombo->hide();
susprr->hide();
susprr2->hide();
generatetbl->hide();
generatesuspforcompressed->hide();
joliet->hide();
nodeepdirreloc->hide();
followsymlinks->hide();
sunos414cdbugcomponets->hide();
sunos414cdbigfields->hide();
allfiles->hide();
trailingperiod->hide();
allow32cfilenames->hide();
allowdot->hide();
omitversionnumbers->hide();

strvolumeid->hide();
strpublisherid->hide();
strpreparerid->hide();
strappid->hide();


volumeid->hide();
publisherid->hide();
preparerid->hide();
appid->hide();

datatree->hide();
audiotree->hide();

break;
case 3:
cdparacheck->hide();

labeltracks->hide();
reload->hide();
audio2disk->hide();
echecklist->hide();

groupdevice->show();

copy->hide();
recgroup->hide();
cdrecverbose->hide();
progresslabel->hide();
onthefly->hide();
record->hide();

buffergroup->hide();

imagegroup->show();
imgpath->show();
cddata2image->show();
data2image->show();
imagepath->show();
bimagepath->show();

showbuffer->hide();
bootablecd->hide();
recoptions->         hide();
dummy->              hide();
multi->              hide();
debug->              hide();
nofix->              hide();
load->               hide();
eject->              hide();
preemp->             hide();
pad->                hide();
swap->               hide();
ignsize->            hide();
cdrecverbosescsi->   hide();
cdrecshowbuffer->    hide();
packetoptions->      hide();
packet->             hide();
noclose->            hide();
packetsize->         hide();
packetsizelabel->    hide();

blankoption->    hide();
blankfast->      hide();
blanktrack->     hide();
blankunreserve-> hide();
blanktrtail->    hide();
blankunclose->   hide();
blanksession->   hide();
blankall->       hide();
blank->          hide();

cdbcombo->show();
cdrcombo->show();
strcdbname->show();
strcdrname->show();
groupfsoptions->hide();
groupeltorito->hide();
eltorito->hide();
bootcatalog->hide();
keltorito->hide();
kbootcatalog->hide();
leltorito->hide();
lbootcatalog->hide();
fscombo->hide();
susprr->hide();
susprr2->hide();
generatetbl->hide();
generatesuspforcompressed->hide();
joliet->hide();
nodeepdirreloc->hide();
followsymlinks->hide();
sunos414cdbugcomponets->hide();
sunos414cdbigfields->hide();
allfiles->hide();
trailingperiod->hide();
allow32cfilenames->hide();
allowdot->hide();
omitversionnumbers->hide();

strvolumeid->hide();
strpublisherid->hide();
strpreparerid->hide();
strappid->hide();


volumeid->hide();
publisherid->hide();
preparerid->hide();
appid->hide();

datatree->hide();
audiotree->hide();
break;
case 4:
cdparacheck->hide();

labeltracks->hide();
reload->hide();
audio2disk->hide();
echecklist->hide();

groupdevice->hide();

imagegroup->hide();
imgpath->hide();
cddata2image->hide();
data2image->hide();

copy->hide();
recgroup->hide();
cdrecverbose->hide();
progresslabel->hide();
onthefly->hide();
record->hide();

buffergroup->hide();

imagepath->hide();
bimagepath->hide();

showbuffer->hide();
bootablecd->hide();
recoptions->         hide();
dummy->              hide();
multi->              hide();
debug->              hide();
nofix->              hide();
load->               hide();
eject->              hide();
preemp->             hide();
pad->                hide();
swap->               hide();
ignsize->            hide();
cdrecverbosescsi->   hide();
cdrecshowbuffer->    hide();
packetoptions->      hide();
packet->             hide();
noclose->            hide();
packetsize->         hide();
packetsizelabel->    hide();

blankoption->    hide();
blankfast->      hide();
blanktrack->     hide();
blankunreserve-> hide();
blanktrtail->    hide();
blankunclose->   hide();
blanksession->   hide();
blankall->       hide();
blank->          hide();


cdbcombo->hide();
cdrcombo->hide();
strcdbname->hide();
strcdrname->hide();
groupfsoptions->show();
groupeltorito->show();
eltorito->show();
bootcatalog->show();
keltorito->show();
kbootcatalog->show();
leltorito->show();
lbootcatalog->show();
fscombo->show();
susprr->show();
susprr2->show();
generatetbl->show();
generatesuspforcompressed->show();
joliet->show();
nodeepdirreloc->show();
followsymlinks->show();
sunos414cdbugcomponets->show();
sunos414cdbigfields->show();
allfiles->show();
trailingperiod->show();
allow32cfilenames->show();
allowdot->show();
omitversionnumbers->show();

volumeid->show();
publisherid->show();
preparerid->show();
appid->show();

strvolumeid->show();
strpublisherid->show();
strpreparerid->show();
strappid->show();


datatree->hide();
audiotree->hide();
break;
case 5:
labeltracks->hide();
reload->hide();
audio2disk->hide();
echecklist->hide();

strvolumeid->hide();
strpublisherid->hide();
strpreparerid->hide();
strappid->hide();


volumeid->hide();
publisherid->hide();
preparerid->hide();
appid->hide();

 datatree->hide();
audiotree->hide();
break;
default:
strvolumeid->hide();
strpublisherid->hide();
strpreparerid->hide();
strappid->hide();


volumeid->hide();
publisherid->hide();
preparerid->hide();
appid->hide();

datatree->hide();
audiotree->hide();
 break;
}



}

void KEasyCDView::slotDropData(KDNDDropZone *dropzone)
{

QString Url=dropzone->getURLList().current();
//delete <file:> from Url
Url.remove(0,5);

insertDataItem(Url);
}


void KEasyCDView::insertDataItem(QString Url)
{
QFileInfo fileinfo(Url);
if(fileinfo.isReadable()==TRUE && fileinfo.isSymLink()==FALSE)
{
//the rest makes only sense if file is readable and no symlink
QString str_data;
QString strbytes;
strbytes=strbytes.setNum(bytes_data/(1024*1024));
str_data="CD Data Contents ->MBytes: ";
str_data.append(strbytes);
datatree->changeItem(str_data,mdatapixmap,0);
KPath kpath;
kpath.push(&str_data);
//we need: all sublevel Items, If droped data is a folder
//if Item is already at path level
//FIRST CHECK URL


//look if item is folder
if((Url.find("/",Url.length()-1,TRUE)==-1))//OK its a file
{
//get the filename
QString FileName=Url.right(Url.length()-Url.findRev("/",-1));

//test if file is already there

//datatree->insertItem(Url,datapixmap,1,FALSE);
if(finddubel(kpath, FileName)!=TRUE)
{
//get file size:
bytes_data+=fileinfo.size();
datatree->addChildItem(Url,datapixmap,&kpath);
//append url to mkfiles
mkfiles.append(Url);
mkfiles.append(" ");
}
}
//recursively sublevel files and folders
else
{

mkfiles.append(Url);
mkfiles.append(" ");

QDir d;
d.cd(Url,TRUE);
getsubdirs(d, kpath,TRUE);
}
strbytes=strbytes.setNum(bytes_data/(1024*1024));
str_data="CD Data Contents ->MBytes: ";
str_data.append(strbytes);
datatree->changeItem(str_data,mdatapixmap,0);

}
}
void KEasyCDView::slotDropAudio(KDNDDropZone *drop)
{
QString Url=drop->getURLList().current();
Url.remove(0,5);
insertAudioItem(Url);
}

void KEasyCDView::insertAudioItem(QString Url)
{
QFileInfo fileinfo(Url);
if(fileinfo.isReadable()==TRUE && fileinfo.isSymLink()==FALSE)
{
//check if file is burnabel as audio

audiotree->insertItem(Url,audiopixmap,1,TRUE);
audiofileslist.append(Url);
audiofileslist.append(" ");
bytes_audio+=fileinfo.size();
QString str_data;
QString strbytes;
strbytes=strbytes.setNum(bytes_audio/(176400*60));
str_data="CD Audio Contents ->Minutes: ";
str_data.append(strbytes);
audiotree->changeItem(str_data,maudiopixmap,0);
}
}
void KEasyCDView::slotFsCombo(int index)
{
switch(index)
{
case 0:
if(susprr->isOn()==TRUE)
susprr->toggle();
if(susprr2->isOn()==FALSE)
susprr2->toggle();
if(generatetbl->isOn()==TRUE)
generatetbl->toggle();
if(generatesuspforcompressed->isOn()==TRUE)
generatesuspforcompressed->toggle();
if(joliet->isOn()==TRUE)
joliet->toggle();
if(nodeepdirreloc->isOn()==TRUE)
nodeepdirreloc->toggle();
if(followsymlinks->isOn()==TRUE)
followsymlinks->toggle();
if(sunos414cdbugcomponets->isOn()==TRUE)
sunos414cdbugcomponets->toggle();
if(sunos414cdbigfields->isOn()==TRUE)
sunos414cdbigfields->toggle();
if(allfiles->isOn()==FALSE)
allfiles->toggle();
if(trailingperiod->isOn()==TRUE)
trailingperiod->toggle();
if(allow32cfilenames->isOn()==FALSE)
allow32cfilenames->toggle();
if(allowdot->isOn()==FALSE)
allowdot->toggle();
if(omitversionnumbers->isOn()==TRUE)
omitversionnumbers->toggle();
break;
case 1:
if(susprr->isOn()==TRUE)
susprr->toggle();
if(susprr2->isOn()==FALSE)
susprr2->toggle();
if(generatetbl->isOn()==TRUE)
generatetbl->toggle();
if(generatesuspforcompressed->isOn()==TRUE)
generatesuspforcompressed->toggle();
if(joliet->isOn()==FALSE)
joliet->toggle();
if(nodeepdirreloc->isOn()==FALSE)
nodeepdirreloc->toggle();
if(followsymlinks->isOn()==TRUE)
followsymlinks->toggle();
if(sunos414cdbugcomponets->isOn()==TRUE)
sunos414cdbugcomponets->toggle();
if(sunos414cdbigfields->isOn()==TRUE)
sunos414cdbigfields->toggle();
if(allfiles->isOn()==FALSE)
allfiles->toggle();
if(trailingperiod->isOn()==TRUE)
trailingperiod->toggle();
if(allow32cfilenames->isOn()==FALSE)
allow32cfilenames->toggle();
if(allowdot->isOn()==FALSE)
allowdot->toggle();
if(omitversionnumbers->isOn()==TRUE)
omitversionnumbers->toggle();

break;
case 2:
if(susprr->isOn()==TRUE)
susprr->toggle();
if(susprr2->isOn()==TRUE)
susprr2->toggle();
if(generatetbl->isOn()==TRUE)
generatetbl->toggle();
if(generatesuspforcompressed->isOn()==TRUE)
generatesuspforcompressed->toggle();
if(joliet->isOn()==FALSE)
joliet->toggle();
if(nodeepdirreloc->isOn()==FALSE)
nodeepdirreloc->toggle();
if(followsymlinks->isOn()==TRUE)
followsymlinks->toggle();
if(sunos414cdbugcomponets->isOn()==TRUE)
sunos414cdbugcomponets->toggle();
if(sunos414cdbigfields->isOn()==TRUE)
sunos414cdbigfields->toggle();
if(allfiles->isOn()==FALSE)
allfiles->toggle();
if(trailingperiod->isOn()==TRUE)
trailingperiod->toggle();
if(allow32cfilenames->isOn()==FALSE)
allow32cfilenames->toggle();
if(allowdot->isOn()==FALSE)
allowdot->toggle();
if(omitversionnumbers->isOn()==TRUE)
omitversionnumbers->toggle();

break;
case 3:
if(susprr->isOn()==TRUE)
susprr->toggle();
if(susprr2->isOn()==TRUE)
susprr2->toggle();
if(generatetbl->isOn()==TRUE)
generatetbl->toggle();
if(generatesuspforcompressed->isOn()==TRUE)
generatesuspforcompressed->toggle();
if(joliet->isOn()==TRUE)
joliet->toggle();
if(nodeepdirreloc->isOn()==TRUE)
nodeepdirreloc->toggle();
if(followsymlinks->isOn()==TRUE)
followsymlinks->toggle();
if(sunos414cdbugcomponets->isOn()==TRUE)
sunos414cdbugcomponets->toggle();
if(sunos414cdbigfields->isOn()==TRUE)
sunos414cdbigfields->toggle();
if(allfiles->isOn()==FALSE)
allfiles->toggle();
if(trailingperiod->isOn()==TRUE)
trailingperiod->toggle();
if(allow32cfilenames->isOn()==TRUE)
allow32cfilenames->toggle();
if(allowdot->isOn()==TRUE)
allowdot->toggle();
if(omitversionnumbers->isOn()==TRUE)
omitversionnumbers->toggle();


break;
default:
break;
}


}
void KEasyCDView::slotBootCatalog()
{

bootcatalog->setText(filedialog->getSaveFileName("/","boot-catalog",this,"Boot Catalog"));
}

void KEasyCDView::slotEltorito()
{

eltorito->setText(filedialog->getOpenFileName("/","*",this,"Boot Catalog"));

}

void KEasyCDView::slotImagePath()
{

imagepath->setText(filedialog->getSaveFileName("/","*",this,"Imagepath"));

}


void KEasyCDView::slotAudioSelected(int index)
{
// if(index>0)
// audiotree->removeItem(index);
}

void KEasyCDView::slotDataSelected(int index)
{
// if(index>0)
// datatree->removeItem(index);
}


void KEasyCDView::slotPathChange(const char *path)
{

}

bool KEasyCDView::finddubel(KPath path, QString filename)
{
QString childname;
uint count=datatree->itemAt(&path)->childCount();
if(count>0)
for(uint i=0; i<count;i++)
{
childname=datatree->itemAt(&path)->childAt(i)->getText();

if(childname.right(childname.length()-childname.findRev("/",-1))==filename)
return TRUE;
}
 return FALSE;
}



void KEasyCDView::getsubdirs(QDir d,KPath path, bool rootlevel)
{
QString filename;
getsubfiles(d, path, rootlevel);
KPath path2=path;
d.setFilter(QDir::Dirs|QDir::Hidden |QDir::NoSymLinks);
const QFileInfoList *list=d.entryInfoList();
QFileInfoListIterator it(*list);
QFileInfo *fi;

++it;//omit leading .
++it;  //and ..
while((fi=it.current()))
{
if(finddubel(path,fi->fileName())!=TRUE)
{
datatree->addChildItem(fi->fileName(),folder,&path);
//only cd into it if not symlink
if(fi->isSymLink()==FALSE && fi->isReadable()==TRUE)
{
d.cd(fi->fileName(),TRUE);
filename=fi->fileName();
path2.push(&filename);
getsubdirs(d, path2, FALSE);
d.cd("..",TRUE);
path2.pop();
}
}
++it;
}

}

void KEasyCDView::getsubfiles(QDir d, KPath path,bool rootlevel)
{
QString fname;
d.setFilter(QDir::Files | QDir::Hidden);
//d.setSorting(QDir::Name | QDir::Reversed );
const QFileInfoList *list=d.entryInfoList();
QFileInfoListIterator it(*list);
QFileInfo *fi;

if(rootlevel==TRUE)
while((fi=it.current()))
{
fname=fi->absFilePath();
if(finddubel(path, fname.right(fname.length()-fname.findRev("/",-1)))!=TRUE)
 {
 datatree->addChildItem(fname,datapixmap,&path);
 bytes_data+=fi->size();
 }
++it;
}
else
while((fi=it.current()))
{
datatree->addChildItem(fi->filePath(),datapixmap,&path);
bytes_data+=fi->size();
++it;
}

}

void KEasyCDView::scsiInfo()
{

*sysinfo << "cdrecord -scanbus | grep -i cd-rom";
sysinfo->start(KProcess::NotifyOnExit,KProcess::AllOutput);

}


void KEasyCDView::writercheck()
{

for(int i=0; i<cdbcombo->count();i++)
{
shellcount=i;
KShellProcess *bcheck;
bcheck=new KShellProcess("/bin/bash");
connect(bcheck,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotShell3(KProcess*,char*,int)));
cdrom=new QString(cdbcombo->text(i));

*bcheck << "cdrecord -prcap dev=";
*bcheck << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));

bcheck->start(KProcess::NotifyOnExit,KProcess::All);
}
delete cdrom;


}

QString KEasyCDView::getdevstring(QString devname)
{
//translate: bus* 100 + target ** lun is 0
if(devname.length()>1)
{
devname.replace(1,1,",");
devname.append(",0");
}
else
{
devname.prepend("0,");
devname.append(",0");
}
return devname;
}





void KEasyCDView::slotShell1(KProcess *proc, char *buffer, int buflen)
{
//every line contains a cd-rom
cdrom=new QString(buffer);
QString name="";

for(int i=0; i<buflen;i++)
{
if(cdrom->mid(i,1)!="\n")
name.append(cdrom->mid(i,1));
else
{

name=name.stripWhiteSpace();
name.replace(QRegExp("Removable CD-ROM"),"");
name.replace(QRegExp("CD-ROM"),"");
name.replace(QRegExp("'"),"");
name.replace(QRegExp("  ")," ");
name.replace(QRegExp("   ")," ");
cdrcombo->insertItem(name);
cdbcombo->insertItem(name);
name="";

}

}
//delete cdrom;
writercheck();
}

void KEasyCDView::slotShell2(KProcess *proc, char *buffer, int buflen)
{
cdrom=new QString(buffer);
if(cdrom->contains("command not found", FALSE)>0)
{
cdrcombo->insertItem("Install CDRecord & Grep");
cdbcombo->insertItem("Install CDRecord & Grep");
}
else
{
if(cdrom->contains("permission", FALSE)>0)
{
cdrcombo->insertItem("Change Permissions to get access");
cdbcombo->insertItem("Change Permissions to get access");
}
else
{
cdrcombo->insertItem(buffer);
cdbcombo->insertItem(buffer);
}
}
//delete cdrom;

}


void KEasyCDView::slotShell3(KProcess *proc, char *buffer, int buflen)
{


QString name="";
name.append(buffer);
if(name.contains("Does not write CD-R media", FALSE)>0)
cdbcombo->removeItem(shellcount);


}
//Progress to be done
void KEasyCDView::slotCD2Image()
{
KMsgBox box;
//check if image path and image name present
//...
if(checkpathname(imagepath)==FALSE)
box.message(this,"Error","You have to enter a path and imagename!");
//start KShellProcess and call cat /dev/cdrom > iname
else
{
cddata2image->setEnabled(FALSE);
KShellProcess *catcd2image;
catcd2image=new KShellProcess("/bin/bash");
connect(catcd2image,SIGNAL(processExited(KProcess*)), SLOT(slotCatCd2ImageShell(KProcess*)));
*catcd2image << "cat ";
*catcd2image << getscdrname();
*catcd2image << " > ";
*catcd2image << imagepath->text();
catcd2image->start(KProcess::NotifyOnExit,KProcess::AllOutput);
progressdialog->show();
}

}

//Progress to be done
void KEasyCDView::slotData2Image()
{
KMsgBox box;
//check if image path and image name present
//...
if(checkpathname(imagepath)==FALSE)
box.message(this,"Error","You have to enter a path and imagename!");
//start KShellProcess and call cat /dev/cdrom > iname
else
{
data2image->setEnabled(FALSE);
KShellProcess *mkisofsimage;
mkisofsimage=new KShellProcess("/bin/bash");
connect(mkisofsimage,SIGNAL(processExited(KProcess*)), SLOT(slotMakeImageShell(KProcess*)));
*mkisofsimage << "mkisofs -o";
*mkisofsimage << imagepath->text();
*mkisofsimage << getmkisofsparams();
*mkisofsimage << getdirsfiles();
mkisofsimage->start(KProcess::NotifyOnExit,KProcess::AllOutput);
progressdialog->show();
}

}
QString  KEasyCDView::getdirsfiles()
{
//problem with owner 550

return mkfiles;
}


QString  KEasyCDView::getmkisofsparams()
{
//problem with bootable cd and multtisession ... on the fly
QString params="";

//mkisofs
//Filesystem General
//RockRidge Extensions
if(susprr->isChecked()==TRUE) // -R generate SUSP and RR records to further describe files (RockRidge)
params.append("-R ");
if(susprr->isChecked()!=TRUE && multi->isChecked()==TRUE) // -R generate SUSP and RR records to further describe files (RockRidge)
params.append("-R ");

if(susprr2->isChecked()==TRUE) // -r set more usefull values than -R e.g. files on cd
params.append("-r ");
if(generatetbl->isChecked()==TRUE) // -T generate TRANS.TBL files better readable on non RockRidge
params.append("-T ");
if(generatesuspforcompressed->isChecked()==TRUE) // -z
params.append("-z ");
//Joliet
if(joliet->isChecked()==TRUE) // -J activate joliet
params.append("-J ");
//Filesystem special
if(nodeepdirreloc->isChecked()==TRUE) // -D
params.append("-D ");
if(followsymlinks->isChecked()==TRUE) // -f not RockRidge
params.append("-f ");
if(sunos414cdbugcomponets->isChecked()==TRUE) // -no-split-symlink-components
params.append("-no-split-symlink-components ");
if(sunos414cdbigfields->isChecked()==TRUE) // -no-split-symlink-fields
params.append("-no-split-symlink-fields ");
//file conventions
if(allfiles->isChecked()==TRUE) // -a  include also ~ and # files
params.append("-a ");
if(trailingperiod->isChecked()==TRUE) // -d omit from files with no period caution!!
params.append("-d ");
if(allow32cfilenames->isChecked()==TRUE) // -l allows files with 32 characters ->problems with dos
params.append("-l ");
if(allowdot->isChecked()==TRUE) // -L if not will be replaced with _ (for DOS)
params.append("-L ");
if(omitversionnumbers->isChecked()==TRUE) // -N caution on ISO filesystem omits version number
params.append("-N ");

//output
//QCheckBox *printsize; // -print-size get filesystem size before piping to cdrecord
//QCheckBox *verbose; // -v verbose

//CD Header
QString header=volumeid->text();
if(header.length()>0)
{
params.append("-V ");
params.append(volumeid->text()); // -V volumeid in master block
}
header=publisherid->text();
if(header.length()>0)
{
params.append(" -P ");
params.append(publisherid->text()); // -P Auhtorname in Volumeheader mail address and phone number
}
header=preparerid->text();
if(header.length()>0)
{
params.append(" -p ");
params.append(preparerid->text()); // -p preparer of CD (128 chars) mail address and phone number
}
header=appid->text();
if(header.length()>0)
{
params.append(" -A ");
params.append(appid->text());    // -A (max 128c) describes app on cd
}
//bootable cd
if(bootablecd->isChecked()==TRUE)
{
params.append(" -b ");
params.append(eltorito->text()); // -b  path and file  to boot image (size 1.2, 1.44 or 2.88)
params.append(" -c ");
params.append(bootcatalog->text()); // -c path and file of boot catalog (will be created)
}
/*if(multi->isChecked()==TRUE && mkmultiparam!="")
{
params.append(" -C ");
params.append(mkmultiparam);
params.append(" -M ");
params.append(getscdbname());
}
*/
//multisession
//QLineEdit *mergeimage; // -M path to other image to merge with (for multisession)


//excluding conventions
//QLineEdit *excludeglob; // -m (in wildcard pattern which files to exclude)
//QLineEdit *excludepath; // -x exclude path
return params;
}


QString KEasyCDView::getscdbname()
{
QString scdbname="/dev/scd";
QString num="";
QString cdbname=cdbcombo->currentText();
for(int i=0; i<cdrcombo->count();i++)
if(cdbname.contains(cdrcombo->text(i))>0)
{
num=num.setNum(i);
scdbname.append(num);
break;
}
return scdbname;
}
QString KEasyCDView::getscdrname()
{
QString scdname="/dev/scd";
QString num="";
num=num.setNum(cdrcombo->currentItem());
scdname.append(num);
return scdname;
}
//+++++++++++++++++++++++++******************************************************

bool KEasyCDView::checkpathname(QLineEdit *path)
{
QString s=path->text();
if(s.right(1)=="/")
return FALSE;
if(s=="")
return FALSE;
if(s.left(1)!="/")
return FALSE;
return TRUE;
}

void KEasyCDView::slotCatCd2ImageShell(KProcess* proc)
{
progressdialog->hide();
KMsgBox box;
box.message(this,"Image","Image written");
cddata2image->setEnabled(TRUE);
}

void KEasyCDView::slotMakeImageShell(KProcess* proc)
{
progressdialog->hide();
KMsgBox box;
box.message(this,"Image","Image written");
data2image->setEnabled(TRUE);
}



void KEasyCDView::slotRecord()
{
KMsgBox box;
if(onthefly->isChecked()==TRUE && mkfiles==""  )
box.message(this,"Error","There is no Data to be written on thy fly!");
else
{
KShellProcess *cdcheck;
cdcheck=new KShellProcess("/bin/bash");
cdrom=new QString(cdbcombo->currentText());
connect(cdcheck,SIGNAL(receivedStderr(KProcess*,char*,int)), SLOT(slotCdCheckShell(KProcess*,char*,int)));
connect(cdcheck,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotCdCheckShell(KProcess*,char*,int)));

//connect(cdcheck,SIGNAL(processExited(KProcess*)), SLOT(slotShellExit(KProcess*)));
shellcount=0;
mkmultiparam="";


*cdcheck << "cdrecord -toc dev=";
*cdcheck << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
*cdcheck << ";cdrecord -msinfo dev=";
*cdcheck << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));

//shellexit=FALSE;

cdcheck->start(KProcess::NotifyOnExit,KProcess::AllOutput);
record->setEnabled(FALSE);
//recdialog
recdialog->setFixedSize(350,100);
progresstext->setGeometry(10,10,300,80);
progresstext->setText("Checking for inserted media. Please wait...");
progresstext->show();
modegroup->hide();
automode->hide();
lastsession->hide();
cdextra->hide();
trackmode->hide();
okbutton->hide();
cancelbutton->hide();
recdialog->show();
//delete cdrom;
}

}
void KEasyCDView::slotShellExit(KProcess* proc)
{
shellexit=TRUE;
}

void KEasyCDView::slotCdCheckShell(KProcess* proc, char* buffer, int buflen)
{
//fprintf(stderr, buffer);

KMsgBox box;
QString name="";
name.append(buffer);
if(name.contains("proper status", FALSE)>0 )   //reload
progresstext->setText("Drive needs to reload media to get proper status...");

if(name.contains("no disk", FALSE)>0 && shellcount==0)   //no disk inserted
{
recdialog->hide();
shellcount++;
box.message(this,"Error","You have to insert a medium to record on!");
record->setEnabled(TRUE);
}
else
if(name.contains("first: 0 last 0", FALSE)>0 && shellcount==0) //cd is blank
{
recdialog->hide();
//begin recording
shellcount++;
recording(FALSE);
}
else
if(name.contains("ATIP start of lead in", FALSE)>0 && shellcount==0) //cd is blank
{
recdialog->hide();
//begin recording
shellcount++;
recording(FALSE);
}
else
if(name.contains("Cannot read TOC header", FALSE)>0 && shellcount==0) //cd is blank
{
recdialog->hide();
//begin recording
shellcount++;
recording(FALSE);
}

//is cd multisession?
else
if(name.contains("Cannot read first writable address", FALSE)>0 && shellcount==0)
{
recdialog->hide();
box.message(this,"Error","This media seems already to be closed!\n Insert a blank cd in your CD writer.");
record->setEnabled(TRUE);
}
else    //we have a multisession cd inserted
if(name.left(1).contains(QRegExp("[0-9]"))>0 && name.contains(QRegExp("[0-9],[0-9]"))>0 && shellcount==0)
{
recdialog->hide();
shellcount++;
for(int i=0; i<buflen;i++)
{
if(name.mid(i,1)!="\n")
mkmultiparam.append(name.mid(i,1));
if(name.mid(i,1)=="\n")
break;
}
recording(TRUE);

}

else if(name.contains("Cannot read session offset", FALSE)>0 && shellcount==0)
{
recdialog->hide();
//try read it from other device
shellcount++;

if(cdrcombo->currentText()==cdbcombo->currentText() && cdrcombo->count()>1)
{
if(cdbcombo->currentItem()==0)
cdrcombo->setCurrentItem(1);
else
cdrcombo->setCurrentItem(0);
}
if(cdrcombo->currentText()!=cdbcombo->currentText() && cdrcombo->count()>1){
QString message="Cdrecord is unable to read the the session offset from this type of drive.\nWe need the session offset to get the last session.\nWe can go on recording without the offset\n(you won't be able to read any data from the last session)\nor try to read the session offset from your reader drive in your system.\nTo read the offset from the reader drive, insert your CD-R in";
message.append(cdrcombo->currentText());
message.append(" and press Yes!\nTo write without offset press No!");
int i=box.yesNoCancel(this,"Info",message);
if(i==1)
getreadermsinfo();
else if(i==2)
recording(FALSE);
else
record->setEnabled(TRUE);
}
else
{
if(box.yesNo(this,"Sorry","Cdrecord is unable to read the the session offset from this type of drive.\nWe can go on recording without getting the last session\n(you won't be able to read any data from the last session)\nor stop recording.\nPress yes to go on recording.")==1)
	{
	record->setEnabled(FALSE);
	recording(FALSE);
	}
	else
	record->setEnabled(TRUE);
}}

}
void KEasyCDView::getreadermsinfo()
{
mkmultiparam="";
KShellProcess *cdcheck;
cdcheck=new KShellProcess("/bin/bash");
cdrom=new QString(cdrcombo->currentText());
connect(cdcheck,SIGNAL(receivedStderr(KProcess*,char*,int)), SLOT(slotMsInfoReader(KProcess*,char*,int)));
*cdcheck << "cdrecord -msinfo dev=";
*cdcheck << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
cdcheck->start(KProcess::NotifyOnExit,KProcess::AllOutput);
}

void KEasyCDView::recording(bool multisession)
{
recdialog->setFixedSize(150,160);
KMsgBox box;
//check for on the fly
//if not on the fly, let the user select an image
//if user did not select image and no audio there abort else
if(onthefly->isChecked()==FALSE)
{
recdialog->hide();
box.message(this,"Info","You can select an image now. Press Cancel if you do not want to use an image.");
imagname=filedialog->getSaveFileName("/","*",this,"image");
if(imagname==NULL && audiofileslist==""){
box.message(this,"Error","You have to select an image or drop some audio at least!");
record->setEnabled(TRUE);}

else if (imagname==NULL && audiofileslist!="" && mkfiles=="" ) //we have to write audio
{
//if only audio present
//record audio

KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");
cdrom=new QString(cdbcombo->currentText());
connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
shellcount=0;
*writeaudio << "cdrecord dev=";
*writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
*writeaudio << getcdrecordparams();
*writeaudio << " -audio";
*writeaudio << audiofileslist;
writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
recdialog->setFixedSize(350,100);
progresstext->setGeometry(10,10,300,80);
progresstext->setText("Beginning Recording Audio...");
progresstext->show();
modegroup->hide();
automode->hide();
lastsession->hide();
cdextra->hide();
trackmode->hide();
okbutton->hide();
cancelbutton->hide();
recdialog->show();
}
else if(audiofileslist=="") //we have to write some data
{
        if(multisession==FALSE)
        {//if only data present
        //let user decide trackmode
        progresstext->hide();
        lastsession->hide();
        cdextra->hide();
        automode->show();
        okbutton->show();
        cancelbutton->show();
        trackmode->show();
        modegroup->show();
        recdialog->show();
        }
        else //we have multisession
        {
        progresstext->hide();
	cdextra->hide();
        okbutton->show();
        cancelbutton->show();
        automode->show();
        lastsession->show();
	trackmode->show();
        modegroup->show();
        recdialog->show();
        }
}
else //we have to write audio and data
{
if(multisession==FALSE) //we have a blank cd
{

progresstext->hide();
lastsession->hide();
trackmode->hide();
automode->hide();
cdextra->show();
okbutton->show();
cancelbutton->show();
modegroup->show();
recdialog->show();

}//let user select between cd extra and mixed mode cd and expert
else //cd is multisession
{
box.message(this,"Error","KEasyCD currently only supports writing data and audio on a blank cd!");
record->setEnabled(TRUE);

}//let user decide mode of data and if placed before or after audio and if old session schould be loaded

}

}

//********************on the fly
else{ //we have to write data or data and audio on the fly
        if(audiofileslist=="") //we have to write data
        {
        if(multisession==FALSE)
        {//if only data present
        //let user decide trackmode
	lastsession->hide();
        cdextra->hide();
        progresstext->hide();

        okbutton->show();
	cancelbutton->show();
        automode->show();
	trackmode->show();
        modegroup->show();
        recdialog->show();
        }
        else //we have multisession
        {
	
	
        progresstext->hide();
        cdextra->hide();
	
        lastsession->show();
        okbutton->show();
	cancelbutton->show();
        automode->show();
        trackmode->show();
        modegroup->show();
        recdialog->show();
        }

        }
        else //we have to write data and audio
        {
        if(multisession==FALSE) //we have a blank cd
        {

        progresstext->hide();
        lastsession->hide();
        trackmode->hide();
        automode->hide();
	
	cdextra->show();
	okbutton->show();
	cancelbutton->show();
	modegroup->show();
        recdialog->show();


        }

        //let user select between cd extra and mixed mode cd and expert
        else //cd is multisession
        {
        box.message(this,"Error","KEasyCD currently only supports writing data and audio on a blank cd!");
        record->setEnabled(TRUE);

        }//let user decide mode of data and if placed before or after audio and if old session schould be loaded

        }
}


}

void KEasyCDView::slotAutomode(bool on)
{
if(on==TRUE)
trackmode->setEnabled(FALSE);
else
trackmode->setEnabled(TRUE);

}

void KEasyCDView::slottimeout()
{
cdrecverbose->advance(1);


}
void KEasyCDView::slotOkButton()
{


//QString strblocks="";
if(cdextra->isVisible()==TRUE) //we have to record cd extra or mixed mode
{
        if(cdextra->currentItem()==0)//we have to write a CD Extra
        {

                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotCdExtraExit(KProcess*)));
                shellcount=0;
                if(multi->isChecked()!=TRUE)
                multi->toggle();
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                *writeaudio << " -audio ";
                *writeaudio << audiofileslist;
                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Beginning Recording CD Plus...");

                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                progresstext->show();
                recdialog->show();

        }
        else //we have to write a Mixed Mode CD
        {
                if(imagname=="") //we write on the fly
                {
                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
                shellcount=0;
                if(multi->isChecked()==TRUE)
                multi->toggle();
                *writeaudio << "mkisofs ";
                *writeaudio << getmkisofsparams();
                *writeaudio << mkfiles;
                *writeaudio << " | ";
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                strblocks=strblocks.setNum((bytes_data/2047)+100);
                *writeaudio << strblocks;*/
                *writeaudio << " -data - ";
                *writeaudio << " -audio ";
                *writeaudio << audiofileslist;
                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Recording Mixed Mode ...");

                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                progresstext->show();
                recdialog->show();
                }
                else //we write from image
                {
                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
                shellcount=0;
                if(multi->isChecked()==TRUE)
                multi->toggle();
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                QFile f(imagname);
                strblocks=strblocks.setNum((f.size()/2047)+100);
                *writeaudio << strblocks;*/
                *writeaudio << " -data ";
                *writeaudio << imagname;
                *writeaudio << " -audio ";
                *writeaudio << audiofileslist;
                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Recording Mixed Mode ...");
                progresstext->show();
                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                recdialog->show();
                }

        }
}
else //we have to record data
{
        if(automode->isChecked()==TRUE) //we use automode
        {
                if(imagname=="") //we write on the fly
                {
                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
                shellcount=0;
                *writeaudio << "mkisofs ";
                *writeaudio << getmkisofsparams();
                if(lastsession->isChecked()==TRUE && lastsession->isVisible()==TRUE)
                {
                *writeaudio << " -C ";
                *writeaudio << mkmultiparam;
                *writeaudio << " -M ";
                *writeaudio << getscdbname();
                }
                *writeaudio << mkfiles;
                *writeaudio << " | ";
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                strblocks=strblocks.setNum((bytes_data/2047)+100);
                *writeaudio << strblocks;*/
                *writeaudio << " -data - ";
                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Recording Data ...");
                progresstext->show();
                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                recdialog->show();
                }
                else //we write from image
                {
                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
                shellcount=0;
                if(lastsession->isChecked()==TRUE && lastsession->isVisible()==TRUE)
                {
                *writeaudio << "mkisofs ";
                *writeaudio << getmkisofsparams();
                *writeaudio << " -C ";
                *writeaudio << mkmultiparam;
                *writeaudio << " -M ";
                *writeaudio << getscdbname();
                *writeaudio << " ";
                *writeaudio << imagname;
                *writeaudio << " | ";
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                QFile f(imagname);
                strblocks=strblocks.setNum((f.size()/2047)+100);
                *writeaudio << strblocks;*/
                *writeaudio << " -data - ";
                }
                else
                {
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                QFile f(imagname);
                strblocks=strblocks.setNum((f.size()/2047)+100);
                *writeaudio << strblocks;*/
                *writeaudio << " -data ";
                *writeaudio << imagname;

                }


                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Recording Data ...");
                progresstext->show();
                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                recdialog->show();

                }
        }
        else //we use user supplied mode
        {
                if(imagname=="") //we write on the fly
                {
                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
                shellcount=0;
                *writeaudio << "mkisofs ";
                *writeaudio << getmkisofsparams();
                if(lastsession->isChecked()==TRUE && lastsession->isVisible()==TRUE)
                {
                *writeaudio << " -C ";
                *writeaudio << mkmultiparam;
                *writeaudio << " -M ";
                *writeaudio << getscdbname();
                }
                *writeaudio << mkfiles;
                *writeaudio << " | ";
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                strblocks=strblocks.setNum((bytes_data/2047)+100);
                *writeaudio << strblocks;*/
                switch(trackmode->currentItem())
                {
                case 0:
                *writeaudio << " -data ";
                break;
                case 1:
                *writeaudio << " -mode2 ";
                break;
                case 2:
                *writeaudio << " -xa1 ";

                break;
                case 3:
                *writeaudio << " -xa2 ";

                break;
                case 4:
                *writeaudio << " -cdi ";

                break;
                default:
                *writeaudio << " -data ";

                break;
                }
                *writeaudio << " - ";
                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Recording Data ...");
                progresstext->show();
                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                recdialog->show();
                }
                else //we write from image
                {
                KShellProcess *writeaudio;
                writeaudio=new KShellProcess("/bin/bash");
                cdrom=new QString(cdbcombo->currentText());
                connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
                connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
                shellcount=0;
                if(lastsession->isChecked()==TRUE && lastsession->isVisible()==TRUE)
                {
                *writeaudio << "mkisofs ";
                *writeaudio << getmkisofsparams();
                *writeaudio << " -C ";
                *writeaudio << mkmultiparam;
                *writeaudio << " -M ";
                *writeaudio << getscdbname();
                *writeaudio << " ";
                *writeaudio << imagname;
                *writeaudio << " | ";
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                QFile f(imagname);
                strblocks=strblocks.setNum((f.size()/2047)+100);
                *writeaudio << strblocks;*/
                switch(trackmode->currentItem())
                {
                case 0:
                *writeaudio << " -data ";
                break;
                case 1:
                *writeaudio << " -mode2 ";
                break;
                case 2:
                *writeaudio << " -xa1 ";

                break;
                case 3:
                *writeaudio << " -xa2 ";

                break;
                case 4:
                *writeaudio << " -cdi ";

                break;
                default:
                *writeaudio << " -data ";

                break;
                }
                *writeaudio << " - ";
                }
                else
                {
                *writeaudio << "cdrecord dev=";
                *writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
                *writeaudio << getcdrecordparams();
                /**writeaudio << " -tsize=";
                QFile f(imagname);
                strblocks=strblocks.setNum((f.size()/2047)+100);
                *writeaudio << strblocks;*/
                switch(trackmode->currentItem())
                {
                case 0:
                *writeaudio << " -data ";
                break;
                case 1:
                *writeaudio << " -mode2 ";
                break;
                case 2:
                *writeaudio << " -xa1 ";

                break;
                case 3:
                *writeaudio << " -xa2 ";

                break;
                case 4:
                *writeaudio << " -cdi ";

                break;
                default:
                *writeaudio << " -data ";

                break;
                }
                *writeaudio << imagname;

                }


                writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
                recdialog->setFixedSize(350,100);
                progresstext->setGeometry(10,10,300,80);
                progresstext->setText("Recording Data ...");
                progresstext->show();
                automode->hide();
                modegroup->hide();
                lastsession->hide();
                cdextra->hide();
                trackmode->hide();
                okbutton->hide();
                cancelbutton->hide();
                recdialog->show();
                }
        }

}
}

void KEasyCDView::slotCancelButton()
{
recdialog->hide();
record->setEnabled(TRUE);
}
QString KEasyCDView::getcdrecordparams()
{
QString params="";
params.append(" -v");
if(cdrecverbosescsi->isChecked()==TRUE)//
params.append(" -V");
if(cdrecshowbuffer->isChecked()==TRUE && cdrecverbosescsi->isChecked()==TRUE)//     -V    Increment the verbose level in respect of SCSI command
params.append("V");
else if(cdrecshowbuffer->isChecked()==TRUE)
params.append(" -VV");
if(debug->isChecked()==TRUE) // -debug (buffer underrun)
params.append(" -debug");
if(dummy->isChecked()==TRUE) // -dummy dummy write
params.append(" -dummy");
if(multi->isChecked()==TRUE) // -multi create multisession cd and   -data for sony
params.append(" -multi");
if(nofix->isChecked()==TRUE) // -nofix do not fix disk
params.append(" -nofix");
if(load->isChecked()==TRUE) // -load (for Kodak disk transporter
params.append(" -load");
if(eject->isChecked()==TRUE) // -eject (eject, for philips)
params.append(" -eject");
params.append(" -speed=");
QString speed=cdbspeed->currentText();
speed.replace(QRegExp("x"),"");
params.append(speed);
/*
//Spinbox Group
QLineEdit *tsize;      //  tsize=#         Length of valid data in next track
QLineEdit *padsize;      //  padsize=#       Amount of padding for next track
QLineEdit *pregap;      //  pregap=#        Amount of pre-gap sectors before next track
QLineEdit *defpregrap;      //  defpregap=#     Amount of pre-gap sectors for all but track #1

QCheckBox   *isosize;   //  -isosize        Use iso9660 file system size for next data track
*/
if(preemp->isChecked()==TRUE)   //  -preemp         Audio tracks are mastered with 50/15 s preemphasis
params.append(" -preemp");
if(pad->isChecked()==TRUE)   //  -pad            Pad data tracks with 15 zeroed sectors
params.append(" -pad");
if(swap->isChecked()==TRUE)    //  -swab           Audio data source is byte-swapped (little-endian/Intel)
params.append(" -swab");
if(ignsize->isChecked()==TRUE)      //  -ignsize        ignore the known size of a medium (may cause problems)
params.append(" -ignsize");
/*
QLineEdit *timeout;      // timeout=#       set the default SCSI command timeout to #. default 40 seconds
QLineEdit *driver;     //  driver=name     user supplied driver name, use with extreme care
QCheckBox *checkdrive;      //  -checkdrive     check if a driver for the drive is present
QCheckBox *printcap;      //  -prcap          print drive capabilities for MMC compliant drives
QCheckBox *inquiry;      //  -inq            do an inquiry for the drive end exit
QCheckBox *scanbus;      //  -scanbus        scan the SCSI bus end exit
QCheckBox *reset;      //  -reset          reset the SCSI bus with the cdrecorder (if possible)
QLineEdit *fifosize;      //  fs=#            Set fifo size to # (0 to disable, default is 4 MB)
//checkbox for on the fly writing
//lineedit for image path
*/
//Packet Writing;
if(packet->isChecked()==TRUE)        // -packet packet writing mode
{
params.append(" -packet");
if(noclose->isChecked()==TRUE)        // -noclose
params.append(" -noclose");
params.append(" -pktsize=");
params.append(packetsize->text());    // -pktsize=# set packetsize
}
return params;
}

void KEasyCDView::slotWriteAudioShell(KProcess* proc,char* buffer,int buflen)
{

if(cdrecshowbuffer->isChecked()==TRUE || cdrecverbosescsi->isChecked()==TRUE || debug->isChecked()==TRUE )
fprintf(stderr,buffer);

//fprintf(stderr,buffer);

QString name="";
name.append(buffer);
if(name.contains("Starting new track at sector:", FALSE)>0 && t->isActive()==FALSE)
{
int imagsize=0;
if(imagname!="")
{
QFile f(imagname);
imagsize=f.size();
}
QString speed=cdbspeed->currentText();
speed.replace(QRegExp("x"),"");
t->start(((bytes_data+bytes_audio+imagsize)*10/(speed.toInt()*150*1024)),FALSE);
}
/*if(name.contains("WARNING")>0)
{
KMsgBox box;
box.message(this,"Warning!","Data does not fit on CD. Aborting!");
proc->kill(SIGINT);

record->setEnabled(TRUE);
}
*/
//cdrecverbose->setValue(getProgress(name));
showbuffer->setValue(getFifo(name));
progresstext->setText(getText(name));
}

int KEasyCDView::getProgress(QString buffer)
{
int percent=0;
/* Do it with timer
QString written="";
QString of="";
buffer=getText(buffer);
if(buffer.contains("MB written")>0 && buffer.length()<45)
{
buffer.replace(QRegExp("Track [0-9][0-9]:"),"");
buffer.replace(QRegExp("MB written"),"");
buffer.replace(QRegExp("   "),"");
buffer.replace(QRegExp("  "),"");
buffer.replace(QRegExp(" "),"");
buffer.replace(QRegExp("\\r"),"");
written=buffer.left(buffer.find(QRegExp("of"))-1);
of=buffer.right(buffer.length()-buffer.findRev(QRegExp("of"))-2);
}
*/
return percent;
}

QString KEasyCDView::getText(QString buffer)
{
int ds=0;
if(buffer.contains("MB written")>0)
{
ds=buffer.find(QRegExp("MB"));
buffer=buffer.left(ds+10);
}
else
if(buffer.contains("Fixating")>0)
buffer="Fixating... Please wait!";
else
buffer="Writing in progress!";


return buffer;

}

int KEasyCDView::getFifo(QString buffer)
{
QString text="";
text=buffer.mid(buffer.find(QRegExp("fifo"))+4,4);
return text.toInt()-2;
}
void KEasyCDView::slotBurnExit(KProcess* proc)
{
KMsgBox box;
recdialog->hide();

t->stop();
box.message(this,"Info","Writing Terminated");
cdrecverbose->setValue(0);
record->setEnabled(TRUE);
copy->setEnabled(TRUE);
}

void KEasyCDView::slotCdExtraExit(KProcess* proc)
{
progresstext->setText("Writing Now Data Session...");
makeemptyimage();
RecordCdPlus();
}
void KEasyCDView::recordcdextra()
{
QString strblocks="";
KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");
cdrom=new QString(cdbcombo->currentText());
connect(writeaudio,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotWriteAudioShell(KProcess*,char*,int)));
connect(writeaudio,SIGNAL(processExited(KProcess*)), SLOT(slotBurnExit(KProcess*)));
shellcount=0;
if(multi->isChecked()==TRUE)
multi->toggle();

*writeaudio << "mkisofs";// -R "; is this the problem that we can not read under linux cdextra?
//*writeaudio << getmkisofsparams(); well, I'll try this version
*writeaudio << " -C ";
*writeaudio << mkmultiparam;
*writeaudio << "-M /tmp/keasycdempty.img ";
if(imagname=="") //we write on the fly
*writeaudio << mkfiles;
else //write from image
*writeaudio << imagname;
*writeaudio << " | ";
*writeaudio << "cdrecord -data dev=";
*writeaudio << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
*writeaudio << getcdrecordparams();
/**writeaudio << " -tsize=";
if(imagname=="") //we write on the fly
{
strblocks=strblocks.setNum((bytes_data/2047)+100);
*writeaudio << strblocks;
}
else //write from image
{
QFile f(imagname);
strblocks=strblocks.setNum((f.size()/2047)+100);
*writeaudio << strblocks;
}*/
*writeaudio << " -";
writeaudio->start(KProcess::NotifyOnExit,KProcess::AllOutput);
progresstext->setText("Recording Data...");

}

void KEasyCDView::makeemptyimage()
{
 KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");
*writeaudio << "mkdir /tmp/keasycdemptydir";
*writeaudio << ";mkisofs -R";
*writeaudio << getmkisofsparams();
*writeaudio << " -o /tmp/keasycdempty.img /tmp/keasycdemptydir";
writeaudio->start(KProcess::NotifyOnExit,KProcess::Stdout);
}



void KEasyCDView::RecordCdPlus()
{
mkmultiparam="";
KShellProcess *cdcheck;
cdcheck=new KShellProcess("/bin/bash");
cdrom=new QString(cdbcombo->currentText());
connect(cdcheck,SIGNAL(receivedStdout(KProcess*,char*,int)), SLOT(slotMsInfo(KProcess*,char*,int)));
*cdcheck << "cdrecord -msinfo dev=";
*cdcheck << getdevstring(cdrom->left(cdrom->find(")",0,FALSE)));
cdcheck->start(KProcess::NotifyOnExit,KProcess::AllOutput);
record->setEnabled(FALSE);
//delete cdrom;


}

void KEasyCDView::slotMsInfo(KProcess* proc,char* buffer ,int buflen)
{


QString name="";
name.append(buffer);
if(name.left(1).contains(QRegExp("[0-9]"))>0){
for(int i=0; i<buflen;i++)
{
if(name.mid(i,1)!="\n")
mkmultiparam.append(name.mid(i,1));
if(name.mid(i,1)=="\n")
break;
}
recordcdextra();}

}

void KEasyCDView::slotMsInfoReader(KProcess* proc,char* buffer ,int buflen)
{
QString name="";
name.append(buffer);
KMsgBox box;
if(name.contains("Cannot read session offset", FALSE)>0 && shellcount==0)
{

box.message(this,"Error","Cdrecord is unable to read the the session offset from your reader.\nYou won't be able to write multisession CD's with an included last session");
record->setEnabled(TRUE);
}
else
if(name.left(1).contains(QRegExp("[0-9]"))>0 && name.contains(QRegExp("[0-9],[0-9]"))){
for(int i=0; i<buflen;i++)
{
if(name.mid(i,1)!="\n")
mkmultiparam.append(name.mid(i,1));
if(name.mid(i,1)=="\n")
break;
}
box.message(this,"Success","We were able read multisession Info from your reader.\nPlease insert your CD-R in your CD writer and press then OK!");
recording(TRUE);
}

}


void KEasyCDView::slotAudio2Disk()
{
KMsgBox box;
int files=0;
QString filename="";
QString tracknumber="";
QString paraparam="";
QString cddaparam="";
files=echecklist->count();
QString path=filedialog->getOpenFileName("/","*",this,"audiofiles");
if(path.right(1)==NULL)
box.message(this,"Error","You have to specify a path and/ or filename to store the selected audio files.");
else if(files==1)
box.message(this,"Error","There are no audio files to write to disk.");
else
{
if(path.right(1)=="/")
path.append("audio_");
for(int i=1;i<files;i++)
{
tracknumber.setNum(i);
filename.append(path);
if(echecklist->isChecked(i)==TRUE)
{
filename.append(tracknumber);
filename.append(".wav");

QString cdrrom=cdrcombo->currentText();

if(cdparacheck->isChecked()==TRUE)
{
paraparam.append("cdparanoia -d ");
paraparam.append(getscdrname());
paraparam.append(" ");
paraparam.append(tracknumber);
paraparam.append(" ");
paraparam.append(filename);
paraparam.append(" ; ");

}
else
{
cddaparam.append("cdda2wav -D ");
cddaparam.append(getdevstring(cdrrom.left(cdrrom.find(")",0,FALSE))));
cddaparam.append(" -t ");
cddaparam.append(tracknumber);
cddaparam.append(filename);
cddaparam.append(" ; ");
}

}
filename="";
tracknumber="";

}
KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");

if(cdparacheck->isChecked()==TRUE)
{
connect(writeaudio,SIGNAL(receivedStderr(KProcess*,char*,int)), SLOT(slotLoadTracksPara(KProcess*,char*,int)));
connect(writeaudio,SIGNAL( processExited(KProcess*)), SLOT(slotExitLoadTracks(KProcess*)));

*writeaudio << paraparam;
}
else
{
connect(writeaudio,SIGNAL(receivedStderr(KProcess*,char*,int)), SLOT(slotLoadTracksCdda(KProcess*,char*,int)));
connect(writeaudio,SIGNAL( processExited(KProcess*)), SLOT(slotExitLoadTracks(KProcess*)));

*writeaudio << cddaparam;
}

writeaudio->start(KProcess::NotifyOnExit,KProcess::Stderr);
progressdialog->show();
}


}

void KEasyCDView::slotExitLoadTracks(KProcess *proc)
{
KMsgBox box;
progressdialog->hide();
box.message(this, "Info", "Loading Tracks to Harddisk finished!" );
}
void KEasyCDView::slotLoadTracksPara(KProcess* proc,char* buffer ,int buflen)
{
/*fprintf(stderr, buffer);
QString name="";
name.append(buffer);
if(name.contains("PROGRESS")>0 && name.contains(">")>0 )
{
int percent=name.find(QRegExp(">"))-name.find(QRegExp("PROGRESS"))-13;
imgprogress->setValue(percent);
}*/
}

void KEasyCDView::slotLoadTracksCdda(KProcess* proc,char* buffer ,int buflen)
{

}


int totaltracks=0;
void KEasyCDView::slotReload()
{
echecklist->clear();
totaltracks=0;
shellcount=0;
KShellProcess *writeaudio;
writeaudio=new KShellProcess("/bin/bash");
QString cdrrom=cdrcombo->currentText();
connect(writeaudio,SIGNAL(receivedStderr(KProcess*,char*,int)), SLOT(slotGetTracks(KProcess*,char*,int)));


*writeaudio << "cdda2wav -J -D ";
*writeaudio << getdevstring(cdrrom.left(cdrrom.find(")",0,FALSE)));

writeaudio->start(KProcess::Block,KProcess::All);



}


void KEasyCDView::slotGetTracks(KProcess* proc,char* buffer ,int buflen)
{
//fprintf(stderr,buffer);

QString name="";
QString trackstotal="";
QString Track="";
QString Tracknumber="";
QString trackname="";
QString totaltime="";
int trackstart=0, trackend=0;
name.append(buffer);
name.replace(QRegExp("\n"),"");
if(name.contains("load cdrom please")>0)
{
KMsgBox box;
box.message(this,"Error","Please insert an audio CD in your reader and press reload!");

}


if(name.contains("Album title")>0 && name.contains("total tracks:")>0 && name.contains(", (total time")>0 && totaltracks==0) //we have a cd text
{
/*
trackstart=name.find(QRegExp("total tracks:"));
trackend=name.find(QRegExp(", (total time"));
if(trackstart>=0 && trackend>=0 && trackend>=trackstart+13)
{
trackstotal=name.mid(trackstart+13, trackend-trackstart-13);
totaltracks=trackstotal.toInt();

}
if(totaltracks>0)
{
for(int i=1; i<=totaltracks;i++)
{
Tracknumber.setNum(i);
Tracknumber.append(".(");
trackname=name.mid(name.find(QRegExp(Tracknumber))+3,9);
trackname.prepend(Tracknumber);
trackname.prepend("Track ");
ECheckListItem *echeckitem;
echeckitem=new ECheckListItem(trackname,*audiopixmap,TRUE);
echecklist->insertItem(echeckitem,-1);
}

}
*/
}
else //we have no text cd
if(name.contains("total tracks:")>0 && name.contains(", (total time")>0 && totaltracks==0)
{


trackstart=name.find(QRegExp("total tracks:"));
trackend=name.find(QRegExp(", (total time"));
if(trackstart>=0 && trackend>=0 && trackend>=trackstart+13)
{
trackstotal=name.mid(trackstart+13, trackend-trackstart-13);
totaltracks=trackstotal.toInt();
totaltime=name.mid(trackend+2,21);
ECheckListItem *echeckitem;
echeckitem=new ECheckListItem(totaltime,*clock,TRUE);
echecklist->insertItem(echeckitem,-1);
echecklist->setEnabled(0,FALSE);
}
}
if(totaltracks>0 && echecklist->count()==1)
{
int j=0;
for(int i=1; i<=totaltracks;i++)
{
if(i>9)
j=1;
Tracknumber.setNum(i);
Tracknumber.append(".(");
trackname=name.mid(name.find(QRegExp(Tracknumber))+3+j,9);
trackname.prepend(Tracknumber);
trackname.prepend("Track ");
if(trackname.contains(":")>0)
{
ECheckListItem *echeckitem;
echeckitem=new ECheckListItem(trackname,*sound,TRUE);
echecklist->insertItem(echeckitem,-1);
}
}

}

}

void KEasyCDView::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();



  config->setGroup("RECOPTIONS");
dummy->setChecked(config->readBoolEntry("SIMULATE", true));
cdrecverbosescsi->setChecked(config->readBoolEntry("VERBSCSI", false));
cdrecshowbuffer->setChecked(config->readBoolEntry("SHOWBUFF", false));
debug->setChecked(config->readBoolEntry("DEBUG", false));
multi->setChecked(config->readBoolEntry("MULTI", false));
nofix->setChecked(config->readBoolEntry("NOFIX", false));
load->setChecked(config->readBoolEntry("LOAD", false));
eject->setChecked(config->readBoolEntry("EJECT", false));
preemp->setChecked(config->readBoolEntry("PREEMP", false));
pad->setChecked(config->readBoolEntry("PAD", false));
swap->setChecked(config->readBoolEntry("SWAP", false));
ignsize->setChecked(config->readBoolEntry("IGNSIZE", false));
noclose->setChecked(config->readBoolEntry("NOCLOSE", false));
bootablecd->setChecked(config->readBoolEntry("BOOTABLECD", false));
onthefly->setChecked(config->readBoolEntry("ONTHEFLY", false));
cdparacheck->setChecked(config->readBoolEntry("PARACHECK", false));


config->setGroup("FILESYSTEM");
susprr->setChecked(config->readBoolEntry("SUSPRR", false));
susprr2->setChecked(config->readBoolEntry("SUSPRR2", false));
generatetbl->setChecked(config->readBoolEntry("GENERATETBL", false));
generatesuspforcompressed->setChecked(config->readBoolEntry("GENERATESUSPC", false));
joliet->setChecked(config->readBoolEntry("JOLIET", false));
nodeepdirreloc->setChecked(config->readBoolEntry("NODEEPDIR", false));
followsymlinks->setChecked(config->readBoolEntry("FOLLOWSYMLINKS", false));
sunos414cdbugcomponets->setChecked(config->readBoolEntry("SUNOSBUG", false));
sunos414cdbigfields->setChecked(config->readBoolEntry("SUNOSBIG", false));
allfiles->setChecked(config->readBoolEntry("ALLFILES", false));
trailingperiod->setChecked(config->readBoolEntry("TRAILING", false));
allow32cfilenames->setChecked(config->readBoolEntry("ALLOW32", false));
allowdot->setChecked(config->readBoolEntry("ALLOWDOT", false));
omitversionnumbers->setChecked(config->readBoolEntry("OMITVER", false));




//RADIO

config->setGroup("BLANK");

blankall->setChecked(config->readBoolEntry("BLANKALL", false));
blankfast->setChecked(config->readBoolEntry("BLANKFAST", false));
blanktrack->setChecked(config->readBoolEntry("BLANKTRACK", false));
blankunreserve->setChecked(config->readBoolEntry("BLANKUNRESERVE", false));
blanktrtail->setChecked(config->readBoolEntry("BLANKTRTAIL", false));
blankunclose->setChecked(config->readBoolEntry("BLANKUNCLOSE", false));
blanksession->setChecked(config->readBoolEntry("BLANKSESSION", false));

//LINEEDIT
config->setGroup("STRINGS");
volumeid->setText(config->readEntry("VID", ""));
publisherid->setText(config->readEntry("PUID", ""));
preparerid->setText(config->readEntry("PID", ""));
appid->setText(config->readEntry("APPID", ""));
imagepath->setText(config->readEntry("IMGPATH", ""));
packetsize->setText(config->readEntry("PACKSIZE", ""));
eltorito->setText(config->readEntry("ELTORITO", ""));
bootcatalog->setText(config->readEntry("BOOTCATALOG", ""));

//COMBOS
config->setGroup("COMBOS");
fscombo->setCurrentItem(config->readNumEntry("FSCOMBO" ));
cdbcombo->setCurrentItem(config->readNumEntry("CDBCOMBO" ));
cdrcombo->setCurrentItem(config->readNumEntry("CDRCOMBO" ));
cdrspeed->setCurrentItem(config->readNumEntry("CDRSPEED" ));
cdbspeed->setCurrentItem(config->readNumEntry("CDBSPEED" ));




}























