#ifndef _kcdwritetlw_h
#define _kcdwritetlw_h

/********************************************************************************
 *
 * ktlw.h - This is the header file for the TopLevelWidget used by kcdroast.  
 * It makes use of one header-file per tab-dialog on the right side of the main
 * window.
 *
 * $Id: ktlw.h,v 1.3 1998/08/05 16:36:04 core Exp $
 *
 */



#include <qstring.h>
#include <qtabdlg.h>
#include <qgrpbox.h>
#include <qstring.h>

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <kapp.h>
#include <drag.h>
#include <kconfig.h>
#include <ksimpleconfig.h>
#include <ktopwidget.h>
#include <kconfig.h>
#include <ktoolbar.h>
#include <ktracklst.h>
#include <kprogress.h>

#include "kraudiocd.h"
#include "kwritecdr.h"
#include "kmasterdatacd.h"
#include "ktracklst.h"
#include "ocdrom.h"

/**
 *
 *
 */
class KTlw : public KTopLevelWidget
{
  Q_OBJECT

 public:
  KTlw( const char *name = 0L );
  virtual ~KTlw();

  virtual void resizeEvent ( QResizeEvent *aResizeEvent );
  virtual void show();

  virtual void timerEvent( QTimerEvent *tevent );
    
  void setupUI();
  void setupMenuBar();
  void showStartupInfo();

  void updateUsage();
  void addQueueTrack( int nr );
  
  bool quitOk();

 public slots:
  virtual void closeEvent( QCloseEvent *e );

  void resizeModes();
  void configure();
  void open();
  void save();
  void saveAs();

  void deleteTrack();
  void renameTrack();
  void deleteAllTracks();

  void saveBuffer();
  void loadBuffer();
  
  void updateDiskUsage(int add);
  void setMode(int mode);
  void buffDropAction( KDNDDropZone *zone );

  void addTrack( CdTrackInfo *track, QString title, QString filename );
  void setFilename( CdTrackInfo *track, QString filename );
  void updateStatus( QString text, int percent );
  bool trackUsed( int i );
  void quit();

 signals:
  void deleteTrack( CdTrackInfo *track );

 protected:
  KConfig *config;
  KSimpleConfig *buffConfig;
  KStatusBar *statusBar;
  KProgress *statusProgress;
  KTrackListBox *bufList;          /* left window  */
  QTabBar *tabBar;                 /* right window */
  KProgress *diskUsageProgress;
  QWidget *spacer;
  KWriteCdr *writeCdr;
  KReadAudioCd *readAudioCd;
  KMasterDataCd *masterDataCd;

  KDNDDropZone *buffDropZone;
};


#endif
