/***************************************************************************
                          quanta.h  -  description
                             -------------------
    begin                :   18 23:09:05 EET 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QUANTA_H
#define QUANTA_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>


// forward declaration of the Quanta classes
class QuantaDoc;
class QuantaView;
class KTabBar;
class QHBoxLayout;
class KNewPanner;
class KHTMLView;
class KProcess;
class KWriteView;
class TreeView;
class QListViewItem;
class QWidgetStack;
class MessageOutput;

/**
  * The base class for Quanta application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of QuantaView creates your center view, which is connected
  * to the window's Doc object.
  * QuantaApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */

enum FilterTypes {HTML, TEXT, IMAGE, BACKUP};

const char *const HTML_MASK="*.*htm* *.php* *.asp *.cfm *.css *.jss *.js";
const char *const TEXT_MASK="*.txt";
const char *const IMAGE_MASK="*.gif *.jpg *.png *.jpeg *.GIF *.JPG *.PNG *.JPEG *.bmp";
const char *const BACKUP_MASK="*~ ~* *.bak";
class DocBrowser;

class QuantaApp : public KTMainWindow
{
  Q_OBJECT

  friend class QuantaView;

  public:
    /** construtor of QuantaApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    QuantaApp();
    ~QuantaApp();
    /** enables menuentries/toolbar items
     */
    void enableCommand(int id_);
    /** disables menuentries/toolbar items
     */
    void disableCommand(int id_);
    /** chek menuentries/toolbar items
     */
    void checkCommand(int id_, bool stat);
    /** add a opened file to the recent file list and update recent_file_menu
     */
    void addRecentFile(const QString &file);
    /** opens a file specified by commandline option
     */
    void openDocumentFile(const char *_cmdl);
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */	
    QuantaDoc *getDocument() const; 	
    /** add url to list for back/forward navigation */
    void addRecentURL(const QString &url);
    /** add url to list for back/forward navigation in doc browser*/
    void addRecentDocURL(const QString &url);
    /** load document from url */
    void loadUrl(const char *_url,bool saveRecent=true);
    /** Load image ( gif / jpeg ) and generate
    <img> tag for it */
  void loadImage( const char* fname);
  /**  */
  void openInDocBrowser( QString name, bool addRecent=true );

  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
     * @see KAccel
     */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
     * @see KApplication#getHelpMenu
     */
    void initMenuBar();
    /** this creates the toolbars.
     */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);

  public slots:
    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
    void statusCallback(int id_);
    /** open a new application window by creating a new instance of QuantaApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(int id_);
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);
    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);
    /** Repaint preview */
    void slotViewRepaint();
    /** slot for toggle preview */
    void slotViewPreview();
    /** Selection base directry for HTML files */
    void slotFileDirSelect();
    /** Load document from Url when You select link in preview window */
    void slotLoadUrl (KHTMLView *_view, const char *_url, int _button, const char *_target );
    /** connected to KHtmlView onURL signal */
    /** forwadr navigation */
    void slotViewForward();
    /** back navigation */
    void slotViewBack();
    void slotOnURL ( KHTMLView *_view, const char *_url );
   /** change undo/redo status */
    void slotNewUndo();
    /** for check tree on/off */
    void slotViewTree();
    /** handle events from treeview
    connected to double click */
    void slotSelectFile(QListViewItem *item);
    /**  */
    void slotGetLintOutput(KProcess *proc, char *buffer, int buflen)   ;
    /** run Weblint for syntax checking */
    void slotLint();
    /** view messages window on/off */
    void slotViewMes();
    /** connected to  signal  click from MessageOutput */
    void slotClickLint();
    /**  */
    void slotEditUndo();
    void slotEditRedo();
    void slotEditSearch();
    void slotEditSearchAgain();
    void slotEditReplace();
    /** save all files */
    void slotFileSaveAll();
    /** slot for new modify flag */
    void slotNewStatus();
    /**  */
    void slotClipboardStatus(KWriteView *, bool);
    /** new mark staus */
    void slotMarkStatus(KWriteView *, bool);
  /** minimize preview window */
  void slotViewMin();
  /** maximize preview window */
  void slotViewMax();
  /** select doc/tree etc */
  void slotDocSelected(int id);
  /** init documentation main page */
  void initDocumentation();
  /** slot for select documentation file */
  void slotSelectDoc(QListViewItem *);
  /** slot for load html doc file on click */
  void slotLoadDocUrl( KHTMLView*, const char*, int, const char *);
  /** enable/disabe copy menu */
  void slotClipboardStatus( KHTMLView *_view, bool _selected );

  private:
    /** contains the recently used filenames */
    QStrList recentFiles;
    QStrList recentURLs;
    QStrList recentDocURLs;
    QStrList *homeTopDirs, *rootTopDirs;

    int posURL;
    int posDocURL;

    /** the configuration object of the application */
    KConfig *config;
    /** the key accelerator container */
    KAccel *keyAccel;
    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** the recent file menu containing the last five opened files */
    QPopupMenu *recentFilesMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** options_menu contains all items of the menubar entry "Options" */
    QPopupMenu *optionsMenu;
    /** help_menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    QuantaView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    QuantaDoc *doc;
public:
		/** Own panner */
    KNewPanner *pann;
    /** Own panner vertical */
    KNewPanner *pannV;
  	/** position of separator  write|preview */
  	int previewSepPos;
  	/** position of separator  tree|write */
  	int treewriteSepPos;
  	/** HTML class for preview */
    KHTMLView *html;
    /** HTML class for documentation browser */
    DocBrowser *docBrowser;
    /** TreeView class */
    TreeView *tree;
		/** html filter*/
		QString htmlFilter;
		/** html filter*/
		QString textFilter;
		/** html filter*/
		QString imageFilter;
		/** html filter*/
		QString backupFilter;
    /** stack of widgets :
    html preview and
    weblint output */
    QWidgetStack * widStack;
    /** stack of widgets :
    write and docmentation browser */
    QWidgetStack * stackDocWrite;
    /** documentation enable/disable */
    bool docFlag;
    /** widget for showing of
    weblint output */
    MessageOutput * mesOutput;
    /**  */
    KProcess *proc;

protected: // Protected attributes

};
 
#endif // QUANTA_H
