/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include "infman.h"

void initInF( struct inFile *inf )
{
int i, ii, iii;


	for( i = 0; i < MAX_ENTRS; i++ )
	{
		for( ii = 0; ii < EXPR_LEN; ii++ )
		{
			inf->props[i][0][ii] = 0L;
			inf->props[i][1][ii] = 0L;

			inf->vars[i][0][ii] = 0L;
			inf->vars[i][1][ii] = 0L;

			inf->consts[i][0][ii] = 0L;
			inf->consts[i][1][ii] = 0L;

			inf->funcs[i][ii] = 0L;

			inf->sobjs[i].name[ii] = 0L;
			inf->sobjs[i].type[ii] = 0L;

			for( iii = 0; iii < MAX_ENTRS; iii++ )
			{
				inf->sobjs[i].sprops[iii][0][ii] = 0L;
				inf->sobjs[i].sprops[iii][1][ii] = 0L;
			}

		}

		inf->funcarg[i] = -1;

	} //for

	for( i = 0; i < EXPR_LEN; i++ )
		inf->name[i] = 0L;

}


void setInFName( struct inFile *inf, char *newName )
{
int i;

	for( i = 0; newName[i] != 0L; i++ )
	{
		if( i >= EXPR_LEN )
		{
			printf( "Data check error.\n" );
			abort();
		}

		inf->name[i] = newName[i];
	}

	inf->name[i] = 0L;
}


void setInFProp( struct inFile *inf, char *nn, char *nv )
{
int i;

	for( i = 0; inf->props[i][0][0] != 0L; i++ )
		if( i == MAX_ENTRS-1 )
		{
			printf( "Data check error.\n" );
			abort();
		}

	if ( strlen(nn) >= EXPR_LEN || strlen(nv) >= EXPR_LEN )
	{
		printf( "Expression too long.\n" );
		abort();
	}

	strcat( inf->props[i][0], nn );
	strcat( inf->props[i][1], nv );
}


void setInFVar( struct inFile *inf, char *nn, char *nv )
{
int i;

	for( i = 0; inf->vars[i][0][0] != 0L; i++ )
		if( i == MAX_ENTRS-1 )
		{
			printf( "Data check error.\n" );
			abort();
		}

	if ( strlen(nn) >= EXPR_LEN || strlen(nv) >= EXPR_LEN )
	{
		printf( "Expression too long.\n" );
		abort();
	}


	strcat( inf->vars[i][0], nn );
	strcat( inf->vars[i][1], nv );
}


void setInFConst( struct inFile *inf, char *nn, char *nv )
{
int i;

	for( i = 0; inf->consts[i][0][0] != 0L; i++ )
		if( i == MAX_ENTRS-1 )
		{
			printf( "Data check error.\n" );
			abort();
		}

	if ( strlen(nn) >= EXPR_LEN || strlen(nv) >= EXPR_LEN )
	{
		printf( "Expression too long.\n" );
		abort();
	}


	strcat( inf->consts[i][0], nn );
	strcat( inf->consts[i][1], nv );
}


void setInFFunc( struct inFile *inf, char *nn, int args )
{
int i;

	for( i = 0; inf->funcs[i][0] != 0L; i++ )
		if( i == MAX_ENTRS-1 )
		{
			printf( "Data check error.\n" );
			abort();
		}

	if ( strlen(nn) >= EXPR_LEN )
	{
		printf( "Expression too long.\n" );
		abort();
	}


	strcat( inf->funcs[i], nn );
	inf->funcarg[i] = args;
}


void setInFSub( struct inFile *inf, struct subObjs *sob )
{
int i, ii, iii;

	for( i = 0; inf->sobjs[i].name[0] != 0L; i++ )
		if( i == MAX_ENTRS-1 )
		{
			printf( "Data check error.\n" );
			abort();
		}


	for( ii = 0; ii < MAX_ENTRS; ii++ )
	{
		for( iii = 0; iii < EXPR_LEN; iii++ )
		{
			inf->sobjs[i].sprops[ii][0][iii] = sob->sprops[ii][0][iii];
			inf->sobjs[i].sprops[ii][1][iii] = sob->sprops[ii][1][iii];
		}

		inf->sobjs[i].name[ii] = sob->name[ii];
		inf->sobjs[i].type[ii] = sob->type[ii];
	}

}


void getInFName( struct inFile *inf, char *name )
{
int i;

	for( i = 0; inf->name[i] != 0L; i++ )
		name[i] = inf->name[i];

	name[i] = 0L;
}


void getInPropN( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->props[ix][0][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->props[ix][0][i];

	}

	ret[i] = 0L;
}


void getInPropV( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->props[ix][1][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->props[ix][1][i];

	}


	ret[i] = 0L;
}


void getInVarN( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->vars[ix][0][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->vars[ix][0][i];

	}

	ret[i] = 0L;
}


void getInVarV( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->vars[ix][1][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->vars[ix][1][i];

	}

	ret[i] = 0L;
}


void getInConstN( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->consts[ix][0][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->consts[ix][0][i];

	}

	ret[i] = 0L;
}


void getInConstV( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->consts[ix][1][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->consts[ix][1][i];

	}

	ret[i] = 0L;
}


void getInFuncN( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->funcs[ix][i] != 0; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->funcs[ix][i];

	}

	ret[i] = 0L;
}


int getInFuncA( struct inFile *inf, int ix )
{
int ret = 0;

	if ( ix >= MAX_ENTRS )
		ret = -1;

	ret = inf->funcarg[ix];

	return ret;
}


void getInSubN( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->sobjs[ix].name[i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->sobjs[ix].name[i];

	}

	ret[i] = 0L;
}


void getInSubT( struct inFile *inf, int ix, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->sobjs[ix].type[i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->sobjs[ix].type[i];

	}

	ret[i] = 0L;
}


void getInSubPropN( struct inFile *inf, int ix, int indx, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS || indx >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->sobjs[ix].sprops[indx][0][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->sobjs[ix].sprops[indx][0][i];

	}

	ret[i] = 0L;
}


void getInSubPropV( struct inFile *inf, int ix, int indx, char *ret )
{
int i;

	if ( ix >= MAX_ENTRS || indx >= MAX_ENTRS )
	{
		ret[0] = 0L;
		return;
	}

	for( i = 0; inf->sobjs[ix].sprops[indx][1][i] != 0L; i++ )
	{
		if ( i == EXPR_LEN )
		{
			printf( "Invalid expression in file data.\n" );
			abort();
		}

		ret[i] = inf->sobjs[ix].sprops[indx][1][i];

	}

	ret[i] = 0L;
}


void debug( struct inFile *inf )
{
int i, ii;
char oc[EXPR_LEN] = "x", oc2[EXPR_LEN] = "x";

	getInFName( inf, oc );
	printf ( "\n\nFile widget called %s.\n\n", oc );

	printf ( "Props:\n" );
	oc[0] = 'x';
	for ( i = 0; oc[0] != 0L; i++ )
	{
		getInPropN( inf, i, oc );

		if ( oc[0] != 0L ) printf( "%s = ", oc );

		getInPropV( inf, i, oc );

		if ( oc[0] != 0L ) printf( "%s\n", oc );

	}

	oc[0] = 'x';
	printf ( "\nVars:\n" );
	for ( i = 0; oc[0] != 0L; i++ )
	{
		getInVarN( inf, i, oc );

		if ( oc[0] != 0L ) printf( "%s = ", oc );

		getInVarV( inf, i, oc );

		if ( oc[0] != 0L ) printf( "%s\n", oc );

	}

	oc[0] = 'x';
	printf ( "\nConst:\n" );
	for ( i = 0; oc[0] != 0L; i++ )
	{
		getInConstN( inf, i, oc );

		if ( oc[0] != 0L ) printf( "%s = ", oc );

		getInConstV( inf, i, oc );

		if ( oc[0] != 0L ) printf( "%s\n", oc );

	}

	oc[0] = 'x';
	printf ( "\nFuncs:\n" );
	for ( i = 0; oc[0] != 0L; i++ )
	{
		getInFuncN( inf, i, oc );

		if ( oc[0] != 0L )
		{
			printf( "%s( ", oc );
			printf( "%d )\n", getInFuncA( inf, i ) );
		}

	}
	
	oc2[0] = 'x';
	for( ii = 0; oc2[0] != 0L; ii++ )
	{
		getInSubN( inf, ii, oc2 );
		if( oc2[0] == 0L ) break;

		printf( "\n\nName: %s ", oc2 );

		getInSubT( inf, ii, oc2 );

		printf( "( %s )\n", oc2 );

		printf ( "\nSub props:\n" );

		oc[0] = 'x';
		for ( i = 0; oc[0] != 0L; i++ )
		{
			getInSubPropN( inf, ii, i, oc );

			if ( oc[0] != 0L ) printf( "%s = ", oc );

			getInSubPropV( inf, ii, i, oc );

			if ( oc[0] != 0L ) printf( "%s\n", oc );

		}
	}


}

