/**************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/
#include <vkvar.moc>
#include <vkvar.h>

v::v()
{
	constructBase();
}


v::v(int nv)
{
	constructBase();
	s(nv);
}


v::v(long nv)
{
	constructBase();
	s(nv);
}


v::v(double nv)
{
	constructBase();
	s(nv);
}


v::v(bool nv)
{
	constructBase();
	s(nv);
}


v::v(QString nv)
{
	constructBase();
	s(nv);
}


v::v( const char *nv)
{
	constructBase();
	s(nv);
}

void v::constructBase()
{

	me = "";
	myFlag = stringFlag; //"" is a String

	isConst = false;
	fileBit = false;
}

void v::updateFlag()
{
bool check = true;

int iCheck;
long lCheck;
double fCheck;

	myFlag = stringFlag; //String is allways possible

	//overwrite flag in order of priority:

	fCheck = me.toDouble(&check);
	if ( check == TRUE ) myFlag = floatFlag;

	lCheck = me.toLong(&check);
	if ( check == TRUE ) myFlag = longFlag;

	iCheck = me.toInt(&check);
	if ( check == TRUE ) myFlag = intFlag;

	debug( "(VK variable flag set to %d)", myFlag );

}


/*v& v::operator= ( v &inV )
{
	me = inV.str();
	updateFlag();

	return( *this );
}

v& v::operator= ( const char *inChar )
{
	me = inChar;
	updateFlag();

	return( *this );
}*/


int v::i()
{
int ii;

	if ( myFlag < intFlag )
		varErr = new vkErr( QString ("Use of a non-integer ")
			+("variable as Integer."), vkErr::critical );

	ii = me.toInt();		
	return(ii);
}

long v::l()
{
long ll;

	if ( myFlag < longFlag )
		varErr = new vkErr( QString ("Use of a non-long ")
			+("variable as Long."), vkErr::critical );

	ll = me.toLong();
	return(ll);
}

double v::f()
{
double ff;

	if ( myFlag < floatFlag )
		varErr = new vkErr( QString ("Use of a non-float ")
			+("variable as Float."), vkErr::critical );

	ff = me.toDouble();
	return(ff);
}

bool v::b() // intFlag must be set; 0 ==> FALSE, 1 ==> TRUE
{

	if ( myFlag < intFlag )
	{
		if( me.lower() == "true" )
			return( TRUE );
		else if( me.lower() == "false" )
			return( FALSE );
		else
			varErr = new vkErr( QString ("Use of a non-integer ")
				+("variable as Bool."), vkErr::critical );
	}

	if ( me.toInt() == 1 )
	{
		return(TRUE);
	}
	else
	{
		if ( me.toInt() != 0 )
		{
			varErr = new vkErr( QString ("Non-boolean ")
				+("expression in Integer variable ")
				+("which is used as bool (Value ")
				+("must be 1 or 0)."), vkErr::critical);
		}


		return(FALSE);

	}

}

QString v::str()
{
	return(me);
}

v v::val()
{
	return( *this );
}


v v::s(int ii)
{
	if(isConst)
		varErr = new vkErr( QString ("Can't change ")
			+("constant."), vkErr::critical );

	me.setNum(ii);
	myFlag = intFlag;
	fileBit = false;

	return( *this );
}

v v::s( long ll )
{
	if(isConst)
		varErr = new vkErr( QString ("Can't change ")
			+("constant."), vkErr::critical );

	me.setNum(ll);

	updateFlag();
	fileBit = false;

	return( *this );
}

v v::s( double ff )
{
	if(isConst)
		varErr = new vkErr( QString ("Can't change ")
			+("constant."), vkErr::critical );

	me.setNum(ff);

	updateFlag();
	fileBit = false;

	return( *this );
}

v v::s( bool b )
{
	if(isConst)
		varErr = new vkErr( QString ("Can't change ")
			+("constant."), vkErr::critical );

	debug( "(VK variable set to bool %d)", (int)b );

	if (b)
		me = "TRUE";
	else
		me = "FALSE";

	myFlag = stringFlag;
	fileBit = false;

	return( *this );
}

v v::s( QString str )
{

	if(isConst)
		varErr = new vkErr( QString ("Can't change ")
			+("constant."), vkErr::critical );

	debug( "(VK variable set to %s)", (const char*)str );

	me = str;

	updateFlag();
	fileBit = false;

	return( *this );
}

v v::s( const char *str )
{

	s( QString(str) );
	fileBit = false;

	return( *this );
}

v v::s( v inV )
{

	if(isConst)
		varErr = new vkErr( QString ("Can't change ")
			+("constant."), vkErr::critical );

	debug( "(VK variable set to %s)", (const char*)inV.str() );

	me = inV.str();

	if( inV.isFile() )
		fileBit = true;
	else
		fileBit = false;

	updateFlag();

	return( *this );
}


void v::makeConst()
{
	isConst = true;
}

v::~v()
{
}
