/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <vktop.h>
#include <vktop.moc>

vkTopWindow::vkTopWindow( const char *name )
	: KTopLevelWidget(name)
{
int i;

	for ( i = 1; i < 100; i++ )
		child_ids[i] = 0;

	view_id = -1;

}



void vkTopWindow::registerChild ( vkWidget *newChild,
	const char *name, windowType whatType )
{
//this is for windows and view

int i = 1;


	//looking for a free place:

	while( child_ids[i] != 0 )
		i++;

	if ( i == 99 )
	{
		// no place!

		RUNTIME_ERROR = new vkErr( QString
			("Too many widgets at top level")
			+(" (too many windows)."),
			vkErr::critical );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

	childs[i] = newChild;

	connect ( this, SIGNAL( initChild(int, QString, int ) ),
		childs[i], SLOT( initMe( int, QString, int ) ) );

	connect ( this, SIGNAL(
		childCall( int, QString, QString,
			int, QString ) ),
		childs[i], SLOT(
		postOffice( int, QString, QString,
			int, QString ) )
		);

	connect ( childs[i], SIGNAL(
		parentCall( int, QString, QString,
			int, QString ) ),
		this, SLOT(
		postOffice( int, QString, QString,
			int, QString ) )
		);

	connect ( childs[i], SIGNAL(parProp( QString, QString )),
		SLOT(parProp(QString,QString)) );

	debug ( "New ID %d for top level child.", i );

	child_ids[i] = i;

	if ( whatType == topBody )
	{
		view_id =  child_ids[i];

		//This should be checked (allready a topBody-->Err)
	}

	childNames[i] = name;

	emit (initChild (child_ids[i], childNames[i], 0) );


} // registerChild


void vkTopWindow::forgetChild ( const char *whichChild )
{
int i;

	for ( i = 1; i < 100; i++ )
	{
		if ( childNames[i] == whichChild )
		{
			if ( child_ids[i] == view_id )
			{
				RUNTIME_ERROR = new vkErr( QString
					("Can't forget myself ")
					+("(Can't delete view ")
					+("widget)."),
					vkErr::user );
			}

			child_ids[i] = 0;
			childNames[i] = "";

			return;
		}
	}

	RUNTIME_ERROR = new vkErr ( QString
		("Can't forget a window, which ")
		+("hasn't been registered before ")
		+("(no such window)."), vkErr::user );
}


//slots:

void vkTopWindow::postOffice( int way, QString addressee,
	QString what, int how, QString argument ) //slot
{
int i, childId;
QString tmpString;

	//On it's way from parent to parent ?

	if ( way == -1 )
	{//error:

		RUNTIME_ERROR = new vkErr( argument,
			vkErr::critical );

		return;
	}

	//Try out whether this is _direct_ child:
	if ( addressee.contains('.') )
	{
	//Child is NOT directly addressee

		tmpString = addressee.left(
			addressee.find('.') );
	}
	else
	{

		tmpString = addressee;

	}

	//is there a child 'adressee' ?
	for ( i = 1; i < 100; i++ )
	{

		if ( childNames[i] == tmpString )
		{
			childId = child_ids[i];
			break;
		}
	}

	if ( i < 99 ) //I know this child
	{
		emit ( childCall( childId, addressee, what,
			how, argument ) );
	}
	else
	{

		//No such widget!
		RUNTIME_ERROR = new vkErr (
			QString ("Call for a widget, which is " )
			+("not registered at all."),
			vkErr::critical
		      );

		//-1: Error; addressee: (none);	1: Error number;
		//QString: Error text;

		return;
	}

} //postOffice


void vkTopWindow::parProp( QString p, QString v )
{
	if( p == "caption" )
	{
		setCaption( v );
	}
	else if( p == "width" )
	{
		resize( v.toInt(), height() );
	}
	else if( p == "height" )
	{
		resize( width(), v.toInt() );
	}
	else
	{
		warning( "No such master property: %s", (const char*) p );
	}
}


vkTopWindow::~vkTopWindow()
{
}

