/*************************************************************
*
* (c) 1999 Christoph Pinkel
* This is part of the VisKProg project.
*
* You may use it under the terms of the GPL licence.
* See COPYING for more details!
*
**************************************************************/

#include <vkerr.h>
#include <vkerr.moc>

vkErr::vkErr( QString errTxt, errorType etp )
	: CPBox ( errTxt, 0, "VisKProg runtime error" )
{

	debug ( QString ("VisKProg runtime error occured: ")
		+(errTxt) );

	if ( etp == critical )
	{
		debug ( "Sorry, I must give up!" );
		abort();
	}
	else
	{
		CPBox ask( "Error abort is user defined. Abort?",
			0, "Abort program ?", "Yes", "No" );

		if ( ask.answer == 1 )
		{
			debug ( "User decided to break" );
			abort();
		}
		else
		{
			debug("PLEASE NOTE:");
			debug("You continued at your own risk.");
			debug("Perhaps the program will crash now.");
		}
	}

	delete this;
}

vkErr::~vkErr()
{
}
