/***************************************************************************
                          kguiview.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Mar 15 23:42:04 GMT 1999
                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qsplitter.h>
#include <qlabel.h>
#include <qlayout.h>
#include "kguiview.h"
#include "propertydialog.h"
#include "propertytree.h"
#include "formview.h"
#include "kguidoc.h"
#include "component.h"

KGUIView::KGUIView(KApplication* a,KGUIDoc* doc,QWidget *parent)
	: QWidget(parent)
{
	propDlg= 0;
	document_= doc;
	
	QBoxLayout *box= new QHBoxLayout(this);
	CHECK_PTR(box);

	// Create the splitter
	QSplitter *splitter= new QSplitter(QSplitter::Horizontal, this);
	CHECK_PTR(splitter);
	box->addWidget(splitter);

	// Create tree view
	hierarchyView= new HierarchyView(splitter, "Hierarchy View");
	CHECK_PTR(hierarchyView);

	hierarchyView->setDocument(doc);
	
	// Handle selections
	connect( hierarchyView, SIGNAL( selectionChanged(QListViewItem *) ),
													SIGNAL( selectionChanged(QListViewItem *) ) );
	connect( hierarchyView, SIGNAL( selectionChanged(QListViewItem *) ),
													SLOT( select(QListViewItem *) ) );

	// Handle invocations
	connect(	hierarchyView, 	SIGNAL( returnPressed(QListViewItem *) ),
														SLOT( properties(QListViewItem *) ) );
	connect(	hierarchyView, 	SIGNAL( doubleClicked(QListViewItem *) ),
														SLOT( properties(QListViewItem *) ) );
	connect(	hierarchyView, 	SIGNAL( showProperties(Instance *) ),
														SLOT( showProperties(Instance *) ) );
	connect( 	doc,						SIGNAL(update(Instance *) ),
						hierarchyView,	SLOT(refresh(Instance *)) );
													
	connect( this, SIGNAL( activate(Instance *) ), SLOT( showProperties(Instance *) ) );

	FormView *formView= new FormView(splitter, "Form View");
	CHECK_PTR(formView);
		
	formView->setRoot(doc->rootInstance());
	
	connect( 	doc,						SIGNAL(update(Instance *) ),
						formView,	SLOT(refresh(Instance *)) );

	// Start the layout manager
	box->activate();
}

KGUIView::~KGUIView()
{
}

KGUIDoc *KGUIView::document()
{
	return document_;
}

// SLOT
void KGUIView::showProperties(Instance *i)
{
	warning("Slot: showProperties()");

	if (propDlg == 0) {
		propDlg= new PropertyDialog();
		CHECK_PTR(propDlg);

		connect(this, SIGNAL (selectionChanged(Instance *)),
						propDlg, SLOT(setInstance(Instance *)) );
	
		
		connect(propDlg->listView(), SIGNAL(edited(Instance *)),
						document_, SIGNAL(update(Instance *)));
	}

	propDlg->setInstance(i);
	propDlg->show();
	propDlg->raise();
}

// SLOT
void KGUIView::select(Instance *i)
{
	selectedInstance= i;

	// Inform the child views
	warning("Slot: select(Instance *i= %p)", i);
	
	document_->select(i);
}

// SLOT
void KGUIView::select(QListViewItem *i)
{
	warning("Slot: select(QListViewItem *)");

	Instance *in= hierarchyView->findInstance(i);

	if (in != selectedInstance) {
		select(in);
		emit selectionChanged(in);
	}
}

// SLOT
void KGUIView::properties(QListViewItem *i)
{
	warning("Slot: properties(QListViewItem *)");

	Instance *in= hierarchyView->findInstance(i);

	emit activate(in);
}
















































