/***************************************************************************
                          intvalue.h  -  description                              
                             -------------------                                         
    begin                : Tue Mar 23 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef INTVALUE_H
#define INTVALUE_H

#include <qstring.h>
#include <value.h>

/**
	* Represents an integer value.
	*
  * @author Richard Moore
  */
class IntValue : public Value  {
public: 
	IntValue();
	virtual ~IntValue();

	virtual ValueEditor *createEditor(QWidget *);

	int value();
	void setValue(int);

	/**
		* Convert the value to a string.
		*/
	virtual const char *toString();

	/**
		* Set the value from a string.
		*/
	virtual void fromString(const char *);
protected:
	int val;
	QString valueStr;
};

#endif

