/***************************************************************************
                          colourvalueeditor.h  -  description                              
                             -------------------                                         
    begin                : Thu Apr 8 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef COLOURVALUEEDITOR_H
#define COLOURVALUEEDITOR_H

#include <qwidget.h>
#include "valueeditor.h"
#include "colourvalue.h"

class QLineEdit;
class QPushButton;

/**
	* Edits colour values.
	*
  *@author Richard Moore
  */
class ColourValueEditor : public ValueEditor  {
   Q_OBJECT
public: 
	ColourValueEditor(QWidget *parent, const char *name, ColourValue *v);
	~ColourValueEditor();

public slots:
	void showDialog();

signals:
	void cancelled();
	void accepted();
	void accepted(Value *);
	void resized();

protected:
	virtual void saveValue();

private:
	QLineEdit *lineEdit;
	QPushButton *dlgButton;
};

#endif



