/***************************************************************************
                          colourvalue.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Apr 8 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "colourvalue.h"
#include "colourvalueeditor.h"

ColourValue::ColourValue()
	: Value(),
		colour("red"),
		pix()
{
	warning("ColourValue::ColourValue()");
	text_= "#ffffff";
}

ColourValue::~ColourValue()
{
}

ValueEditor *ColourValue::createEditor(QWidget *parent)
{
	ColourValueEditor *frame= new ColourValueEditor(parent, "Colour editor", this);
	CHECK_PTR(frame);

	return frame;
}

const char *ColourValue::toString()
{
	QString s;
	int r= colour.red();
	int g= colour.green();
	int b= colour.blue();

	s.sprintf("#%02x%02x%02x", r, g, b);
	warning("string is '%s'", s.data());
	text_= s;

	return text_.data();
}

void ColourValue::fromString(const char *str)
{
	ASSERT(str);
	warning("ColourValue::fromString() [not implemented]");

	text_= str;
}

void ColourValue::setColor(const QColor &c)
{
	colour= c;
}

const QColor &ColourValue::color()
{
	return colour;
}

bool ColourValue::hasPixmapView()
{
	return true;
}

QPixmap *ColourValue::toPixmap(int width, int height)
{
	warning("ColourValue::toPixmap()");
	QPixmap p(width, height);
	p.fill(colour);
	pix= p;
	return &pix;
}











