/***************************************************************************
                          lampcomponent.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Mar 19 1999                                           
    copyright            : (C) 1999 by Richard Moore                         
    email                : rich@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kled.h>

#include "lampcomponent.h"
#include "instance.h"

#include "enumvalue.h"

#define COMPONENT_NAME "KLed"
#define COMPONENT_DESC "A round LED widget"

// Create the component. The name and description of the component are passed
// to the super class which makes them availble to KGUI. You can (and probably
// should) also pass the Package which provides this component.
LampComponent::LampComponent()
  : Component(COMPONENT_NAME, COMPONENT_DESC)
{
}

LampComponent::~LampComponent()
{
}

Instance *LampComponent::createInstance(Instance *parent)
{
  warning("Creating Lamp Instance");

  // Create the instance (the Instance class itself is usually sufficient, but you
  // could also return an Instance subclass if you like.
  Instance *i= new Instance(this, parent);

  // Create an enum value to represent the KLed::State enum
  EnumValue *ev= new EnumValue();
  ev->addValue("On", KLed::On);
  ev->addValue("Off", KLed::Off);
  i->addProperty("State", ev);

  EnumValue *ev2= new EnumValue();
  ev2->addValue("Flat", KLed::flat);
  ev2->addValue("Round", KLed::round);
  ev2->addValue("Sunken", KLed::sunken);
  i->addProperty("Look", ev2);

  EnumValue *ev3= new EnumValue();
  ev3->addValue("Yellow", KLed::yellow);
  ev3->addValue("Orange", KLed::orange);
  ev3->addValue("Red", KLed::red);
  ev3->addValue("Green", KLed::green);
  ev3->addValue("Blue", KLed::blue);
  i->addProperty("Color", ev3);

  return i;
}

QWidget *LampComponent::createView(Instance *props, QWidget *parent)
{
  ASSERT(parent);
  ASSERT(props);

  warning("Creating lamp view");

  // Get the values from the Instance
  EnumValue *state= (EnumValue *) props->get("State");
  EnumValue *colour= (EnumValue *) props->get("Color");
  EnumValue *look= (EnumValue *) props->get("Look");

  // Create the view
  KLed *view= new KLed( (KLed::Color) colour->toInt(),
			(KLed::State) state->toInt(),
			(KLed::Look) look->toInt(),
			parent, "Lamp widget");
  CHECK_PTR(view);

  // You could call updateView() here to set the properties, but it's
  // not necessary in this example.
		
  return view;
}

void LampComponent::updateView(Instance *props, QWidget *view)
{
  ASSERT(view);
  ASSERT(props);
	
  if (view->inherits("KLed")) {
    KLed *l= (KLed *) view;

    EnumValue *state= (EnumValue *) props->get("State");
    EnumValue *colour= (EnumValue *) props->get("Color");
    EnumValue *look= (EnumValue *) props->get("Look");

    // Update the view from the properties stored in the Instance.
    l->setState( (KLed::State) state->toInt() );
    l->setLook( (KLed::Look) look->toInt() );
    l->setColor( (KLed::Color) colour->toInt() );
  }	
}












































