/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFString.h>
#include <SFRotation.h>
#include <SFEvent.h>
#include <Children.h>
#include <Sound.h>

/*************************************************************************/
void Sound::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered Sound::eventIn (" << DEF << ")\n";
#endif 

  /* Determine what action to take based on incoming event */
  if        ((eventType == "source")    || (eventType == "set_source")) {
    Source *n = (Source *) eventData;
    source = *n;
    
  } else if ((eventType == "intensity") || (eventType == "set_intensity")) {
    SFFloat *n = (SFFloat *) eventData;
    intensity = *n;

  } else if ((eventType == "priority") || (eventType == "set_priority")) {
    SFFloat *n = (SFFloat *) eventData;
    priority = *n;

  } else if ((eventType == "location") || (eventType == "set_location")) {
    SFVec3f *n = (SFVec3f *) eventData;
    location = *n;

  } else if ((eventType == "direction") || (eventType == "set_direction")) {
    SFVec3f *n = (SFVec3f *) eventData;
    direction = *n;

  } else if ((eventType == "minFront") || (eventType == "set_minFront")) {
    SFFloat *n = (SFFloat *) eventData;
    minFront = *n;

  } else if ((eventType == "maxFront") || (eventType == "set_maxFront")) {
    SFFloat *n = (SFFloat *) eventData;
    maxFront = *n;

  } else if ((eventType == "minBack") || (eventType == "set_minBack")) {
    SFFloat *n = (SFFloat *) eventData;
    minBack = *n;

  } else if ((eventType == "maxBack") || (eventType == "set_maxBack")) {
    SFFloat *n = (SFFloat *) eventData;
    maxBack = *n;

  } else if ((eventType == "spatialize") || (eventType == "set_spatialize")) {
    SFFloat *n = (SFFloat *) eventData;
    spatialize = *n;
  }
}
/*************************************************************************/

/*************************************************************************/
void Sound::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tSound: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "source") {
      source.parse(header, InFile);

    } else if (Token == "intensity") {
      intensity.parse(header, InFile);

    } else if (Token == "priority") {
      priority.parse(header, InFile);

    } else if (Token == "location") {
      location.parse(header, InFile);

    } else if (Token == "direction") {
      direction.parse(header, InFile);

    } else if (Token == "minFront") {
      minFront.parse(header, InFile);

    } else if (Token == "maxFront") {
      maxFront.parse(header, InFile);

    } else if (Token == "minBack") {
      minBack.parse(header, InFile);

    } else if (Token == "maxBack") {
      maxBack.parse(header, InFile);

    } else if (Token == "spatialize") {
      spatialize.parse(header, InFile);

    } else if (Token == "Sound") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse()\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse()\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }

}
/*************************************************************************/

