/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */



/* for file dialogs */
#include <qkeycode.h>
#include <stdio.h>
#include <qfiledlg.h>
#include <qmsgbox.h>

/* kde includes */
#include <kapp.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <kcolordlg.h>

/* local definitions */
#include "SFNode.h"
#include "VrmlViewer.h"
#include "VrmlParse.h"

/* the meta language interface */
#include "VrmlViewer.moc"

/* the mesa header files */
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

/* the default dimensions */
#define DefaultDim 325

#define DEBUG_VRMLVIEWER_NOT

/*************************************************************************/
void VrmlViewer::slotFly()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotFly\n";
#endif

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotStopTimeStep()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotStopTimeStep\n";
#endif

  /* stop continuous animation */
  continuousAnimation = false;

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotDoubleTimeStep()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotDoubleTimeStep\n";
#endif

  /* set up for continuous animation */
  continuousAnimation = true;

  /* continue until this is unset */
  while (continuousAnimation) {

    /* do a single update */
    slotSingleTimeStep();

    /* process any other events */
    kapp->processEvents();

  }

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotSingleTimeStep()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotSingleTimeStep\n";
#endif

  /* let propogate the time event */
  protectedViewer->GenerateTimeEvent();

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotHelpQt()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotHelpQt\n";
#endif
 
  /* create a simple message for the qt help */
  QMessageBox aboutmsg;
  aboutmsg.aboutQt(this);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotHelpKDE()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotHelpKDE\n";
#endif

  /* create a simple message for the qt help */
  QMessageBox::about( NULL,
		      klocale->translate( "About KDE" ),
		      klocale->translate(
					 "\nThe KDE Desktop Environment was written by the KDE Team,\n"
					 "a world-wide network of software engineers commited to\n"
					 "free software development.\n\n"
					 "Visit http://www.kde.org for more information on the KDE\n"
					 "Project. Please consider joining and supporting KDE.\n\n"
					 "Please report bugs at http://buglist.kde.org.\n" ));    
  
#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotAbout()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotAbout\n";
#endif

  /* create the about message */
  QMessageBox aboutmsg;
  QString tmpStr;
  tmpStr = PACKAGE;
  tmpStr += " - ";
  tmpStr += VERSION;
  tmpStr += "\n(c) 1998, 1999 Mark R. Stevens\n";
  tmpStr += "\nstevensm@cs.colostate.edu\n";
  tmpStr += "\nhttp://www.cs.colostate.edu/~stevensm/kde/kwrl.html\n\n";
  tmpStr += "This program is free software; you can redistribute it and/or modify\n";
  tmpStr += "it under the terms of the GNU General Public License as published by\n";
  tmpStr += "the Free Software Foundation; either version 2 of the License, or\n";
  tmpStr += "(at your option) any later version.\n";
  tmpStr += "\n";
  tmpStr += "This program is distributed in the hope that it will be useful,\n";
  tmpStr += "but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
  tmpStr += "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n";
  tmpStr += "GNU General Public License for more details.\n";
  tmpStr += "\n";
  tmpStr += "You should have received a copy of the GNU General Public License\n";
  tmpStr += "along with this program; if not, write to the Free Software\n";
  tmpStr += "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n";

  /* handels the about message dialog */
  aboutmsg.information( this, klocale->translate("About Kwrl"),
                        tmpStr.data(),
                        klocale->translate("&Ok") );


#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotHelp()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotHelp\n";
#endif

  /* start up the html editor for the help page. */
  kapp->invokeHTMLHelp("", "");

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotLoadFile()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotLoadFile\n";
#endif

  /* get the file name to load */
  QString str = QFileDialog::getOpenFileName("./", "*.wrl", this, "Load Wrl");

  /* load the file */
  if (str.isNull()) return;

  /* go through and empty out the lists */
  privateExposeEvents->clear();
  privateSensorEvents->clear();

  /* store into the drawing area */
  char rstr[1024];
  strcpy(rstr, (const char *) str);
  protectedViewer->Initialize(rstr,
			      privateExposeEvents,
			      privateSensorEvents);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotSetBackgroundColor()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotSetBackgroundColor\n";
#endif

  /* get the color */
  int result = KColorDialog::getColor(backColor);

  /* verify a color was received */
  if (! result) return;

  /* set the color */
  glClearColor((float(backColor.red()) / 255.0),
	       (float(backColor.green()) / 255.0),  
	       (float(backColor.blue()) / 255.0),  
	       0.0);

  /* redraw the screen */
  protectedViewer->paintGL();

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::slotQuit()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::slotQuit\n";
#endif
  
  /* exit */
  kapp->quit();

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::InitializeHelpMenu()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::InitializeHelpMenu\n";
#endif

  /* create the help menu */
  QPopupMenu *help = new QPopupMenu;
  help->insertItem(klocale->translate("Help"), this, SLOT(slotHelp()));
  help->insertItem(klocale->translate("About Kwrl"), this, SLOT(slotAbout()));
  help->insertSeparator();
  help->insertItem(klocale->translate("About &KDE"), this, SLOT(slotHelpKDE()));
  help->insertItem(klocale->translate("About &Qt"), this,  SLOT(slotHelpQt()));

  /* add the acceleration keys */
  accel->addKey("Help", accel->help());
  accel->connectFunction("VrmlViewer", "Help", this, SLOT(slotHelp()));
  
  /* add to the menu */
  protectedMenuBar->insertItem(klocale->translate("&Help"), help);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::InitializeEventsMenu()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::InitializeEventsMenu\n";
#endif

  /* create the events menu */
  QPopupMenu *events      = new QPopupMenu;

  /* create the sub-menu for exposed field events */
  privateExposeEvents = new QPopupMenu;

  /* create the exposed events */
  events->insertItem(klocale->translate("Exposed Fields"), privateExposeEvents);

  /* create the sensor events */
  privateSensorEvents = new QPopupMenu;
  events->insertItem(klocale->translate("Sensor Events"), privateSensorEvents);

  /* add to the menubar */
  protectedMenuBar->insertItem(klocale->translate("&Events"), events);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::InitializeOptionsMenu()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::InitializeOptionsMenu\n";
#endif

  /* create the options menu */
  QPopupMenu *options = new QPopupMenu;
  options->insertItem(klocale->translate("Background Color"), this, SLOT(slotSetBackgroundColor()));

  /* add the acceleration keys */
  accel->addKey("background", "CTRL+B");
  accel->connectFunction("VrmlViewer", "background", this, SLOT(slotSetBackgroundColor()));

  /* add to the menubar */
  protectedMenuBar->insertItem(klocale->translate("&Options"), options);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::InitializeFileMenu()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::InitializeFileMenu\n";
#endif

  /* Create the pulldown menu */
  QPopupMenu *file = new QPopupMenu;

  /* insert the open file and quite options */
  file->insertItem(klocale->translate("Open File"), this, SLOT(slotLoadFile()));
  file->insertItem(klocale->translate("Quit"), this, SLOT(slotQuit()));

  /* add the acceleration keys */
  accel->addKey("open", accel->open());
  accel->addKey("quit", accel->quit());
  accel->connectFunction("VrmlViewer", "open", this, SLOT(slotLoadFile()));
  accel->connectFunction("VrmlViewer", "quit", this, SLOT(slotQuit()));

  /* add to the menubar */
  protectedMenuBar->insertItem(klocale->translate("&File"), file);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
VrmlViewer::VrmlViewer(char *FN):KTopLevelWidget("VrmlViewer")
{

  /* Create Interface */
  CreateInterface();

  /* call initialize with arguments */
  protectedViewer->Initialize(FN, privateExposeEvents, privateSensorEvents);

}
/*************************************************************************/

/*************************************************************************/
VrmlViewer::VrmlViewer():KTopLevelWidget("VrmlViewer")
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::VrmlViewer\n";
#endif

  /* Create Interface */
  CreateInterface();

  /* call initialize with no arguments */
  protectedViewer->Initialize((char *) 0, privateExposeEvents, privateSensorEvents);

}
/*************************************************************************/

/*************************************************************************/
void VrmlViewer::CreateInterface()
{

  /* no timer is set */
  continuousAnimation = false;

  /* the befault background color */
  backColor.setRgb((unsigned char) (0.047 * 255),
		   (unsigned char) (0.098 * 255),
		   (unsigned char) (0.298 * 255));

  /* here we create key bindings */
  config = kapp->getConfig();
  accel = new KStdAccel(config);
  accel->registerWidget("VrmlViewer", this);     

  /* create the task bar */
  KToolBar *localToolBar = new KToolBar(this);

  /* for loading icons */
  char iconpath[1024];
  QPixmap pixmap;

  /* add the animation icons */
  sprintf(iconpath, "%s/kwrl/fly.xpm", kapp->kde_datadir().data());
  pixmap.load(iconpath); 
  localToolBar->insertButton(pixmap, 
			     0,
			     SIGNAL(clicked()), 
			     this,
			     SLOT(slotFly()), 
			     TRUE,
			     klocale->translate("Enter Fly Mode"));
  sprintf(iconpath, "%s/kwrl/single.xpm", kapp->kde_datadir().data());
  pixmap.load(iconpath); 
  localToolBar->insertButton(pixmap, 
			     0,
			     SIGNAL(clicked()), 
			     this,
			     SLOT(slotSingleTimeStep()), 
			     TRUE,
			     klocale->translate("Forward a Time Step"));
  sprintf(iconpath, "%s/kwrl/double.xpm", kapp->kde_datadir().data());
  pixmap.load(iconpath); 
  localToolBar->insertButton(pixmap, 
			     0,
			     SIGNAL(clicked()), 
			     this,
			     SLOT(slotDoubleTimeStep()), 
			     TRUE,
			     klocale->translate("Run Animation"));
  sprintf(iconpath, "%s/kwrl/stop.xpm", kapp->kde_datadir().data());
  pixmap.load(iconpath); 
  localToolBar->insertButton(pixmap, 
			     0,
			     SIGNAL(clicked()), 
			     this,
			     SLOT(slotStopTimeStep()), 
			     TRUE,
			     klocale->translate("Stop Animation"));
 
  /* create the menu bar */
  protectedMenuBar = new KMenuBar( this, "MenuBar_0" );

  /* create the file menu */
  InitializeFileMenu();

  /* create the options menu */
  InitializeOptionsMenu();

  /* create the events menu */
  InitializeEventsMenu();

  /* add a separator before inserting the help menu */
  protectedMenuBar->insertSeparator();

  /* create the help menu */
  InitializeHelpMenu();

  /* associate the menubar with the toplevel */
  setMenu(protectedMenuBar);

  /* add the toolbar */
  addToolBar(localToolBar);

  /* create a drawing area */
  protectedViewer = new DrawingArea(this, "protectedViewer");

  /* associate with the viewer */
  setView(protectedViewer, TRUE);

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/

/*************************************************************************/
VrmlViewer::~VrmlViewer()
{

#ifdef DEBUG_VRMLVIEWER
  cout << "\nEntered VrmlViewer::~VrmlViewer\n";
#endif

  /* remove what was created */
  delete protectedMenuBar;
  delete protectedViewer;
  delete privateExposeEvents;
  delete privateSensorEvents;

#ifdef NOT
  delete accel;
#endif

#ifdef DEBUG_VRMLVIEWER
  cout << "\tDone\n";
#endif

}
/*************************************************************************/







