/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef SWITCH
#define SWITCH

// label
#define SwitchLabel "Switch"

// classes
#include <SFNode.h>
#include <SFRenderInfo.h>
#include <SFInt32.h>
#include <Children.h>

// class definition
class Switch : public SFNode {

 public:

  // constructor
  Switch() : SFNode(SwitchLabel) {
    whichChoice = -1;
  }
    
  // destructor
  ~Switch() {
  }

  // parse
  void parse   (char *, istream      &);

  // prepare 
  void prepare (SFVec3f      &, SFVec3f &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode  *);

  // operators
  Switch &operator = (Switch &S2) {
    choice         = S2.choice;
    whichChoice    = S2.whichChoice;
    isValid()      = S2.isValid();
    return(*this);
  }
  
  // Queue
  void push(Children &stack, SFString &stackType) {
    if (stackType == nodeType()) stack.add(this);
    else                         choice.push(stack, stackType);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return(choice.findDEF(UnsatUSE));
  }
  SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return(choice.findUSE());
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFInt32  whichChoice;
  Children choice;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // SWITCH
