/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SFINT32
#define SFINT32

// label
#define SFInt32Label "SFInt32"

//classes 
#include <SFNode.h>

// class definition
class SFInt32 : public SFNode {

 public:

  // constructor
  SFInt32() : SFNode(SFInt32Label) {
    data = 0;
  }
  
  // destructor
  ~SFInt32() {
  }

  // parse
  void parse(char *, istream &);

  // access
  int operator () () {
    return(data);
  }
  friend int operator == (SFInt32 &b1, int b2) {
    return(b1() == b2);
  }
  friend int operator != (SFInt32 &b1, int b2) {
    return(b1() != b2);
  }
  operator int () {
    return(data);
  }
  SFInt32 &operator = (SFInt32 &b1) {
    data = b1.data;
    return(*this);
  }
  SFInt32 &operator = (int b1) {
    data = b1;
    return(*this);
  }

 protected:

 private:

  // data
  int data;

};

#endif // SFInt32
