/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef POSITIONINTERPOLATOR
#define POSITIONINTERPOLATOR

// label
#define PositionInterpolatorLabel "PositionInterpolator"

// classes
#include <SFNode.h>
#include <MFVec3f.h>
#include <MFFloat.h>
#include <SFVec3f.h>
#include <SFString.h>

// class definition
class PositionInterpolator : public SFNode {

 public:

  // constructor
  PositionInterpolator() : SFNode(PositionInterpolatorLabel) {
  }
    
  // destructor
  ~PositionInterpolator() {
  }

  // parse
  void parse   (char     *, istream  &);

  // events
  void eventIn (SFString &, SFNode   *);
  void eventOut(SFString &, SFNode   *);

  // operators
  PositionInterpolator &operator = (PositionInterpolator &P2) {
    keyValue                     = P2.keyValue;
    key                          = P2.key;
    value_changed                = P2.value_changed;
    isValid()                    = P2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  MFVec3f  keyValue;
  MFFloat  key;

  // event data
  SFVec3f  value_changed;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // PositionInterpolator


