/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef MATERIAL
#define MATERIAL

// label
#define MaterialLabel "Material"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFVec3f.h>
#include <SFColor.h>
#include <SFString.h>

// class definition
class Material : public SFNode {

 public:

  // constructor
  Material() : SFNode(MaterialLabel) {
    diffuseColor[0]  = 0.8;
    diffuseColor[1]  = 0.8;
    diffuseColor[2]  = 0.8;
    ambientIntensity = 0.2;
    specularColor[0] = 0.0;
    specularColor[1] = 0.0;
    specularColor[2] = 0.0;
    emissiveColor[0] = 0.0;
    emissiveColor[1] = 0.0;
    emissiveColor[2] = 0.0;
    shininess        = 0.2;
    transparency     = 0.0;
  }

  // destructor
  ~Material() {
  }

  // parse
  void parse   (char         *, istream      &);
    
  // renders
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  Material &operator = (Material &M2) {
    diffuseColor     = M2.diffuseColor;
    ambientIntensity = M2.ambientIntensity;
    specularColor    = M2.specularColor;
    emissiveColor    = M2.emissiveColor;
    shininess        = M2.shininess;
    transparency     = M2.transparency;
    isValid()        = M2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) {
      return(this);
    } else {
    }
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFColor diffuseColor;
  SFFloat ambientIntensity;
  SFColor specularColor;
  SFColor emissiveColor;
  SFFloat shininess;
  SFFloat transparency;

  // USE-DEF
  SFString DEF;
  SFString USE;
   
};

#endif // Material
