/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef BOX
#define BOX

// the label
#define BoxLabel "Box"

// classes
#include <SFNode.h>
#include <SFVec3f.h>
#include <SFString.h>

// class definition
class Box : public SFNode {

public:

  // constructor
  Box() : SFNode(BoxLabel) {
    size[0] = 2.0;
    size[1] = 2.0;
    size[2] = 2.0;
  }

  // destructor
  ~Box() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);
    
  // render
  void render  (SFRenderInfo &);

  // operators
  Box &operator = (Box &B2) {
    size        = B2.size;
    isValid()   = B2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

protected:

private:

  // data
  SFVec3f size;

  // USE-DEF
  SFString DEF;
  SFString USE;

};

#endif // Box

