/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __MISCWIDGETS_H__
#define __MISCWIDGETS_H__

#include <qwidget.h>
#include <qlcdnum.h>
#include <qlabel.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qslider.h>
#include <stdlib.h>
#include <qframe.h>
#include <qpainter.h>

#include "preview.h"

class ImageHistogram: public QFrame {
	Q_OBJECT
public:
	ImageHistogram(Preview *ps,int pcolor = 0,
		       QWidget *parent = NULL,char *name = NULL):
		QFrame(parent,name),
		s(ps),color(pcolor)
		{ setFrameStyle(Box|Sunken); count(); }
public slots:
        void redraw()
	{ count(); repaint(); }
private:
	Preview *s;
	int hits[256];
	int maxhits;
	int color;
	void count();
	void drawContents(QPainter *p);
};

const int SliderWidth = 200, SliderHeight = 15;

class CoolSlider: public QWidget {
	Q_OBJECT
public:
	CoolSlider(char *title,int min,int max,int step,int v,int ndig,
		   QWidget *parent = NULL, const char *name = NULL);
public slots:
        void setValue(int v)
	{ s->setValue(v); }
	void chval(int v)
	{ emit valueChanged(v); }
signals:
	void valueChanged(int);
private:
	QLCDNumber *n;
	QLabel *lb;
	QSlider *s;
};

#endif
