/*
 *   kscan - a scanning program
 *   Copyright (C) 1998 Ivan Shvedunov
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qvalidator.h>
#include <qlayout.h>

#include "backend.h"

#define A(x) printf("POINT %d\n",x);

BackendDialog::BackendDialog(KConfig *kc,char *backend,
			     bool showWarning):
	QDialog(NULL,NULL,TRUE)
{
	b = backend;
	kconf = kc;
	sw = showWarning;
	backends = new QListBox(this,"bcklist");
	A(1);
	ScanImage::getDevices((const SANE_Device ***)&dl);
	A(2);
	for(int i = 0; dl[i]; i++) {
		char s[401];
		if(strlen(dl[i]->name)>100||
		   strlen(dl[i]->vendor)>100||
		   strlen(dl[i]->model)>100||
		   strlen(dl[i]->type)>100)  //Buffer overrun attempt
			strcpy(s,"-bad entry-");
		else sprintf(s,"%20s %30s %20s %20s",
			     dl[i]->name,dl[i]->vendor,dl[i]->model,
			     dl[i]->type);
		backends->insertItem(s);
	}
	backends->setMinimumSize(KApplication::desktop()->width()/3,
				 backends->itemHeight()*
				 backends->count()+10);
	connect(backends,SIGNAL(selected(int)),SLOT(selected(int)));
	QPushButton *ok = new QPushButton("OK",this,"ok");
	QPushButton *cancel = new QPushButton("Cancel",this,"cancel");
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	ok->setMinimumHeight(30);
	cancel->setMinimumHeight(30);
	//setFixedWidth(QApplication::desktop()->width()/3);
	QVBoxLayout l(this);
	QHBoxLayout l2;
	l.addWidget(backends);
	l.addLayout(&l2);
	l2.addStretch(1);
	l2.addWidget(ok,2);
	l2.addStretch(1);
	l2.addWidget(cancel,2);
	l2.addStretch(1);
	l.addStretch(1);
	l.activate();
	adjustSize();
	//printf("done...\n");
}

void BackendDialog::done(int r)
{
	if(r) {
		strcpy(b,dl[backends->currentItem()]->name);
		kconf->writeEntry(OP_BACKEND,b);
		if(sw) QMessageBox::warning(NULL,"Warning","You need to "
					    "restart kscan to make it\n"
					    "work with new backend.");
	}
	QDialog::done(r);
}

#include "backend.moc"
