
#ifndef kpov_included
#define kpov_included

#include <qapp.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qimage.h>
#include <qfiledlg.h>
#include <qcombo.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qfileinf.h>
#include <qgrpbox.h>
#include <qaccel.h>

#include <kapp.h> 
#include <klined.h>
#include <ktablistbox.h>
#include <kurl.h>
#include <kmsgbox.h> 
#include <ktreelist.h>
#include <ktopwidget.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kprogress.h>

#define YGRID_1           20
#define YGRID_2           50
#define YGRID_3           80
#define YGRID_4          110
#define YGRID_5          140
#define YGRID_6          170
#define YGRID_7          200 
#define YGRID_8          230  
#define YGRID_9          260  
#define YGRID_10         290
#define YGRID_11         320 
#define YGRID_12         350
#define YGRID_13         380
#define YGRID_14         410
#define YGRID_15         440

#define XGRID_1            0
#define XGRID_2           50
#define XGRID_3          100
#define XGRID_4          150
#define XGRID_5          200
#define XGRID_6          250
#define XGRID_7          300
#define XGRID_8          350
#define XGRID_9          400
#define XGRID_10         450
#define XGRID_11         500
#define XGRID_12         550
#define XGRID_13         600
#define XGRID_14         650

#define HOEHE            25
#define BREITE_1         95

#define BILDGROPTMAX     5
#define GRFORMATMAX      4

class KPoV : public KTopLevelWidget
{
    Q_OBJECT

public:

    KPoV();
    virtual ~KPoV();

    int markedinclude;
    bool ismarkedinclude;

    QString startoptions1;
    QString startoptions2;
    QString formatstring;

    int anzahlmoeglaufl;
    int i;
    int counter;
    int linien;

    KMenuBar *menu;

    KStatusBar *statuspov;

    QAccel *a;

    QPopupMenu *filemenu;
    QPopupMenu *helpmenu;
    QPopupMenu *optionsmenu;

    QLabel *labelaufloesung;
    QLabel *labelantial;
    QLabel *labelformat;

    QComboBox *comboaufloesung;
    QComboBox *comboformat;
    QComboBox *comboantial;

    QPushButton *buttonmakecommand;
    QPushButton *buttonfile;
    QPushButton *buttonsave;
    QPushButton *buttonincludedir;
    QPushButton *buttonstartkview;
    QPushButton *buttonstartpov;
    QPushButton *buttonadd;
    QPushButton *buttonstartkedit;
    QPushButton *buttondelinclude;
    
    QGroupBox *gbox1;

    QCheckBox *cboxPOV;
    QCheckBox *cboxVerbose;
    QCheckBox *cboxPause;
    QCheckBox *cboxDisplay;

    KfDirDialog *dirtree;

    KLined *textinfile;
    KLined *textoutfile;
    KLined *textcommand;
    KLined *textcustomx;
    KLined *textcustomy;
    KLined *textaufloesungx;
    KLined *textaufloesungy;

    KConfig *config;

    KProcess *proc;

    KProgress *progress;

    KTabListBox *tablistinclude;
    KTabListBox *tablistaufloesungen;

public slots:

    void help();
    void openfile();
    void savefile();
    void openincludedir(/*int id*/); 
    void about();
    void aboutqt();
    void quit();
    void makecommand();
    void aufloesung(int id);
    void bildformat(int id);
    void configfilesave();
    void configfileload();
    void done(KProcess* proc);
    void readStdout(KProcess* proc, char *buffer, int buflen);
    void startKView();
    void startPOV();
    void startKEdit();
    void delinclude();
    void setdelinc(int id,int id2);
};

#endif // kpov_included
