#include <stdlib.h>
#include "kblinselstereogram.h"

KBlinselStereogram::KBlinselStereogram()
{
  use_texturing = false;
}

KBlinselStereogram::~KBlinselStereogram()
{
}

QImage KBlinselStereogram::calc()
{
 QImage img1; 

 float Z[source.width()+1][source.height()+1];
 const int maxX = source.width();
 const int maxY = source.height();
 int textX = pattern.height(); 
 int textY = pattern.width(); 
 if (use_texturing==false)
 { textX=maxX; textY=maxY; }
 int texture[textX][textY];
 int x, y, count;

 y = 0;
 x = 0;

 source = source.convertDepth(8);
 img1.create(maxX,maxY,8);

 if(use_texturing == true)
 {
 pattern = pattern.convertDepth(8); 
 pattern.setNumColors(256); 
 img1.setNumColors(256);
  for(count = 0; count < 256; count++)
  {
   img1.setColor(count, pattern.color(count)); 
  }     
 img1.convertDepth(8);
 for(y = 0; y < textY; y++)
  for(x = 0; x < textX; x++) 
   texture[x][y] = pattern.pixelIndex(x,y);
 }  
 else   
 {
  img1.setNumColors(2);
  img1.setColor(0,qRgb(0,0,0));
  img1.setColor(1,qRgb(255,255,255));
  for (x=0; x<maxX; x++)
   for (y=0; y<maxY; y++)
    texture[x][y]=random()&1;  
 }

 for(y = 0; y < maxY; y++) 
  for(x = 0; x < maxX; x++)
   Z[x][y]=
   (1./256.)* (float)
   ((qRed  (source.pixel(x,y))+
     qGreen(source.pixel(x,y))+
     qBlue (source.pixel(x,y)) ) / 3.);  

 for(y=0; y < maxY; y++) 
    {
     int *point = new int[maxX]; 
     int *sim = new int[maxX];
     int s;
     int left,right;

     emit renderStatus(y); 

     for( x = 0; x < maxX; x++ ) *(sim+x) = x;

     for( x = 0; x < maxX; x++ ) 
     {
       s = round((1-mu*Z[x][y])*E/(2-mu*Z[x][y]));
       left = x - (s/2);
       right = left + s;        
       if ( 0 <= left && right < maxX )
       {       
        { 
          int k;                
          for(k=sim[left]; k!=left && k!=right; k=*(sim+left))
           if( k < right ) left = k;
           else { left = right; right = k; }
           *(sim+left) = right; 
        }
       }
     }

     for( x = maxX-1; x >= 0; x-- ) 
      {
       if( *(sim+x) == x ) 
        *(point+x) = texture[x%textX][y%textY];        
       else 
        *(point+x) = *(point+*(sim+x)); 
       img1.setPixel(x,y,*(point+x));
      }

 free(point);
 free(sim);
 }

return img1;
}



// Only a first try !
// Doesn't work at all.
/*
QImage KBlinselStereogram::calcback()
{
QImage stgr;
const int maxX = source.width();
const int maxY = source.height();
int line, x, y, mp, sep;
float outd[maxX][maxY];
float eyedst, eyesep, depth, maxdepth;
bool found;

eyedst=5;
eyesep=9;
maxdepth=0;

source = source.convertDepth(8);
stgr.convertDepth(8);
stgr.create(maxX,maxY,8);
stgr.setNumColors(256);

for (x=0; x<256; x++)
 stgr.setColor(x, qRgb(x, x, x));

for (line=0; line<maxY; line++) {
 for (mp=0; mp<maxX; mp++)
  {
  found=FALSE;
  sep=0;
  while (found==FALSE && sep < (int) eyedst)
   {
   sep++;
   if ( mp - sep >= 0) 
   {if ( ( source.pixelIndex(mp+sep,line)) == 
        ( source.pixelIndex(mp-sep,line)) )
       found=TRUE;} else
   {found=TRUE; sep=0;}           
   }

  if (found==FALSE) {depth=0;} else
   depth=eyedst / ((eyesep/(float)sep) - 1.);
  if (depth<0) depth=0;

  if (depth>maxdepth) maxdepth=depth;

  outd[mp][line]=depth;
  }   
 } 

for (x=0; x<maxX; x++)
 for (y=0; y<maxY; y++)
  stgr.setPixel(x,y,(int) ((float)outd[x][y]*(256./(float)maxdepth)) );

return stgr;
}
*/

void KBlinselStereogram::setSource(QImage &img)
{
 source = img;
}

void KBlinselStereogram::setTexture(QImage &texture)
{
 pattern = texture;
}
