/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** misc.cpp
*/



#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define MAX(a,b)	(a < b ? b : a)

#define	HASH_SIZE	500000


void		*memarray[HASH_SIZE];
int		linearray[HASH_SIZE];
const char	*filearray[HASH_SIZE];
const char	*extraarray[HASH_SIZE];

int		max_hash_used = 0;

#define	outstream	stderr

void	addmem(void *vp,const char *file,int line,const char *ex)
{
	int	i;
	
	//fprintf(outstream,"MemAdd %p from File: %s Line %i\n",vp,file,line);
	/*
	for(i = 0;i < max_hash_used;i++)
	{
		if((memarray[i] == vp) && (vp != 0))
		{
			fprintf(outstream,"MemError %p already exists!  Former File: %s Line %i  Current File: %s Line %i\n",vp,filearray[i],linearray[i],file,line);
		}
	}
	*/
	for(i = 0;i < HASH_SIZE;i++)
	{
		if(memarray[i] == 0)
		{
			memarray[i] = vp;
			filearray[i] = file;
			linearray[i] = line;
			extraarray[i] = ex;
			max_hash_used = MAX(max_hash_used,i + 1);
			return;
		}
	}
	fprintf(outstream,"MemError no slot free for %p!\n",vp);
}

void	delmem(void *vp)
{
	int	i;
	
	//fprintf(outstream,"MemDel %p\n",vp);
	for(i = 0;i < max_hash_used;i++)
	{
		if(memarray[i] == vp)
		{
			memarray[i] = 0;
			
			return;
		}
	}
	if(vp != 0)
		fprintf(outstream,"MemError %p not found!\n",vp);
}

void	statmem()
{
	int	i;
	bool	ok = true;
	
	printf("Memory Status:\n");
	for(i = 0;i <= max_hash_used;i++)
	{
		if(memarray[i] != 0)
		{
			printf("  MemStat %p found! File: %s Line %i\n",memarray[i],filearray[i],linearray[i]);
			ok = false;
		}
	}
	if(ok)
		printf("      ok!\n");
	else
		printf("      not ok!\n");
}

void	reportmem()
{
	int	i;
	FILE	*fp;
	
	fp = fopen("MemoryReport.txt","w");
	
	fprintf(fp,"Memory Report:\n\n");
	for(i = 0;i < HASH_SIZE;i++)
	{
		if(memarray[i] != 0)
		{
			fprintf(fp,"%i %p found! File: %s Line %i",i,memarray[i],filearray[i],linearray[i]);
			if(extraarray[i])
				fprintf(fp," %s",extraarray[i]);
			fprintf(fp,"\n");
		}
	}
	
	fclose(fp);
}

void	dbmark(const char *file,int line)
{
	addmem((void*)-4,file,line,"mark");
}

void	dbmark(const char *file,int line,const char *extra)
{
	addmem((void*)-4,file,line,extra);
}

void	dbfree(void *a,const char *file,int line)
{
	free(a);
	delmem(a);
}

void	*dbmalloc(int a,const char *file,int line)
{
	void	*b;
	
	b = malloc(a);
	addmem(b,file,line,"from malloc");
	
	return b;
}

void	*dbrealloc(void *a,int b,const char *file,int line)
{
	void	*c;
	
	c = realloc(a,b);
	delmem(a);
	addmem(c,file,line,"from realloc");
	
	return c;
}

char	*dbstrdup(const char *a,const char *file,int line)
{
	char	*b;
	
	b = strdup(a);
	addmem(b,file,line,b);
	
	return b;
}


#ifdef MEMDEBUG



void	*operator new(size_t s)
{
	void	*b;
	
	b = malloc(s);
	addmem(b,"global new",0,"new");
	
	return b;
}

void	*operator new(size_t s,const char *file,int line)
{
	void	*b;
	
	b = malloc(s);
	addmem(b,file,line,"new");
	
	return b;
}

void	*operator new(size_t s,const char *file,int line,const char *ex)
{
	void	*b;
	
	b = malloc(s);
	addmem(b,file,line,ex);
	
	return b;
}

void	*operator new [] (size_t s)
{
	void	*b;
	
	b = malloc(s);
	addmem(b,"global new",0,"new");
	
	return b;
}

void	*operator new [] (size_t s,const char *file,int line)
{
	void	*b;
	
	b = malloc(s);
	addmem(b,file,line,"new");
	
	return b;
}

void	*operator new [] (size_t s,const char *file,int line,const char *ex)
{
	void	*b;
	
	b = malloc(s);
	addmem(b,file,line,ex);
	
	return b;
}

void	operator delete(void *vp)
{
	free(vp);
	delmem(vp);
}

void	operator delete(void *vp,const char *file,int line)
{
	printf("delete %p from %s in %i\n",vp,file,line);
	
	free(vp);
	delmem(vp);
}

void	operator delete [] (void *vp)
{
	free(vp);
	delmem(vp);
}

void	operator delete [] (void *vp,const char *file,int line)
{
	printf("delete [] %p from %s in %i\n",vp,file,line);
	
	free(vp);
	delmem(vp);
}

#endif


