/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** treelist.cpp
*/

#include <qpoint.h>

#include "treelist.h"
#include "treelist.moc"

#include <stdio.h>

TreeListItem::TreeListItem(QListView *p,int h) :
	QListViewItem(p)
{
	setHeight(h);
}

TreeListItem::TreeListItem(QListView *p,const char* t1,int h) :
	QListViewItem(p,t1)
{
	setHeight(h);
}

TreeListItem::TreeListItem(QListViewItem *p,int h) :
	QListViewItem(p)
{
	setHeight(h);
}

TreeListItem::TreeListItem(QListViewItem *p,const char* t1,int h) :
	QListViewItem(p,t1)
{
	setHeight(h);
}

void		TreeListItem::setHeight(int h)
{
	QListViewItem::setHeight(h);
}

void		TreeListItem::setup()
{
}

/*
const char	*TreeListItem::key(int,bool)
{
	return " ";
}
*/	

void		TreeListItem::clear()
{
	QListViewItem	*lvi;
	
	while((lvi = firstChild()))
	{
		delete lvi;
	}
}




TreeList::TreeList(QWidget *p,char* n) :
	QListView(p,n), QDropSite(viewport())
{
	td = 0;
	
	dragdeltamin = 5;
	renameEdit=NULL;

	setAcceptDrops(TRUE);
}

TreeList::~TreeList()
{
	if(td)
		delete td;
}

void TreeList::addChildItem(QListViewItem *p,QListViewItem *c)
{
	p->insertItem(c);
}

QListViewItem*	TreeList::getRoot()
{
	return firstChild();
}

void	TreeList::addToRoot(QListViewItem *nr)
{
	addChildItem(getRoot(),nr);
}


void	TreeList::startDragCopy(QListViewItem *item,QWidget *dragsource)
{
	if(!item || !dragsource)
		return;

	QPixmap		pixmap;
	QString		str;
	QTextDrag	*drag;

	pixmap = *item->pixmap(0);
	str = item->text(0);

	drag = new QTextDrag(str,dragsource);

	drag->setPixmap(pixmap);
	drag->dragCopy();
}

void	TreeList::startDragMove(QListViewItem *item,QWidget *dragsource)
{
	if(!item || !dragsource)
		return;

	QPixmap		pixmap;
	QString		str;
	QTextDrag	*drag;

	pixmap = *item->pixmap(0);
	str = item->text(0);

	drag = new QTextDrag(str,dragsource);

	drag->setPixmap(pixmap);
	drag->dragMove();
}

void	TreeList::mouseMoveEvent(QMouseEvent *me)
{
	QListViewItem	*li;
        int		i;

	if(button == LeftButton)

	{
		i = abs(mxo - me->x()) + abs(myo - me->y());
		
		if(i < dragdeltamin)
			return;
			
		li = itemAt(QPoint(mxo,myo));
		if(li)
		{
			setSelected(li,TRUE);

			startDragCopy(li,viewport());

			return;
		}
	}

//	QListView::mouseMoveEvent(me);
}

void	TreeList::mousePressEvent(QMouseEvent *me)
{
	QListViewItem	*li;


	button = me->button();
	mxo = me->x();
	myo = me->y();

	if (renameEdit) delete renameEdit;

	li = itemAt(QPoint(mxo,myo));
	if(li) if(li->isSelected()==false)
	{
		setSelected(li,TRUE);
		QListView::mousePressEvent(me);
	} else {
	/*	if (li) {
			QRect qr=itemRect(li);
			int offset=header()->sRect(0)->height();
			renameEdit=new QLineEdit(this);
			renameEdit->setGeometry(qr.left(),qr.top()+offset,qr.width(),qr.height());
			renameEdit->setText(li->text(0));
			renameEdit->show();
		}
	*/
	}
}

void	TreeList::mouseReleaseEvent(QMouseEvent *re)
{
	QListView::mouseReleaseEvent(re);

	button = 0;

	if(re->button() == RightButton)
	{
		QListViewItem	*li;

		li = itemAt(QPoint(re->x(),re->y()));
		if(li)
		{
			setSelected(li,TRUE);
		}

		li = currentItem();

		if(li)
		{
			emit popupMenu(li,re->x(),re->y());
			return;
		}
	}
}

void	TreeList::dragMoveEvent(QDragMoveEvent *dme)
{
	if(QTextDrag::canDecode(dme))
	{
		dme->accept();
	}
	else
	{
		dme->ignore();
	}
}

void	TreeList::dropEvent(QDropEvent *de)
{
	QString		str;

	if(QTextDrag::decode(de,str))
	{
		printf("droped: %s\n",str.data());
	}
}

void	TreeList::dragEnterEvent(QDragEnterEvent *de)
{
	if(QTextDrag::canDecode( de ))
	{
		de->accept();
	}
}

void	TreeList::dragLeaveEvent( QDragLeaveEvent * )
{
    // Give the user some feedback...
}

QListViewItem*	TreeList::findItem(QString str)
{
	return findItem(getRoot(),str);
}

QListViewItem*	TreeList::findItem(QListViewItem *i,QString str)
{
	QListViewItem	*ii;

	if(i->text(0) == str)
		return i;

	if(i->nextSibling())
	{
		if((ii = findItem(i->nextSibling(),str)))
			return ii;
	}
	if(i->firstChild())
	{
		if((ii = findItem(i->firstChild(),str)))
			return ii;
	}

	return 0;
}

void	TreeList::setDragDeltaMin(unsigned int d)
{
	dragdeltamin = d;
}

int	TreeList::getDragDeltaMin()
{
	return dragdeltamin;
}


