/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturebasewidget.cpp
*/
#include "texturebasewidget.h"
#include "texturebasewidget.moc"

#include <kapp.h>
#include <qtooltip.h>

TextureBaseWidget::TextureBaseWidget(QWidget *parent,textureBase *t) :
	QWidget(parent,"TextureBase")
{
	tb=t;

	nlabel=new QLabel(i18n("Name:"),this);
	name=new QLineEdit(this);
	name->setText(tb->getName() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(name,i18n("Name of this texture-object") );
#endif
	connect(name,SIGNAL(returnPressed()),this,SLOT(nameChanged()));


	active=new QCheckBox(i18n("Active"),this);
	active->setChecked(tb->active() );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(active,i18n("If checked, the texture-object will be displayed") );
#endif

	connect(active,SIGNAL(clicked()),this,SLOT(changeActive()));

	tactive=active->isChecked();

	emptyFrame = new QFrame( this,i18n("frame"),0,true );
	emptyFrame->setFrameStyle( QFrame::HLine |QFrame::Raised  );

        paintEvent(NULL);
}

void TextureBaseWidget::nameChanged()
{
	tb->setName(name->text() );
	name->setText(tb->getName() );
	emit valueChanged();
}

void TextureBaseWidget::changeActive()
{
textureBase *p;
	if (tb->getParent()!=NULL) {
		p=tb->getParent();
		tactive=active->isChecked();
		p->setActive(tactive,tb);
	} else {
		tactive=active->isChecked();
		tb->setActive(tactive);

	}
	emit valueChanged();
}

TextureBaseWidget::~TextureBaseWidget()
{
	if (nlabel) delete nlabel;
	if (name) delete name;
	if (active) delete active;
	if (emptyFrame) delete emptyFrame;
}


void TextureBaseWidget::getTextureBase()
{
	tb->setName(name->text() );
	
}

QSize TextureBaseWidget::sizeHint() const
{
	return qs;
}

void TextureBaseWidget::paintEvent(QPaintEvent* qp)
{
int h=name->sizeHint().height();
int x=0;
int w1 = nlabel->sizeHint().width();
int w2 = active->sizeHint().width();
       	
	active->setChecked(tb->active() );

	nlabel->setGeometry(0,0,w1,h);
	name->setGeometry(w1+5,0,120,h);
	x+=130+w1;
	active->setGeometry(x,0,w2,h);

	x+=w2+5;
	h+=5;

	emptyFrame->setLineWidth(x);
	emptyFrame->setGeometry(0,h,x,2);
	
	qs.setHeight(h+5);
	qs.setWidth(x);

	if (qp) QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

TextureBaseDialog::TextureBaseDialog(QWidget *parent,textureBase *b) :
	QDialog(parent,"TextureBaseDialog",true)
{
KLocale *locale=new KLocale();
	setCaption(i18n("Parameters"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new TextureBaseWidget(this,b);

	connect (ok,SIGNAL(clicked()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()) );

	resize(300,220);
	setMinimumSize(300,220);
	setMaximumSize(300,220);
	delete locale;	
}

TextureBaseDialog::~TextureBaseDialog()
{
	if (ok) delete ok;
	if (cancel) delete cancel;
	if (pw) delete pw;
}


void TextureBaseDialog::cancelPressed()
{
	QDialog::done(0);
}

void TextureBaseDialog::okayPressed()
{
	pw->getTextureBase();
	QDialog::done(1);
}

void TextureBaseDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}


