/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
*/
#ifndef __repeatWarpDialog_H__
#define __repeatWarpDialog_H__


#include <qwidget.h>
#include <qcombobox.h>
#include <qdialog.h>
#include "../../3d/textures/repeatwarp.h"
#include "../widgets/vectorwidget.h"
#include <qcombobox.h>

#include "texturebasewidget.h"

#include "texturewidgetbase.h"


class repeatWarpWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	repeatWarp  *wa;

	VectorWidget	*flip,*offset;
	QComboBox	*dir;    //Direction
	SpinBox		*r_dir;   //DirectionLength
	QLabel		*dir_label;


	TextureBaseWidget	*tbasew;
	
	
	QSize			qs;
	
public:

	repeatWarpWidget(QWidget *p, repeatWarp *);
	~repeatWarpWidget();

	void getValue();

	virtual QSize	sizeHint() const;

protected:
	void	paintEvent(QPaintEvent*);

};

//----------------------------------------------------


class repeatWarpDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	repeatWarpWidget		*pw;

public:

	repeatWarpDialog(QWidget *p, repeatWarp *);
	~repeatWarpDialog();

protected:
	void	paintEvent(QPaintEvent*);

public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
