/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** previewwidget.h
*/
#ifndef __PREVIEWWIDGET_H__
#define __PREVIEWWIDGET_H__

//#include <qwidget.h>
#include <qframe.h>
#include <kprocess.h>


#include <texture.h>

class QPainter;
class QPixmap;

class PreviewWidget : public QFrame
{
Q_OBJECT
protected:
	QPainter	*qp;
	QPixmap		*qpm;

	int		quality;
	QString         tmpname,tmpdir;
	KProcess	proc;
	int		tcounter,lc;
	FILE		*ppmfp;
	bool		hollow;
	
	int		x,y;
	texture		*lastrendered;
/*
	double		zoom;
*/	
public:

	PreviewWidget(QWidget *p=0,char *n=0);
	~PreviewWidget();

public slots:

	void	render(texture*);
	void	stop();
	void 	zoomIn();
	void	zoomOut();
	void	originalSize();
	void	setHollow(bool);
	void	setQuick(bool);
	
	void	flush();

protected:

	void	timerEvent(QTimerEvent*);
	void	paintEvent(QPaintEvent*);
	void	resizeEvent(QResizeEvent*);

	void	readImage();
};

#endif


