/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifierdialog.h
*/
#ifndef __PatternModifierDialog_H__
#define __PatternModifierDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>

#include "../../3d/textures/patternmodifier.h"

#include "transformationswidget.h"
#include "turbulencewidget.h"
#include "../widgets/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include "../widgets/getfilewidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qframe.h>
#include <qcheckbox.h>


class SliderWidget;


class PatternModifierWidget : public QWidget
{
Q_OBJECT
protected:
	patternmodifier  *pmod;

	TabWidget	*tab;	
	QLabel		*noOpt;
	SpinBox	*mandelit;
	QWidget *page0,*agatep,*gradientp,*mandelp,*quiltedp,*radialp,*spiral1p,*spiral2p,*densityp;
	SpinBox *arms1,*arms2,*con0,*con1,*agateturb,*radialfreq;	
	VectorWidget *gradvek;
	GetFileWidget	*density;
	QCheckBox	*dinter;
	QSize		qs;
	int 		mode;
	QPushButton		*transformations,*turbulence;

public:

	PatternModifierWidget(QWidget *p=NULL, patternmodifier * pm=NULL, int m=0);
	~PatternModifierWidget();

	void getPatternModifier();
	void	paintEvent(QPaintEvent*);
	virtual QSize	sizeHint() const;
public slots:
	void	changed();
signals:
	void 	sizeChanged();
	void 	valueChanged();

};

//---------------------------------------------------------

class PatternModifierDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton		*ok,*cancel;
	PatternModifierWidget		*nw;
public:

	PatternModifierDialog(QWidget *p, patternmodifier *);
	~PatternModifierDialog();
protected:
	void	paintEvent(QPaintEvent*);

protected slots:
	void okayPressed();
	void cancelPressed();
	void setSize();
};
#endif
