/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normalentrywidget.cpp
*/

#include "normalentrywidget.h"
#include "normalentrywidget.moc"

#include <kapp.h>

NormalEntryWidget::NormalEntryWidget(QWidget *parent,normalEntry *c) :
	TextureWidgetBase(parent,"NormalEntryDialog")
{
	co=c;

	tbasew=new TextureBaseWidget(this,co);
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	pmd=new PatternModifierWidget(this,co->getMapModifier(),0 );

	usePattern=new QCheckBox(i18n("Use Pattern"),this);
	usePattern->setChecked(co->getUsePattern());

	connect(pmd,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	connect(usePattern,SIGNAL(clicked()),this,SIGNAL(usePatternPressed()) );

	range=new SpinBox(this,i18n("Range"),co->getRange());
	range->DownTopValue(0,1);

	connect(range,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );
	paintEvent(NULL);
}

void	NormalEntryWidget::usePatternPressed()
{
	emit valueChanged();
	if (usePattern->isChecked()) pmd->setEnabled(true);
	else pmd->setEnabled(false);
}

void NormalEntryWidget::getValue()
{
	co->setRange( range->getValue() );
	co->setUsePattern(usePattern->isChecked() );
	tbasew->getTextureBase();
}

NormalEntryWidget::~NormalEntryWidget()
{
	if (tbasew) delete tbasew;
}

QSize NormalEntryWidget::sizeHint() const
{
	return qs;
}

void NormalEntryWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();	
int h=tbasew->sizeHint().height();
int y=10,h2=0,w2=0,w1=0;

        tbasew->setGeometry(10,y,w,h);
	y+=h+5;

	h2=range->sizeHint().height();
	w2=range->sizeHint().width();
	range->setGeometry(10,y,w2,h2);

	y += h2 + 15;

	h=usePattern->sizeHint().height();	
	usePattern->setGeometry(10,y,w,h);

	y += h + 10;


	w1=pmd->sizeHint().width();
	h=pmd->sizeHint().height();
        pmd->setGeometry(10,y,w1,h);

	y+=h+5;
        w=MAX(w1,w);

	qs.setHeight(y);
	qs.setWidth(w);	
		
	if (qp) QWidget::paintEvent(qp);

}
//------------------------------------------------------------------------

NormalEntryDialog::NormalEntryDialog(QWidget *parent,normalEntry *c) :
	QDialog(parent,"NormalEntryDialog",true)
{
	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new NormalEntryWidget(this,c);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );
	
	setSize();	
}

NormalEntryDialog::~NormalEntryDialog()
{
}


void NormalEntryDialog::cancelPressed()
{
	QDialog::done(0);
}

void NormalEntryDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void NormalEntryDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);

	QDialog::paintEvent(qp);
}

void NormalEntryDialog::setSize()
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();
	int h1=ok->sizeHint().height();

	resize(w,h+h1+5);
	setMinimumSize(w,h+h1+5);
	setMaximumSize(w,h+h1+5);
}
