/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normaldialog.h
*/
#ifndef __NormalDialog_H__
#define __NormalDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include <color.h>
#include "../../3d/textures/normal.h"
#include "../widgets/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qsize.h>
#include <qlabel.h>
#include <qframe.h>
#include <qcheckbox.h>
#include "patternmodifierdialog.h"
#include "texturewidgetbase.h"
#include "texturebasewidget.h"

class NormalWidget : public TextureWidgetBase
{
Q_OBJECT
protected:

	normal  		*nor;
	PatternModifierWidget 	*pmd;
	TextureBaseWidget	*tbasew;
	QSize 			qs;
	QCheckBox		*usePattern;

public:
	NormalWidget(QWidget *p, normal *);
	~NormalWidget();

	void 	getValue();
	virtual QSize	sizeHint() const;
	void	paintEvent(QPaintEvent*);
protected slots:
	void	usePatternPressed();
};

//---------------------------------------------------------

class NormalDialog : public QDialog
{
Q_OBJECT
protected:
	QPushButton		*ok,*cancel;
	NormalWidget		*pw;
public:

	NormalDialog(QWidget *p, normal *);
	~NormalDialog();

protected:
	void	paintEvent(QPaintEvent*);

protected slots:
	void okayPressed();
	void cancelPressed();
};


#endif
