/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** colorlistdialog.h
*/
#ifndef __COLORListWidget_H__
#define __COLORListWidget_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include <color.h>
#include "../../3d/textures/colorlist.h"
#include <qcolor.h>
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "colorwidget.h"
#include "../widgets/tabwidget.h"

class ColorListWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	colorList *co;
	TabWidget		*tab;
	QComboBox		*combobox;
	QLabel			*l;
	QSize			qs;		
	TextureBaseWidget	*tbasew;

public:

	ColorListWidget(QWidget *p, colorList *);
	~ColorListWidget();

	void 	getValue();
	virtual QSize	sizeHint() const;

protected:
	void	paintEvent(QPaintEvent*);

};

//--------------------------------------------------------

class ColorListDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	ColorListWidget		*pw;

public:

	ColorListDialog(QWidget *p, colorList *);
	~ColorListDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};




#endif
