/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentdialog.h
*/
#ifndef __blackHoleWarpDialog_H__
#define __blackHoleWarpDialog_H__


#include <qwidget.h>
#include <qcheckbox.h>
#include <qdialog.h>
#include "../../3d/textures/blackholewarp.h"
#include "../widgets/vectorwidget.h"
#include <qlabel.h>

#include "texturebasewidget.h"

#include "texturewidgetbase.h"


class blackHoleWarpWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	blackHoleWarp  *wa;
	TextureBaseWidget	*tbasew;	

	VectorWidget 	*location,*repeat,*turbulence;
	SpinBox 	*radius,*falloff,*strength;	
	QCheckBox	*inverse;
	
	QSize			qs;
	
public:

	blackHoleWarpWidget(QWidget *p, blackHoleWarp *);
	~blackHoleWarpWidget();

	void getValue();

	virtual QSize	sizeHint() const;

protected:
	void	paintEvent(QPaintEvent*);

};

//----------------------------------------------------


class blackHoleWarpDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	blackHoleWarpWidget		*pw;

public:

	blackHoleWarpDialog(QWidget *p, blackHoleWarp *);
	~blackHoleWarpDialog();

protected:
	void	paintEvent(QPaintEvent*);

public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
