/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** image.cpp
*/

#include "image.h"
//#include "image.moc"


Image::Image(QWidget *p, bool prv):QWidget(p)
{
	previewOn=prv;
#if (USE_QIMAGEIO == 1)	
	qInitImageIO();
#endif

	if (prv) {
		preview=new QFrame(this);
		preview->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);
		preview->setLineWidth(2);
		preview->setMidLineWidth(2);
		imgWidth=new QLabel(i18n("Width:"),this);
		imgHeight=new QLabel(i18n("Height:"),this);
		imgDepth=new QLabel(i18n("Colors:"),this);
	} else preview=NULL;
	loaded=false;

	paintEvent(NULL);	
}

void Image::load(QString n)
{
QString tmp;
	#ifdef DEBUG
	printf("loading %s\n",(const char *)n);
	#endif
	if (image.load(n)==true) {
		if (previewOn==true) {
			imgWidth->setText(i18n("Width:")+tmp.setNum(image.width() ) );
			imgHeight->setText(i18n("Height:")+tmp.setNum(image.height() ) );
			imgDepth->setText(i18n("Colors:")+tmp.setNum(image.numColors() ) );
			if (image.numColors()==0) imgDepth->setText((QString)i18n("Colors:")+(QString)"16.8M" );
		}
		loaded=true;
	} else {
		imgWidth->setText(i18n("Couldn't load the image") );
		imgHeight->setText(i18n("Either its not an Imagefile or") );
		imgDepth->setText(i18n("the qimageio isn't used") );		
	}
	paintEvent(NULL);
}

Image::~Image()
{
	if (preview) delete preview;
}

int Image::getWidth()
{
	if (loaded==true) {
        	return image.width();
	}
	return 0;
}
	

int Image::getHeight()
{
	if (loaded==true) {
	        return image.height();
	}
	return 0;
}

int Image::getNumColors()
{
	if (loaded==true) {
	        return image.numColors();
	}
	return 0;
}

void 	Image::update()
{
	paintEvent(NULL);
}

QSize Image::sizeHint() const
{	
	return qs;
}

char 	*Image::getExtension()
{
	if (image.numColors()==0) return "jpg";
	else return "png";

}

char 	*Image::getImage(int *l,int w,int h)
{
QString		tmpname,tmpdir,qstr;
QImage		timage;
Preferences 	prefs;
QImageIO 	qio;
bool		success;
char 		*data=NULL;
int 		length=0;
FILE		*f;


	if ((w>0)&&(h>0)) timage=image.smoothScale(w,h);
	else timage=image;

       	tmpdir = prefs.getTempPath();
	tmpname.sprintf("tmpx%i",rand());
	qstr = tmpdir + "/" + tmpname;
	
	if (timage.numColors()==0) success=timage.save(qstr,"JPEG");
	else success=timage.save(qstr,"PNG");

	if (success==false) {
		QMessageBox::information(this,i18n("Error"),i18n("Failed to save a JPEG- or PNG-File\n-Do you have installed QImageIO ?\n-Your QImageIO-Version must support JPEG and PNG !\n- Do you have acces to the /tmp-path ?"),0,0,0);
		return NULL;
	}

	f=fopen( (const char*)qstr,"r");
	if (f) {
		fseek(f,0,SEEK_END);
		length=ftell(f);
		fseek(f,0,SEEK_SET);		
		data=(char *)malloc(length);
		fread(data,1,length,f);
		if (l) *l=length;
		fclose(f);
	}

	qstr = "rm -f " + tmpdir + "/" + tmpname;
	system(qstr);

	return data;
}


QImage Image::getImage(int w,int h)
{
QImage		timage;

	if ((w>0)&&(h>0)) timage=image.smoothScale(w,h);
	else timage=image;

	return timage;
}


void Image::setImage(char *data,int l)
{
QBuffer		buffer;
QImageIO 	qio;
QByteArray	qb;

	if ((!data)||(l==0)) return;

	image.loadFromData( (uchar*)data,(uint)l);	

	paintEvent(NULL);
}

void	Image::paintEvent(QPaintEvent *qp)
{
QPixmap qpix;
QPainter p;
int w=0,w1=0, y=0,h=0;
	if (preview) {
               	h=imgWidth->sizeHint().height();
		w=imgWidth->sizeHint().width();
		imgWidth->setGeometry(10+h*3+20,y,w,h);

		w1=w;

		w=imgHeight->sizeHint().width();
		imgHeight->setGeometry(10+h*3+20,y+h+5,w,h);
		w1=MAX(w1,w+10+h*3+20);

		w=imgDepth->sizeHint().width();
		imgDepth->setGeometry(10+h*3+20,y+h+h+10,w,h);
		w1=MAX(w1,w+10+h*3+20);

		preview->setGeometry(0,0,h*3+15,h*3+15 );
		w1=MAX(w1,w+10+h*3+20);

		y+=h*3+20;

	}
	if ((previewOn)&&(preview)&&(loaded==true)) {

		previewImage=image.smoothScale(preview->width()-2,preview->height()-2);
		qpix.convertFromImage(previewImage);
		p.begin(preview);
		p.drawPixmap(1,1,qpix);
		p.end();			
		
        }
	qs.setWidth(w1);
	qs.setHeight(y);			
	if ((qp)&&(preview)) QWidget::paintEvent(qp);
}
