/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** comm.h
*/
#ifndef __COMM_H__
#define __COMM_H__

#include <qobject.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include <communication.h>

class Comm : public QObject, public com
{
Q_OBJECT
protected:
	int		stack[24][5]; // 0/1 pipe 1, 2/3 pipe 2, 4 pid
	int		stackptr;
	
	char		buffer[2048];


public:
	Comm();
	~Comm();

	int	start(char *script,int time = 0,int start = 0,int end = 1000,int stepsize = 40);
	int	stop();
	int	clear();
	int	read(char *s);
	int	write(char *s);

	int	isRunning();
};


#endif


