/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** map2mesh.h
*/
#ifndef __MAP2MESH_H__
#define __MAP2MESH_H__

#include <objects.h>
#include <qstring.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#include "../widgets/getfilewidget.h"

class Map2MeshDialog : public QDialog
{
Q_OBJECT
protected:
//	QString		fn;
//	QString		mapfilename;
	double		multiplier;
	int		w,h,p;
        smesh		*meshobj;
        base		*parent;

        QLabel		*lfn;
        QLineEdit	*efn;
        GetFileWidget	*gfw;
        QLabel		*lsize;
        QLineEdit	*ewidth;
        QLineEdit	*eheight;
        QLabel		*lmul;
        QLineEdit	*emul;

	QButtonGroup	*projection;
	QRadioButton	*spherical;
	QRadioButton	*cylindrical;
	QRadioButton	*torical;
	QRadioButton	*boxed;
	QRadioButton	*planar;

	QPushButton	*ok,*cancel;
	
public:
	Map2MeshDialog(base *pbase=0,QWidget* pw=0);
	~Map2MeshDialog();

	smesh		*getObject();
	void		setObject(smesh *);
	
private:
	void		layout();
	double		calculateRadius(const char *,int x,int y);
	double		calculateImageOffset(QImage,int x,int y);
	
private slots:
	void		setProjection(int);
	void		paintEvent(QPaintEvent*);
};


#endif


