/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** recursivtree.h
*/
#ifndef __FORESTGENERATOR_H__
#define __FORESTGENERATOR_H__

#include <objects.h>
#include <evaluate.h>

#include <qstring.h>
#include <qdialog.h>


class QLabel;
class QLineEdit;
class QPushButton;
class QComboBox;
class QListView;
class QListView;

class ForestGeneratorDialog : public QDialog
{
Q_OBJECT
protected:
	QString		name;
	QString		fn;
	heightfield	*floor;
	int		xmax,zmax,xmin,zmin;
	int		numtrees;

	
	int		d;
        obj		*objptr;

        QPixmap		**pmap;

        QLabel		*lex;
        QComboBox	*cex;
	QPushButton	*del,*save;
        QLabel		*lfn;
        QLineEdit	*efn;
        QLabel		*ldepth;
        QLineEdit	*edepth;
        QLabel		*lname;
        QLineEdit	*ename;

        QListView	*tlol;		// TopLevelObjectList

	QPushButton	*ok,*cancel;
	
	int		objcounter,numobj;
	
public:
	ForestGeneratorDialog(QPixmap **,obj *obj,QWidget* pw=0);
	~ForestGeneratorDialog();
	
	void		getObject();
	
private:
	void		layout();
	int		parseObjects(const char *unformated,obj *object,paralist_t *plist);
	int		createObject();
	void		createList();
	void		setObject();
	
private slots:
	void		paintEvent(QPaintEvent*);
	void		selectedExample(int);
	void		savedExample();
	void		deletedExample();
	void		initExamples();

signals:
	void		report(QString);
};


#endif


