/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturebase.cpp
*/
#include "texturebase.h"
#include <chunk.h>

imageConverter	*textureBase::imgConvert = 0;


const char *TBunknownPic[] = {
"5 9 2 1",
" 	c None",
".	c #000000",
"     ",
".. . ",
"   ..",
"   . ",
"  .  ",
" .   ",
"     ",
"..   ",
".    "};

const char *TBYellowFolderPic[]={
"15 13 6 1",
"d c #000000",
"b c #ffff00",
". c None",
"# c #999999",
"a c #cccccc",
"c c #ffffff",
"..#####........",
".#ababa#.......",
"#abababa######.",
"#cccccccccccc#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"#cabababababa#d",
"#cbababababab#d",
"##############d",
".dddddddddddddd"};

textureBase::textureBase(ttyp t,textureBase *tb):chunk()
{
	parent = tb;
	name = 0;
	author = 0;
	name = strdup("Unnamed");
	author = strdup("unknown");
	description = 0;//strdup("");
	flags = 0;
	ptr = 0;//strdup("");
	typ = t;
	locks = 0;
	elementnr = 0;

	subitems = false;
	setActive(true,tb);

	info = 0;
	open = true;
	selected = false;

	setInfo("No info avaiable");
}

textureBase::~textureBase()
{
	int	i;

	for(i = 0;i < elements.length();i++)
	{
		delete elements[i];
	}
	elements.empty();

	addableItems.empty();

	if(name)
		free(name);
	if(info)
		free(info);
	if(author)
		free(author);
	if(description)
		free(description);
}

const 	char	*textureBase::getTypeName()
{
	return getTypeName(typ);
}

const 	char	*textureBase::getTypeName(int ttyp)
{
char	*ttypeNames[]= {	"a_Color",
				"a_Colormap",
				"a_Colorlist",
				"b_Pigmentmap",
				"b_Pigmentlist",
				"c_Imagemap",
				"a_Pigment",
				"a_Bumpmap",
				"b_Normal",
				"a_Texture",
				"a_Texturelibrary",
				"c_Finish",
				"d_Media",
				"b_Interior",
				"a_Texturebook",
				"x_Bitmapmodifier",
				"z_Transformations",
				"x_Mapmodifier",
				"z_Turbulence",
				"x_Patternmodifier",
				"a_Colorentry",
				"a_Density",
				"b_Normalmap",
				"b_Normallist",
				"a_Slopeentry",
				"a_Slopemap",
				"a_Surface",
				"a_Normalentry",
				"a_Surfaceentry",
				"b_Surfacelist",
				"b_Surfacemap",	
				"a_Pigmententry",
				"z_Warp",
				"a_Repeatwarp",
				"a_Blackhole Warp",
				"a_Undefined Name"
	    	       };



	if (ttyp<=UNDEFINEDTI) return ttypeNames[ttyp];
	else return ttypeNames[UNDEFINEDTI];
}

void 	textureBase::addAddableItem(ttyp x,bool y)
{
	addableItems.append(x);
	GUIaddable.append(y);
}

textureBase *textureBase::getFirstElement()
{
#ifdef DEBUG
	printf("Getting first %s-Element (typ:%d) (length=%d)\n",getName(),typ,elements.length());
#endif
	elementnr=0;
	if (elements.length()==0) return NULL;
	return elements[0];
	
}

textureBase *textureBase::getNextElement()
{
	elementnr++;
	if (elementnr>=elements.length()) return NULL;

#ifdef DEBUG
	printf("Getting next %s-Element (typ:%d)(%d,%d)\n",getName(),typ,elementnr,elements.length() );
#endif
	return elements[elementnr];

}


void textureBase::setSelected(bool a)
{
	selected=a;
}

bool textureBase::isSelected()
{
	return selected;
}

void textureBase::setOpen(bool a)
{
	open=a;
}

bool textureBase::isOpen()
{
	return open;
}

const char *textureBase::getInfo()
{
	return info;
}

void textureBase::setInfo(char *t)
{
	if(info)
		free(info);
	info = strdup(t);
}

void textureBase::setParent(textureBase *t)
{
	parent = t;
	if(t)
	//	setName(strdup(getName())); // Namen berprfen
		setName(getName());	// Sollte in setName angelegt werden; TW 7.11.99
}

textureBase *textureBase::getParent()
{
	return parent;
}

const char **textureBase::getXPM()
{
	if (subitems==false) return TBunknownPic;
	return TBYellowFolderPic;
}

textureBase *textureBase::getElementByType(ttyp t)
{
textureBase *tb=getFirstElement();
	if (!tb) return NULL;
	if (getType()==TEXTUREBOOK) return NULL;
	if (t==getType()) return this;
	while (tb!=NULL) {
		if ((tb->getType()==t)&&(tb->active()==true)) return tb;
		if ((tb->hasSubItems()==true)&&(tb->getType()!=TEXTUREBOOK)) {
			textureBase *tb2=tb->getElementByType(t);
			if (tb2) return tb2;
		}
		tb=getNextElement();
	}
	return NULL;
}


void textureBase::addElement(textureBase *what, textureBase *where)
{
int t=0,i;
	if (!what) return;
	what->setParent(this);
	what->setActive(true);
	t=what->getType();
	switch(t) {
		case TRANSFORMATIONS:
			if (canAdd(TRANSFORMATIONS)==true) {
				for (i=0;i<elements.length();i++){
					if (elements[i]->getType()==TRANSFORMATIONS) {
						elements[i]->setActive(false,NULL);
					}
				}			
				elements.append(what);
			}
		break;
		case TURBULENCEMODIFIER:
			if (canAdd(TURBULENCEMODIFIER)==true) {
				for (i=0;i<elements.length();i++){
					if (elements[i]->getType()==TRANSFORMATIONS) {
						elements[i]->setActive(false,NULL);
					}
				}			
				elements.append(what);
			}
		break;
		default:
			if (canAdd(what)==true)	elements.append(what);
		break;
	}
	
}

void textureBase::clearElements()
{
int i;
	for(i = 0;i < elements.length();i++)
	{
		delete elements[i];
	}
	elements.empty();

}

int textureBase::exportPOV(FILE *fp,int tab, int tabsize, int a,bool d)
{
int i;
#ifdef DEBUG
	printf("Exporting Texturebase-Elemnts (POV)\n");
#endif;			
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==WARP)) elements[i]->exportPOV(fp,tab,tabsize,a,false);
	}
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TURBULENCEMODIFIER)) elements[i]->exportPOV(fp,tab,tabsize,a,false);	
	}
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TRANSFORMATIONS)) elements[i]->exportPOV(fp,tab,tabsize,a,false);
	}
		
#ifdef DEBUG
	printf("Exported Texturebase-Elemnts (POV)\n");
#endif
	return 0;
}

bool textureBase::isEqual(textureBase *tb)
{
textureBase *tb1;
int i;
#ifdef DEBUG
	printf("Comparing Texturebase (%s)..\n",getName());
#endif
	if (!tb) return false;
	if (tb->getType()!=getType()) return false;

	if ((name)&&(!tb->getName()) ) return false;
	if ((!name)&&(tb->getName()) ) return false;
	if ((strcmp(name,tb->getName()))) return false;

	tb1=tb->getFirstElement();
	if ( ( (tb1==NULL)&&(elements.length()==0) ) ) return true;
	for (i=0;i<elements.length();i++) {
     		if (tb1==NULL) return false;
		if (tb1->isEqual(elements[i])==false) return false;
		tb1=tb->getNextElement();		
	}
#ifdef DEBUG
	printf("Compared Texturebase (%s)..found it !\n",getName());
#endif
	return true;

}

const char *textureBase::getPath()
{
	char *buf = new char[512];
	
	strcpy(buf,name);
	if(parent == 0)
	{
		return buf;
	}
	else
	{	
		strcat(buf,"/");
		strcat(buf,parent->getPath());
		
		return buf;
	}
}

bool textureBase::active()
{
	return Active;
}

void textureBase::setActive(bool a, textureBase *t)
{
	Active=a;
}

bool textureBase::hasSubItems()
{
	return subitems;
}

void textureBase::setSubItems(bool a)
{
	subitems=a;
}

bool textureBase::canAdd(textureBase *t)
{
int i;
	for(i = 0;i < addableItems.length();i++)
	{
		if ((GUIaddable[i]==true)&&(addableItems[i]==t->getType())) return true;
	}
	return false;
}

bool textureBase::canAdd(ttyp t)
{
int i;

	for(i = 0;i < addableItems.length();i++)
	{
		if ((GUIaddable[i]==true)&&(addableItems[i]==t)) return true;
	}
	return false;
}

bool textureBase::canDrop(textureBase *t)
{
int i;
	for(i = 0;i < addableItems.length();i++)
	{
		if (addableItems[i]==t->getType()) return true;
	}
	return false;
}

bool textureBase::canDrop(int t)
{
int i;
	for(i = 0;i < addableItems.length();i++)
	{
		if (addableItems[i]==t) return true;
	}
	return false;
}


void textureBase::add(textureBase *what)
{
	return;
}

int textureBase::load(media *m,int l)
{

	setName(readName());
	m->read(&typ,sizeof(int));
	m->read(&Active,sizeof(bool));
	return 0;
}

int textureBase::save(media *m)
{

chunk c;

	c.setMedia(m);
	c.writeChunk("BASE");

		writeName(name);
		m->write(&typ,sizeof(int));
		m->write(&Active,sizeof(bool));
	c.writeChunkLen();
	return 0;
}

void textureBase::alloc()
{
	locks++;
}

bool textureBase::isLocked()
{
	if (locks>0) return true;
	return false;
}

void textureBase::deAlloc()
{
	locks--;
	if (locks<0) locks=0;
}

void textureBase::remove(textureBase *tb)
{
int i;
	if (!tb) return;
	for (i=0;i<elements.length();i++) {
		#ifdef DEBUG
			printf("Can I delete %d ?\n",i);
		#endif
		if (tb->isEqual(elements[i])) {
			elements.deleteAt(i);			
			#ifdef DEBUG
				printf("Deleted\n");
			#endif
			return;
		}
	}
}

void textureBase::setName(const char *n)
{
	textureBase	*tb;
	char		buffer[1024];
	const char	*tmpname;
	char		*tmpname2;

	int		c = 0;
	
	if(n == 0)
		return;
		
	tmpname2 = name;
	name = 0;
	
	if(parent == 0)
	{
		name = strdup(n);
		
		if(tmpname2)
			free(tmpname2);
			
		return;
	}
	
	tb = parent->getFirstElement();

	sprintf(buffer,"%s",n);

	while(tb != 0)
	{
		tmpname = tb->getName();
		if(tmpname && (!(strcmp(tmpname,buffer))) && (tb != this))
		{
			c++;
			sprintf(buffer,"%s.%d",n,c);	
			tb = parent->getFirstElement();
		}
		else
			tb = parent->getNextElement();
	}
	
	name = strdup(buffer);
	
	if(tmpname2)
		free(tmpname2);
}

const char *textureBase::getName()
{
	return name;
}

void textureBase::setPtr(const char *n)
{
	if (ptr) free( (void*)ptr);
	ptr=strdup(n);
}

ttyp textureBase::getType()
{
	return typ;
}	

const char *textureBase::getPtr()
{
	return ptr;
}

void	textureBase::initializeImageConverter(imageConverter *imgconv)
{
	if(imgConvert)
		free(imgConvert);

	imgConvert = imgconv;
}

imageConverter *textureBase::getImageConverter()
{
	return imgConvert;
}

