/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surface.h
*/
#ifndef __SURFACEENTRY_H__
#define __SURFACEENTRY_H__

#include "texturebase.h"


#include "pigment.h"
#include "normal.h"
#include "finish.h"
#include <stdio.h>
#include <dim.h>
#include "patternmodifier.h"

#include "transformations.h"
#include "turbulence.h"



class surfaceEntry : public textureBase
{
protected:
	int 			layer;
	double 			range;

	void 		updateInfo();

public:
	surfaceEntry(textureBase *t=NULL);
	~surfaceEntry();

	void setRange(double);
	double getRange();

	int 		getLayer();
	void		setLayer(int );

	bool		isEqual(textureBase *);

	void		addElement(textureBase *,textureBase *a=NULL);
	void		add(textureBase *);
	bool		canAdd(textureBase *);
	
	void		setActive(bool a,textureBase *tb);
	
	const char 	**getXPM();

	int		save(media*);
	int		load(media*,int);

	int		exportPOV(FILE*,int x,int y,int z,bool e);
};

#endif

