/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normalmap.h
*/
#ifndef __NORMALMAP_H__
#define __NORMALMAP_H__

#include <chunk.h>
#include <list.h>
#include "normalentry.h"
#include "patternmodifier.h"


class normalEntry;
class normal;

class normalMap : public textureBase
{
protected:
	patternmodifier	modifier;
	void 	updateInfo();
public:
	normalMap(textureBase *p=NULL);
	~normalMap();

	patternmodifier *getMapModifier();

	void		clearNormalMap();
	void 		sortNormalMap();

	void 		addElement(textureBase* what,textureBase *x);
	void		add(textureBase*);

	bool		isEqual(textureBase*);
	
	int		load(media *,int);
	int		save(media *);
	int		exportPOV(FILE *,int,int,int,bool);
};


#endif


