/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normal.h
*/
#ifndef __NORMAL_H__
#define __NORMAL_H__

#include "bumpmap.h"
#include "slopemap.h"
#include "patternmodifier.h"
#include "string.h"
#include "texturebase.h"
#include "transformations.h"
#include "turbulence.h"

class normalMap;

class normal :public textureBase
{

protected:
	patternmodifier	modifier;
	Transformations transform;
	Turbulence	turbulence;
	bool		usePattern;
public:

	normal(textureBase *p=NULL);
	~normal();

	patternmodifier 	*getMapModifier();

        void	setUsePattern(bool);
	bool	getUsePattern();
	

	void	addElement(textureBase *,textureBase *a=NULL);

	void	setActive(bool a,textureBase *tb);

	bool	isExportable();

	void	add(textureBase *);

	bool	isEqual(textureBase *);

	int	load(media*,int);
	int	save(media*);

	int	exportPOV(FILE*,int,int,int,bool);
};
#endif