/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** color.h
*/
#ifndef __COLOR_H__
#define __COLOR_H__

#include <misc.h>
#include <list.h>
#include "texturebase.h"
#include "colorentry.h"
#include <stdio.h>
#include <string.h>

class color:public textureBase
{
protected:

	double	r,g,b,t,f;
	char *PicBuf[30];

	void updateInfo();

public:

	color(textureBase *p);	

	~color();

	double	red();
	double	green();
	double	blue();
	double	transparency();
	double	filter();

	void	setRed(double);
	void	setGreen(double);
	void	setBlue(double);
	void	setTransparency(double);
	void 	setFilter(double);

	bool	isEqual(textureBase *);
	void	add(textureBase *);

	const char **getXPM();

	int	save(media*);
	int	load(media*,int);

	int	exportPOV(FILE*,int,int,int,bool);
};

#endif
