/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bumpmap.h
*/
#ifndef __BUMPMAP_H__
#define __BUMPMAP_H__

#include <misc.h>

#include <stdio.h>
#include <stdlib.h>
#include "texturebase.h"
#include "bitmapmodifier.h"
#include "../classes/imageconverter.h"

class bumpMap:public textureBase
{
protected:

	const char *Filename;
	const char *Filetype;
	char	*realFileName;
	char	*realFileType;
	double bumpSize;
	bool useColor;
	bitmapmodifier	modifier;
	
	char		*picData;
	int		picLen;

	void updateInfo();
public:

	bumpMap(textureBase* p=NULL);
	~bumpMap();


	const char	*getBumpMapFilename();
	void	setBumpMapFilename(const char *);

	const char	*getBumpMapFiletype();
	void	setBumpMapFiletype(const char *);
	
	double	getBumpSize();
	void	setBumpSize(double);

	bitmapmodifier *getModifier();

	void 	setBumpUseColor();
	void 	setBumpUseIndex();
	bool 	getBumpUseColor();
	bool 	getBumpUseIndex();

	bool	isExportable(); //Machts Sinn dieses Element zu exportieren ?

	void	add(textureBase *);
	bool	isEqual(textureBase *);

	int	save(media*);
	int	load(media*,int);

	int	exportPOV(FILE*,int,int, int,bool);
};


#endif


