/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bitmapmodifier.cpp
*/
#include "bitmapmodifier.h"
#include <chunk.h>

bitmapmodifier::bitmapmodifier(textureBase *p):textureBase(BITMAPMODIFIER,p)
{
	setName("Bitmapmodifier");
	setInfo("Bitmapmodifier");
	setSubItems(false);
	once=1;
	map_type=0;
	interpolate=2;
}

bitmapmodifier::~bitmapmodifier()
{
}

void	bitmapmodifier::setOnce()
{
	once=1;
}
void	bitmapmodifier::unSetOnce()
{
	once=0;
}
int	bitmapmodifier::getOnce()
{
	return once;
}
int	bitmapmodifier::getMapType()
{
	return map_type;
}
int	bitmapmodifier::getInterpolate()
{
	return interpolate;
}
void	bitmapmodifier::setInterpolate(int i)
{
	interpolate=i;
}
void	bitmapmodifier::setMapType(int m)
{
	map_type=m;
}

bool	bitmapmodifier::canAdd(textureBase *t)
{
	if (t->getType()==BITMAPMODIFIER) return true;
	else return false;
}

void	bitmapmodifier::add(textureBase *t)
{
bitmapmodifier *b=(bitmapmodifier *)t;
	if (t->getType()!=BITMAPMODIFIER) return;
	if (b->getOnce()==1) setOnce();
	else unSetOnce();
	setMapType(b->getMapType());
	setInterpolate(b->getInterpolate() );
		
}

bool 	bitmapmodifier::isEqual(textureBase *t)
{
bitmapmodifier *b=(bitmapmodifier *)t;
	if (t->getType()!=BITMAPMODIFIER) return false;
	if (	
		(getInterpolate()==b->getInterpolate() ) &&
		(b->getOnce()==getOnce() ) &&
		(textureBase::isEqual(t)==true) &&
		(b->getMapType()==getMapType() )
	) return true;
	return false;
}

int	bitmapmodifier::save(media *m)
{
chunk ch;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving BitmapModifier\n");
	#endif

	setMedia(m);

	writeChunk("BITM");

	textureBase::save(m);
	ch.setMedia(m);
	ch.writeChunk("DATA");

		m->write(&once, sizeof(int));
		m->write(&map_type, sizeof(int));
		m->write(&interpolate, sizeof(int));
	ch.writeChunkLen();
	writeChunkLen();

	#ifdef DEBUG
		printf("BitmapModifier saved\n");
	#endif
	return 0;
}

int	bitmapmodifier::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	#ifdef DEBUG
		printf("Loading Bitmapmodifier\n");
	#endif

	if(!m) return -1;

	setMedia(m);

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&once, sizeof(int));
			m->read(&map_type, sizeof(int));
			m->read(&interpolate, sizeof(int));

			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("Bitmapmodifier loaded\n");
	#endif
	return 0;
}

int bitmapmodifier::exportPOV(FILE *fp,int tab,int tabsize, int anim)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting Bitmapmodifer (POV)\n");
	#endif

	if (once!=0) {
		printTab(fp,tab+tabsize);
		fprintf(fp,"once\n");	
	}
	if (interpolate!=0) {
		printTab(fp,tab+tabsize);
		fprintf(fp,"interpolate %d\n",interpolate);	
	}
	if (map_type!=0) {
		printTab(fp,tab+tabsize);
		fprintf(fp,"map_type %d\n",map_type);	
	}
	textureBase::exportPOV(fp,tab,tabsize,anim);
	#ifdef DEBUG
		printf("BitmapModifier exported (POV) saved\n");
	#endif
	return 0;
}

