/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** world.h
*/
#ifndef __WORLD_H__
#define __WORLD_H__

#include <classes.h>

#include "refptr.h" 
#include "ref.h"

#include "view.h"
#include "ear.h"

#include <texturelibrary.h>

class world : public base
{
protected:
	list<ref*>	referencelist;
	list<body*>	objectlist;
	list<view*>	viewlist;
	list<ear*>	earlist;

	TextureLibrary	*tlib;

	Vector3		ambient_light;
	double		assumed_gamma;
	Vector3		background_color;

public:
	world(const char *n = "Untitled");
	world(world *wc);
	~world();

	base		*copy();

	int		addView(view *v);
	view		*getView(char *name);
	view		*getView(int);
	int		removeView(view *v);
	int		removeView(int);
 	int		getNumViews();
	int		getViewPosition(view *v);

	int		addEar(ear *e);
	ear		*getEar(char *name);
	ear		*getEar(int);
	int		removeEar(ear *e);
	int		removeEar(int);
 	int		getNumEars();
	int		getEarPosition(ear *e);
	
	TextureLibrary	*getTextureLibrary();

	// temporre Funktion bis texturemap->copy()
	void		setTextureMapNull()
	{
		tlib = 0;
	}
 
	virtual void	dumpNames(int tabsize = 2); 
	virtual void	dumpNames(int,int); 
 
	virtual int	save(media*,int);
	virtual int	load(media*,int,int);
 
	virtual int	exportPOV(FILE*,int tab,int tabsize,int);
		int	exportPOV(int,FILE*,int tab,int tabsize,int);

	virtual int	addToParent(base *parent);
	virtual int	removeFromParent();

	virtual bool	acceptChild(body *child);
	virtual bool	acceptChild(csgobj *child);
	virtual bool	acceptChild(blobobj *child);
	virtual bool	acceptChild(nonsolid *child);
	virtual bool	acceptChild(refptr *child);
	virtual bool	acceptChild(ref *child);

	virtual int	addChild(body *child);
	virtual int	addChild(csgobj *child);
	virtual int	addChild(blobobj *child);
	virtual int	addChild(nonsolid *child);
	virtual int	addChild(refptr *child);
	virtual int	addChild(ref *child);

	virtual int	removeChild(base *child);
	virtual int	removeChild(body*); 
	virtual int	removeChild(refptr*); 
	virtual int	removeChild(ref*); 
	virtual int	removeChild(csgobj*); 
	virtual int	removeChild(blobobj*); 
//	virtual int	removeChild(sphere*) {return -1;}; 
//	virtual int	removeChild(cylinder*) {return -1;}; 
	virtual int	removeChild(nonsolid*);  

	virtual void	getChildren(base ***b);
	virtual int	numChildren();

	virtual int	existsName(const char *n);
	virtual base	*searchName(const char *n);

	virtual int	draw(view*,Matrix44,int); 
	virtual int	calculate(int anim = 0); 

	Vector3		getAmbientLight();
	void		setAmbientLight(double r,double g,double b);
	void		setAmbientLight(Vector3);
	void		setAmbientLight(double);

	Vector3		getBackgroundColor();
	void		setBackgroundColor(double r,double g,double b);
	void		setBackgroundColor(Vector3);
};

#endif

